/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FeatureDataset
implements FeatureCollection {
    private FeatureSchema featureSchema;
    private ArrayList features;
    private Envelope envelope = null;

    public FeatureDataset(Collection collection, FeatureSchema featureSchema) {
        this.features = new ArrayList(collection);
        this.featureSchema = featureSchema;
    }

    public FeatureDataset(FeatureSchema featureSchema) {
        this(new ArrayList(), featureSchema);
    }

    public Feature getFeature(int n) {
        return (Feature)this.features.get(n);
    }

    public FeatureSchema getFeatureSchema() {
        return this.featureSchema;
    }

    public Envelope getEnvelope() {
        if (this.envelope == null) {
            this.envelope = new Envelope();
            Iterator iterator = this.features.iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
            }
        }
        return this.envelope;
    }

    public List getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public List query(Envelope envelope) {
        if (!envelope.intersects(this.getEnvelope())) {
            return new ArrayList();
        }
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        Iterator iterator = this.features.iterator();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            if (!feature.getGeometry().getEnvelopeInternal().intersects(envelope)) continue;
            arrayList.add(feature);
        }
        return arrayList;
    }

    public void add(Feature feature) {
        this.features.add(feature);
        if (this.envelope != null) {
            this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
        }
    }

    public boolean contains(Feature feature) {
        return this.features.contains(feature);
    }

    public Collection remove(Envelope envelope) {
        List list = this.query(envelope);
        this.removeAll(list);
        return list;
    }

    public void remove(Feature feature) {
        this.features.remove(feature);
        this.invalidateEnvelope();
    }

    public void clear() {
        this.invalidateEnvelope();
        this.features.clear();
    }

    public int size() {
        return this.features.size();
    }

    public void invalidateEnvelope() {
        this.envelope = null;
    }

    public void addAll(Collection collection) {
        this.features.addAll(collection);
        if (this.envelope != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                this.envelope.expandToInclude(feature.getGeometry().getEnvelopeInternal());
            }
        }
    }

    public void removeAll(Collection collection) {
        this.features.removeAll(collection);
        this.invalidateEnvelope();
    }
}

