/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys.impl;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.Radius;
import com.vividsolutions.jump.coordsys.Spheroid;
import com.vividsolutions.jump.coordsys.impl.Albers;
import com.vividsolutions.jump.coordsys.impl.LatLong;
import com.vividsolutions.jump.coordsys.impl.UniversalTransverseMercator;

public class PredefinedCoordinateSystems {
    public static final CoordinateSystem BC_ALBERS_NAD_83 = new CoordinateSystem("BC Albers / NAD 83", 42102, new Albers(){
        {
            this.setSpheroid(new Spheroid(new Radius(0)));
            this.setParameters(-126.0, 50.0, 58.5, 45.0, 1000000.0, 0.0);
        }
    });
    public static final CoordinateSystem GEOGRAPHICS_WGS_84 = new CoordinateSystem("Geographics / WGS 84", 4326, new LatLong());
    public static final CoordinateSystem UTM_07N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(7);
    public static final CoordinateSystem UTM_08N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(8);
    public static final CoordinateSystem UTM_09N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(9);
    public static final CoordinateSystem UTM_10N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(10);
    public static final CoordinateSystem UTM_11N_WGS_84 = PredefinedCoordinateSystems.createUTMNorth(11);

    private PredefinedCoordinateSystems() {
    }

    private static CoordinateSystem createUTMNorth(final int n) {
        Assert.isTrue(1 <= n && n <= 60);
        return new CoordinateSystem("UTM " + (n < 10 ? "0" : "") + n + "N / WGS 84", 32600 + n, new UniversalTransverseMercator(){
            {
                this.setSpheroid(new Spheroid(new Radius(0)));
                this.setParameters(n);
            }
        });
    }
}

