/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys.impl;

import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Planar;
import com.vividsolutions.jump.coordsys.Projection;
import com.vividsolutions.jump.coordsys.impl.MeridianArcLength;

public class Polyconic
extends Projection {
    double L0;
    double k0;
    double phi1;
    double phi2;
    double phi0;
    double X0;
    double Y0;
    int zone;
    MeridianArcLength S = new MeridianArcLength();
    Geographic q = new Geographic();

    public void setParameters(double d, double d2) {
        this.L0 = d2 / 180.0 * Math.PI;
        this.phi0 = d / 180.0 * Math.PI;
    }

    public Planar asPlanar(Geographic geographic, Planar planar) {
        this.q.lat = geographic.lat / 180.0 * Math.PI;
        this.q.lon = geographic.lon / 180.0 * Math.PI;
        this.forward(this.q, planar);
        return planar;
    }

    public Geographic asGeographic(Planar planar, Geographic geographic) {
        this.inverse(planar, geographic);
        geographic.lat = geographic.lat * 180.0 / Math.PI;
        geographic.lon = geographic.lon * 180.0 / Math.PI;
        return geographic;
    }

    public void forward(Geographic geographic, Planar planar) {
        this.S.compute(this.currentSpheroid, geographic.lat, 0);
        double d = this.S.s;
        this.S.compute(this.currentSpheroid, this.phi0, 0);
        double d2 = this.S.s;
        double d3 = this.currentSpheroid.a;
        double d4 = this.currentSpheroid.e;
        double d5 = d4 * d4;
        double d6 = Math.sin(geographic.lat);
        double d7 = d3 / Math.sqrt(1.0 - d5 * d6 * d6);
        double d8 = (geographic.lon - this.L0) * Math.sin(geographic.lat);
        d6 = 1.0 / Math.tan(geographic.lat);
        planar.x = d7 * d6 * Math.sin(d8);
        planar.y = d - d2 + d7 * d6 * (1.0 - Math.cos(d8));
    }

    public void inverse(Planar planar, Geographic geographic) {
        double d;
        double d2;
        double d3 = this.currentSpheroid.getA();
        double d4 = this.currentSpheroid.getE();
        double d5 = d4 * d4;
        this.S.compute(this.currentSpheroid, this.phi0, 0);
        double d6 = this.S.s;
        double d7 = (d6 + planar.y) / d3;
        double d8 = planar.x * planar.x / (d3 * d3) + d7 * d7;
        geographic.lat = d7;
        int n = 0;
        do {
            d2 = geographic.lat;
            d = Math.sqrt(1.0 - d5 * Math.sin(d2) * Math.sin(d2)) * Math.tan(d2);
            this.S.compute(this.currentSpheroid, d2, 0);
            double d9 = this.S.s;
            double d10 = d9 / d3;
            double d11 = d10 * d10;
            this.S.compute(this.currentSpheroid, d2, 1);
            double d12 = this.S.s;
            double d13 = Math.sin(2.0 * d2);
            geographic.lat -= (d7 * (d * d10 + 1.0) - d10 - 0.5 * (d11 + d8) * d) / (d5 * d13 * (d11 + d8 - 2.0 * d7 * d10) / 4.0 * d + (d7 - d10) * (d * d12 - 2.0 / d13) - d12);
        } while (Math.abs(geographic.lat - d2) > 1.0E-6 && n++ < 100);
        geographic.lon = Math.asin(planar.x * d / d3) / Math.sin(geographic.lat) + this.L0;
    }
}

