/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.EdgeRing;
import com.vividsolutions.jts.geomgraph.NodeMap;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.MaximalEdgeRing;
import com.vividsolutions.jts.operation.overlay.MinimalEdgeRing;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PolygonBuilder {
    private GeometryFactory geometryFactory;
    private CGAlgorithms cga;
    private List dirEdgeList;
    private NodeMap nodes;
    private List shellList = new ArrayList();

    public PolygonBuilder(GeometryFactory geometryFactory, CGAlgorithms cGAlgorithms) {
        this.geometryFactory = geometryFactory;
        this.cga = cGAlgorithms;
    }

    public void add(PlanarGraph planarGraph) {
        this.add(planarGraph.getEdgeEnds(), planarGraph.getNodes());
    }

    public void add(Collection collection, Collection collection2) {
        PlanarGraph.linkResultDirectedEdges(collection2);
        List list = this.buildMaximalEdgeRings(collection);
        ArrayList arrayList = new ArrayList();
        List list2 = this.buildMinimalEdgeRings(list, this.shellList, arrayList);
        this.sortShellsAndHoles(list2, this.shellList, arrayList);
        this.placeFreeHoles(this.shellList, arrayList);
    }

    public List getPolygons() {
        List list = this.computePolygons(this.shellList);
        return list;
    }

    private List buildMaximalEdgeRings(Collection collection) {
        ArrayList<MaximalEdgeRing> arrayList = new ArrayList<MaximalEdgeRing>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DirectedEdge directedEdge = (DirectedEdge)iterator.next();
            if (!directedEdge.isInResult() || !directedEdge.getLabel().isArea() || directedEdge.getEdgeRing() != null) continue;
            MaximalEdgeRing maximalEdgeRing = new MaximalEdgeRing(directedEdge, this.geometryFactory, this.cga);
            arrayList.add(maximalEdgeRing);
        }
        return arrayList;
    }

    private List buildMinimalEdgeRings(List list, List list2, List list3) {
        ArrayList<MaximalEdgeRing> arrayList = new ArrayList<MaximalEdgeRing>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MaximalEdgeRing maximalEdgeRing = (MaximalEdgeRing)iterator.next();
            if (maximalEdgeRing.getMaxNodeDegree() > 2) {
                maximalEdgeRing.linkDirectedEdgesForMinimalEdgeRings();
                List list4 = maximalEdgeRing.buildMinimalRings();
                EdgeRing edgeRing = this.findShell(list4);
                if (edgeRing != null) {
                    this.placePolygonHoles(edgeRing, list4);
                    list2.add(edgeRing);
                    continue;
                }
                list3.addAll(list4);
                continue;
            }
            arrayList.add(maximalEdgeRing);
        }
        return arrayList;
    }

    private EdgeRing findShell(List list) {
        int n = 0;
        MinimalEdgeRing minimalEdgeRing = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MinimalEdgeRing minimalEdgeRing2 = (MinimalEdgeRing)iterator.next();
            if (minimalEdgeRing2.isHole()) continue;
            minimalEdgeRing = minimalEdgeRing2;
            ++n;
        }
        Assert.isTrue(n <= 1, "found two shells in MinimalEdgeRing list");
        return minimalEdgeRing;
    }

    private void placePolygonHoles(EdgeRing edgeRing, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            MinimalEdgeRing minimalEdgeRing = (MinimalEdgeRing)iterator.next();
            if (!minimalEdgeRing.isHole()) continue;
            minimalEdgeRing.setShell(edgeRing);
        }
    }

    private void sortShellsAndHoles(List list, List list2, List list3) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            edgeRing.setInResult();
            if (edgeRing.isHole()) {
                list3.add(edgeRing);
                continue;
            }
            list2.add(edgeRing);
        }
    }

    private void placeFreeHoles(List list, List list2) {
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            if (edgeRing.getShell() != null) continue;
            EdgeRing edgeRing2 = this.findEdgeRingContaining(edgeRing, list);
            Assert.isTrue(edgeRing2 != null, "unable to assign hole to a shell");
            edgeRing.setShell(edgeRing2);
        }
    }

    private EdgeRing findEdgeRingContaining(EdgeRing edgeRing, List list) {
        LinearRing linearRing = edgeRing.getLinearRing();
        Envelope envelope = linearRing.getEnvelopeInternal();
        Coordinate coordinate = linearRing.getCoordinateN(0);
        EdgeRing edgeRing2 = null;
        Envelope envelope2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing3 = (EdgeRing)iterator.next();
            LinearRing linearRing2 = edgeRing3.getLinearRing();
            Envelope envelope3 = linearRing2.getEnvelopeInternal();
            if (edgeRing2 != null) {
                envelope2 = edgeRing2.getLinearRing().getEnvelopeInternal();
            }
            boolean bl = false;
            if (envelope3.contains(envelope)) {
                if (CGAlgorithms.isPointInRing(coordinate, linearRing2.getCoordinates())) {
                    bl = true;
                }
            }
            if (!bl || edgeRing2 != null && !envelope2.contains(envelope3)) continue;
            edgeRing2 = edgeRing3;
        }
        return edgeRing2;
    }

    private List computePolygons(List list) {
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            Polygon polygon = edgeRing.toPolygon(this.geometryFactory);
            arrayList.add(polygon);
        }
        return arrayList;
    }

    public boolean containsPoint(Coordinate coordinate) {
        Iterator iterator = this.shellList.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing = (EdgeRing)iterator.next();
            if (!edgeRing.containsPoint(coordinate)) continue;
            return true;
        }
        return false;
    }
}

