/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.bintree;

import com.vividsolutions.jts.index.bintree.Interval;
import com.vividsolutions.jts.index.bintree.Root;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Bintree {
    private Root root = new Root();
    private double minExtent = 1.0;

    public static Interval ensureExtent(Interval interval, double d) {
        double d2;
        double d3 = interval.getMin();
        if (d3 != (d2 = interval.getMax())) {
            return interval;
        }
        if (d3 == d2) {
            d2 = (d3 -= d / 2.0) + d / 2.0;
        }
        return new Interval(d3, d2);
    }

    public int depth() {
        if (this.root != null) {
            return this.root.depth();
        }
        return 0;
    }

    public int size() {
        if (this.root != null) {
            return this.root.size();
        }
        return 0;
    }

    public int nodeSize() {
        if (this.root != null) {
            return this.root.nodeSize();
        }
        return 0;
    }

    public void insert(Interval interval, Object object) {
        this.collectStats(interval);
        Interval interval2 = Bintree.ensureExtent(interval, this.minExtent);
        this.root.insert(interval2, object);
    }

    public Iterator iterator() {
        ArrayList arrayList = new ArrayList();
        this.root.addAllItems(arrayList);
        return arrayList.iterator();
    }

    public List query(double d) {
        return this.query(new Interval(d, d));
    }

    public List query(Interval interval) {
        ArrayList arrayList = new ArrayList();
        this.query(interval, arrayList);
        return arrayList;
    }

    public void query(Interval interval, Collection collection) {
        this.root.addAllItemsFromOverlapping(interval, collection);
    }

    private void collectStats(Interval interval) {
        double d = interval.getWidth();
        if (d < this.minExtent && d > 0.0) {
            this.minExtent = d;
        }
    }
}

