/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;

public class CentroidLine {
    private Coordinate centSum = new Coordinate();
    private double totalLength = 0.0;

    public void add(Geometry geometry) {
        if (geometry instanceof LineString) {
            this.add(geometry.getCoordinates());
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                this.add(geometryCollection.getGeometryN(i));
            }
        }
    }

    public Coordinate getCentroid() {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.centSum.x / this.totalLength;
        coordinate.y = this.centSum.y / this.totalLength;
        return coordinate;
    }

    public void add(Coordinate[] coordinateArray) {
        for (int i = 0; i < coordinateArray.length - 1; ++i) {
            double d = coordinateArray[i].distance(coordinateArray[i + 1]);
            this.totalLength += d;
            double d2 = (coordinateArray[i].x + coordinateArray[i + 1].x) / 2.0;
            this.centSum.x += d * d2;
            double d3 = (coordinateArray[i].y + coordinateArray[i + 1].y) / 2.0;
            this.centSum.y += d * d3;
        }
    }
}

