/*
 * Decompiled with CFR 0.152.
 */
package genj.geo;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class Country
implements Comparable {
    public static final Country HERE = Country.get(Locale.getDefault().getCountry());
    private static Country[] ALL_COUNTRIES = null;
    private static Country DEFAULT_COUNTRY = null;
    private static final Map locale2countries = new HashMap();
    private static final Map displayName2Country = new WeakHashMap();
    private String iso;
    private String fips;
    private String displayName;

    private Country(String code) {
        this.iso = code.toLowerCase();
        this.displayName = new Locale(Locale.getDefault().getLanguage(), code).getDisplayCountry();
    }

    private Country(String code, String displayName) {
        this.iso = code.toLowerCase();
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public String getCode() {
        return this.iso;
    }

    public int hashCode() {
        return this.iso.hashCode();
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Country that = (Country)obj;
        return this.iso.equals(that.iso);
    }

    public static Country getDefaultCountry() {
        Country.getAllCountries();
        return DEFAULT_COUNTRY;
    }

    public static Country[] getAllCountries() {
        if (ALL_COUNTRIES == null) {
            String[] codes = Locale.getISOCountries();
            ALL_COUNTRIES = new Country[codes.length];
            for (int i = 0; i < codes.length; ++i) {
                Country.ALL_COUNTRIES[i] = new Country(codes[i]);
            }
            Arrays.sort(ALL_COUNTRIES);
            DEFAULT_COUNTRY = Country.get(Locale.getDefault().getCountry());
        }
        return ALL_COUNTRIES;
    }

    public static Country get(String code) {
        return new Country(code);
    }

    public static Country get(Locale locale, String displayName) {
        if (displayName2Country.containsKey(displayName)) {
            return (Country)displayName2Country.get(displayName);
        }
        ArrayList<Country> countries = (ArrayList<Country>)locale2countries.get(locale);
        if (countries == null) {
            String[] codes = Locale.getISOCountries();
            countries = new ArrayList<Country>(codes.length);
            for (int i = 0; i < codes.length; ++i) {
                countries.add(new Country(codes[i], new Locale(locale.getLanguage(), codes[i]).getDisplayCountry(locale)));
            }
            locale2countries.put(locale, countries);
        }
        Country result = null;
        Collator collator = Collator.getInstance(locale);
        collator.setStrength(0);
        for (int i = 0; i < countries.size(); ++i) {
            Country country = (Country)countries.get(i);
            if (collator.compare(country.getDisplayName(), displayName) != 0) continue;
            result = new Country(country.iso, displayName);
            break;
        }
        if (result == null && !locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            result = Country.get(Locale.ENGLISH, displayName);
        }
        displayName2Country.put(displayName, result);
        return result;
    }
}

