/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */
package resources;

import java.awt.*;
import java.io.*;

/**
 * Class defining a Classroom Scheduler Course
 */

public class Course implements Constants, Comparable, Serializable {
    static final long serialVersionUID = 911;
    
    private String field;
    private String courseNumber;
    private String courseName;
    private String sectionPrefix;
    private int sectionNumber;
    private int creditHours;
    private float contactHours = 3.0F;
    private boolean isScheduled = false;
    
    // Constructors
    
    /**
     * Constructor declaration
     *
     * @param String field  course prefix, eg. "COP"
     * @param String courseNumber an alphanumeric identifying the course eg "1061"
     * @param String courseName a descriptor of the course "Intro to Prog Concepts"
     * @param String sectionPrefix a letter that identifies a section is to follow
     * @param int sectionNumber an identifier of the section
     */
    
    public Course(String field, String courseNumber, String courseName,
    String sectionPrefix, int sectionNumber, int creditHours) {
        this.field = field;
        this.courseNumber = courseNumber;
        this.courseName = courseName;
        this.sectionPrefix = sectionPrefix;
        this.sectionNumber = sectionNumber;
        this.creditHours = creditHours;
    }
    
    // accessors and mutators
    
    /**
     * Method declaration
     *
     * @return String field
     *
     */
    
    public String getField() {
        return field;
    }
    
    /**
     * Method declaration
     *
     *
     * @return String courseNumber
     *
     */
    
    public String getCourseNumber() {
        return courseNumber;
    }
    
    /**
     * Method declaration
     *
     *
     * @return String courseName
     *
     */
    
    public String getCourseName() {
        return courseName;
    }
    
    /**
     * Method declaration
     *
     *
     * @return String sectionPrefix
     *
     */
    
    public String getSectionPrefix() {
        return sectionPrefix;
    }
    
    /**
     * Method declaration
     *
     *
     * @return int sectionNumber
     *
     */
    
    public int getSectionNumber() {
        return sectionNumber;
    }
    
    public String getSectionString(){
        return sectionPrefix + "-" + sectionNumber;
    }
    
    public int getCreditHours(){
        return creditHours;
    }
    
    /**
     * @param String field
     */
    
    public void setScheduled(boolean isScheduled) {
        this.isScheduled = isScheduled;
    }
    
    public boolean getIsScheduled() {
        return isScheduled;
    }

 
    public void setField(String field) {
        this.field = field;
    }

    public void setCourseNumber(String courseNumber) {
        this.courseNumber = courseNumber;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }
    

    public void setSectionPrefix(String sectionPrefix) {
        this.sectionPrefix = sectionPrefix;
    }
 
    public void setSectionNumber(int sectionNumber) {
        this.sectionNumber = sectionNumber;
    }
    
    public void setCreditHours(int creditHours){
        this.creditHours = creditHours;
    }
    
    
    public String toString() {
        return field +
        courseNumber + " " +
        sectionPrefix + sectionNumber + "  " +
        courseName;
    }
    
    public int compareTo(Object obj) {
        if(!(obj instanceof Course)){
            return 0;
        }
        Course course2 = (Course) obj;
        
        if (!field.equals(course2.field))
            return field.compareTo(course2.field);
        else if (!courseNumber.equals(course2.courseNumber))
            return courseNumber.compareTo(course2.courseNumber);
        else if (!courseName.equals(course2.courseName))
            return courseName.compareTo(course2.courseName);
        else if (!sectionPrefix.equals(course2.sectionPrefix))
            return sectionPrefix.compareTo(course2.sectionPrefix);
        else if (!(sectionNumber == course2.sectionNumber))
            return sectionNumber - course2.sectionNumber;
        else
            return 0;
    }
    
    // determine if 2 courses are equal - avoid duplicates
    
    public boolean equals(Object obj) {
        if(!(obj instanceof Course)){
            return false;
        }
        Course course2 = (Course) obj;
        
        if (courseName.equals(course2.courseName) 
            && sectionNumber == course2.sectionNumber 
            && field.equals(course2.field)
            && courseNumber.equals(course2.courseNumber) 
            && sectionPrefix.equals(course2.sectionPrefix)
            && creditHours == course2.creditHours
            && contactHours == course2.contactHours)
                return true;
        return false;
    }
}


