/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import application.*;
import resources.*;
/**
 *
 * @author  Colin
 */
public class RoomsPanel extends javax.swing.JPanel implements Observer {
    
    /** Creates new form TestGridbag */
    public RoomsPanel() {
        initComponents();
        ptm = new RoomsTableModel();
        sorter = new TableSorter(ptm);
        sorter.addMouseListenerToHeaderInTable(jTable1);
        jTable1.setModel(sorter);
        addListeners();
        setColumnSizes();
    }
    private void setColumnSizes(){
        // adjust the width of the columns
        TableColumn column = null;
        
        column = jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(50);
        column = jTable1.getColumnModel().getColumn(2);
        column.setPreferredWidth(30);
        
        
        buildingColumn = jTable1.getColumnModel().getColumn(0);
        roomColumn = jTable1.getColumnModel().getColumn(1);
        capacityColumn = jTable1.getColumnModel().getColumn(2);
        
        buildingColumn.setCellEditor(new DefaultCellEditor(editBuilding));
        roomColumn.setCellEditor(new DefaultCellEditor(editRoom));
        capacityColumn.setCellEditor(new DefaultCellEditor(editCapacity));
    }
    
    private void addListeners() {
        RoomsPanelListener roomsPanelListener = new RoomsPanelListener();
        jButton1.addActionListener(roomsPanelListener);
        jButton2.addActionListener(roomsPanelListener);
        
        
        editBuilding.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                int row = jTable1.getSelectedRow();
                int theRealIndex = sorter.map(row);
                if (theRealIndex >= 0) {
                    String buildingStr = editBuilding.getText();
                    Classroom roomModified = (Classroom)schedule.getClassrooms().get(theRealIndex);
                    roomModified.setBuilding(buildingStr);
                    ptm.fireTableDataChanged();
                    schedule.setChanged(true);
                }
            }
        });
        editRoom.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                int row = jTable1.getSelectedRow();
                int theRealIndex = sorter.map(row);
                if (theRealIndex >= 0) {
                    String room = editRoom.getText();
                    Classroom roomModified = (Classroom)schedule.getClassrooms().get(theRealIndex);
                    roomModified.setRoomName(room);
                    ptm.fireTableDataChanged();
                    schedule.setChanged(true);
                }
            }
        });
        editCapacity.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                int row = jTable1.getSelectedRow();
                int theRealIndex = sorter.map(row);
                if (theRealIndex >= 0) {
                    String capStr = editCapacity.getText();
                    Classroom roomModified = (Classroom)schedule.getClassrooms().get(theRealIndex);
                    int capacity = 0;
                    try{
                        capacity = Integer.parseInt(capStr);
                    } catch(NumberFormatException nfe){
                        // do nothing lwt cap be 0
                    }
                    roomModified.setCapacity(capacity);
                    ptm.fireTableDataChanged();
                    schedule.setChanged(true);
                }
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jTextField2 = new javax.swing.JTextField();
        jTextField3 = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jButton2 = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setToolTipText("Double click on heading to sort");
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTable1.setToolTipText("Double click to change room info");
        jTable1.setPreferredScrollableViewportSize(new java.awt.Dimension(300, 400));
        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        jButton1.setText("Delete Selected Room(s)");
        jButton1.setToolTipText("Remove one or more rooms from the list");
        jButton1.setMaximumSize(new java.awt.Dimension(175, 26));
        jButton1.setMinimumSize(new java.awt.Dimension(250, 26));
        jButton1.setPreferredSize(new java.awt.Dimension(175, 26));
        jPanel3.add(jButton1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel1.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = -53;
        gridBagConstraints.ipady = -25;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 0, 0);
        add(jPanel1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED)));
        jLabel1.setText("Building:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(17, 6, 0, 0);
        jPanel2.add(jLabel1, gridBagConstraints);

        jLabel2.setText("Room:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel2, gridBagConstraints);

        jLabel3.setText("Capacity:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        jPanel2.add(jLabel3, gridBagConstraints);

        jTextField1.setToolTipText("Usually a number, e.g., \"7\"");
        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 75;
        gridBagConstraints.insets = new java.awt.Insets(17, 6, 0, 18);
        jPanel2.add(jTextField1, gridBagConstraints);

        jTextField2.setToolTipText("Usually a number, e.g., \"122\"");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(jTextField2, gridBagConstraints);

        jTextField3.setToolTipText("Max # of students in this room");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 18);
        jPanel2.add(jTextField3, gridBagConstraints);

        jButton2.setText("Add Room");
        jButton2.setToolTipText("Add this room to the list");
        jPanel4.add(jButton2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel2.add(jPanel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 0, 17);
        add(jPanel2, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField1ActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jTextField1ActionPerformed
    
    public void update(java.util.Observable observable, Object obj) {
        ptm.fireTableDataChanged();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    // End of variables declaration//GEN-END:variables
    
    private RoomsPanelListener roomsPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private RoomsTableModel ptm;
    private TableSorter sorter;
    private TableColumn buildingColumn;
    private TableColumn roomColumn;
    private TableColumn capacityColumn;
    private JTextField editBuilding = new JTextField();
    private JTextField editRoom = new JTextField();
    private JTextField editCapacity = new JTextField();
    
    class RoomsPanelListener implements ActionListener {
        
        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear " + "|"+e.getActionCommand()+"|");
            if (e.getActionCommand().equals("Add Room")){
                String  building = jTextField1.getText().trim();
                String  room = jTextField2.getText().trim();
                String capString = "";
                int capacity = 0;
                
                if (building.equals("") || room.equals(""))
                    return; // go back - do nothing not enough info
  
                if ( !((capString = jTextField3.getText().trim()).equals(""))){
                    try{
                        capacity = Integer.parseInt(capString);
                    }catch(NumberFormatException nfe){
                        // ignore the bad input and let the cap be 0
                    }
                }
                Classroom classroom = new Classroom(building, room, capacity);
                schedule.addClassroom(classroom); // add it to the schedule
                jTextField1.setText("");  // resert the fields to blank
                jTextField2.setText("");
                jTextField3.setText("");
            } else if (e.getActionCommand().equals("Delete Selected Room(s)")){
                System.out.println("I'm deleting a room over here");
                // Determine which items to be deleted
                int[] selected = jTable1.getSelectedRows();
                
                for (int i = selected.length - 1 ; i >= 0 ; i--) {
                    int realIndex = sorter.map(selected[i]);
                    // Removes the items from the list
                    schedule.removeClassroom((Classroom)
                    schedule.getClassrooms().get(realIndex));
                }
            }
        }
    } // end inner class
}


class RoomsTableModel extends AbstractTableModel {
    private Schedule schedule;
    
    final String[] columnNames = {
        "Building",
        "Room",
        "Capacity",
    };
    /** Creates a new instance of RoomsTableModel */
    public RoomsTableModel() {
        schedule = Schedule.getSchedule();
    }
    public int getColumnCount() {
        return columnNames.length;
    }
    public int getRowCount() {
        return schedule.getClassrooms().size();
    }
    public String getColumnName(int col) {
        return columnNames[col];
    }
    
    public Class getColumnClass(int c) {
        return " ".getClass();
    }
    public boolean isCellEditable(int row, int col) {
        return true;
    }
    public Object getValueAt(int row, int col) {
        Classroom classroom = (Classroom)schedule.getClassrooms().get(row);
        switch(col){
            case 0: return classroom.getBuilding();
            case 1: return classroom.getRoomName();
            case 2: return ""+classroom.getCapacity();
        }
        return ""; // should never do this
    }
    public void setValueAt(Object value, int row, int col) {
        //fireTableCellUpdated(row, col);
    }
}
