/*
 * @(#)MyAppSplash.java  1.2  2003-06-01
 *
 * Copyright (c) 1999-2003 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland
 * All rights reserved.
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software is hereby granted without fee,
 * provided this copyright notice is retained on all copies.
 *
 *  This file along with SplashWindow.java are here solely for teh purpose fo displaying 
 *  the splash screen on slower machines.  If you are not interested in the 
 *  functionality of the splash screen, you can start looking at the code at 
 *  ClassroomScheduler.java which has a main method as well.
 *
 */

package application;

import java.awt.Frame;
import java.awt.Toolkit;
import java.net.URL;
import java.io.*;

/**
 *
 * @author  carchibald
 */
public class ClassroomSchedulerSplash {
    
    public static void main(String[] args) {
        // NOTE: The splash window should appear as early as possible.
        //       The code provided here uses Reflection to avoid time
        //       consuming class loading before the splash window is
        //       constructed.


        // Read the image data and open the splash screen
        // ----------------------------------------------

        // TO DO: Replace 'splash.gif' with the file name of your splash image.
        Frame splashFrame = null;
        URL imageURL = ClassroomSchedulerSplash.class.getResource("splash.gif");
        if (imageURL != null) {
            splashFrame = SplashWindow.splash(
                Toolkit.getDefaultToolkit().createImage(imageURL)
            );
        } else {
            System.err.println("Splash image not found");
        }
        // TO DO: Replace 'MyApp' with the fully qualified class
        // name of your application.
        try {
            Class.forName("application.ClassroomScheduler")
            .getMethod("main", new Class[] {String[].class})
            .invoke(null, new Object[] {args});
        } catch (Throwable e) {
            e.printStackTrace();
            System.err.flush();
            System.exit(10);
        }

        // Dispose the splash window by disposing its parent frame
        // -------------------------------------------------------
        if (splashFrame != null) splashFrame.dispose();
    }
}
