
/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 *
 *  Main class for the ClassroomScheduler project
 */
package application;

import javax.swing.UIManager;
import javax.swing.*;

import resources.*;

public class ClassroomScheduler implements Constants {
    static ClassroomScheduler theApp;
    private static ClassroomSchedulerFrame schedulerFrame;
    private String title = "Classroom Scheduler";
    private Schedule schedule;  // the document
    //private UserPreferences userPrefs;
    
    
    /**
     * The main method for ClassroomScheduler.
     *
     * @param args  Not used
     */
    public static void main(String[] args) {
        try {
            // Make this a user preference.
            //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            theApp = new ClassroomScheduler();
            theApp.init();  // get to a non static method
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
    
    /**
     * Creation of the global components for the application
     */
    
    public void init() {        
        // reads the user's prefs from the registry,
       // userPrefs = UserPreferences.getPrefs();  
        // Create the document
        schedule = Schedule.getSchedule();        
        // Crete the JFrame
        schedulerFrame = new ClassroomSchedulerFrame(title +
        ": " + schedule.getScheduleName() + schedule.updated());
    }
    
    public static ClassroomSchedulerFrame getFrame() {
        return schedulerFrame;
    }
}
