/*
 * Decompiled with CFR 0.152.
 */
package resources;

import application.Schedule;
import java.io.Serializable;
import java.util.ArrayList;
import resources.Professor;
import resources.SchedCourse;

public class ProfessorSummary
implements Serializable {
    static final long serialVersionUID = 911L;
    public static final String TOTAL = "Total";
    public static final String TOTAL_FULL = "Total Full Time";
    public static final String TOTAL_ADJUNCT = "Total Adjunct";
    public static final int NAME_COL = 24;
    public static final int SECTION_COL = 35;
    public static final int CREDIT_HOURS_COL = 45;
    private int totalCreditHours = 0;
    private int totalSections = 0;
    private Professor professor;

    public ProfessorSummary(Professor professor) {
        this.setProfessor(professor);
        this.calculateCreditHours();
    }

    public void setProfessor(Professor professor) {
        if (professor != null) {
            this.professor = professor;
        }
    }

    public Professor getProfessor() {
        return this.professor;
    }

    public void setSections(int sections) {
        if (sections >= 0) {
            this.totalSections = sections;
        }
    }

    public int getSections() {
        return this.totalSections;
    }

    public void incrementSections(int increment) {
        if (increment > 0) {
            this.setSections(this.getSections() + increment);
        }
    }

    public void setCreditHours(int creditHours) {
        if (creditHours >= 0) {
            this.totalCreditHours = creditHours;
        }
    }

    public int getCreditHours() {
        return this.totalCreditHours;
    }

    public void incrementCreditHours(int increment) {
        if (increment > 0) {
            this.setCreditHours(this.getCreditHours() + increment);
        }
    }

    public void calculateCreditHours() {
        Schedule schedule = Schedule.getSchedule();
        ArrayList schedCourses = schedule.getSchedCourses();
        for (SchedCourse schedCourse : schedCourses) {
            if (!schedCourse.getProfessor().equals(this.getProfessor())) continue;
            this.incrementSections(1);
            this.incrementCreditHours(schedCourse.getCourse().getCreditHours());
        }
    }

    public String toString() {
        String string = this.getProfessor().getFirstName() + " ";
        string = string + this.getProfessor().getLastName();
        string = string + ProfessorSummary.space(string.length(), 24);
        string = string + this.getSections();
        string = string + ProfessorSummary.space(string.length(), 35);
        string = string + this.getCreditHours();
        string = string + ProfessorSummary.space(string.length(), 45);
        return string;
    }

    private static String space(int used, int total) {
        String result = "";
        if (used >= total) {
            return result;
        }
        for (int i = used; i < total; ++i) {
            result = result + " ";
        }
        return result;
    }
}

