/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import javax.swing.table.AbstractTableModel;
import resources.TimeSlot;

class TimeSlotTableModel
extends AbstractTableModel {
    private Schedule schedule;
    final String[] columnNames = new String[]{"Days of Week", "Start", "End"};

    public TimeSlotTableModel() {
        this.schedule = Schedule.getSchedule();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.schedule.getTimeSlots().size();
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Class getColumnClass(int c) {
        return " ".getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        TimeSlot timeSlot = (TimeSlot)this.schedule.getTimeSlots().get(row);
        switch (col) {
            case 0: {
                return timeSlot.toDaysString();
            }
            case 1: {
                if (timeSlot.getStartTime() != null) {
                    return timeSlot.getStartTime().toString();
                }
            }
            case 2: {
                if (timeSlot.getStopTime() == null) break;
                return timeSlot.getStopTime().toString();
            }
        }
        return "";
    }

    public void setValueAt(Object value, int row, int col) {
    }
}

