/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import javax.swing.table.AbstractTableModel;
import resources.Classroom;
import resources.Course;
import resources.Professor;
import resources.SchedCourse;
import resources.TimeSlot;

class ScheduleTableModel
extends AbstractTableModel {
    private Schedule schedule = Schedule.getSchedule();
    final String[] columnNames = new String[]{"Course", "CRN", "Classroom", "Time Slot", "Professor", "Conflict", "Note"};

    ScheduleTableModel() {
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.schedule.getSchedCourses().size();
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        Object result = null;
        SchedCourse schedCourse = (SchedCourse)this.schedule.getSchedCourses().get(row);
        switch (col) {
            case 0: {
                result = schedCourse.getCourse();
                break;
            }
            case 1: {
                result = schedCourse.getCrn();
                break;
            }
            case 2: {
                result = schedCourse.getClassroom();
                break;
            }
            case 3: {
                result = schedCourse.getTimeSlot();
                break;
            }
            case 4: {
                result = schedCourse.getProfessor();
                break;
            }
            case 5: {
                boolean conflict = schedCourse.getConflict() != null;
                result = new Boolean(conflict);
                break;
            }
            case 6: {
                result = schedCourse.getNote();
                break;
            }
            default: {
                System.out.println("Tried to access table data outside 0-6:[" + row + ", " + col);
            }
        }
        return result;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return col != 0 && col != 5;
    }

    public void setValueAt(Object value, int row, int col) {
        SchedCourse schedCourse = (SchedCourse)this.schedule.getSchedCourses().get(row);
        this.schedule.removeSchedCourse(schedCourse);
        if (value != null) {
            switch (col) {
                case 0: {
                    schedCourse.setCourse((Course)value);
                    break;
                }
                case 1: {
                    schedCourse.setCrn((String)value);
                    break;
                }
                case 2: {
                    schedCourse.setClassroom((Classroom)value);
                    break;
                }
                case 3: {
                    schedCourse.setTimeSlot((TimeSlot)value);
                    break;
                }
                case 4: {
                    schedCourse.setProfessor((Professor)value);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    schedCourse.setNote((String)value);
                    break;
                }
                default: {
                    System.out.println("Tried to set table data outside 0-6:[" + row + ", " + col);
                }
            }
        }
        this.schedule.addSchedCourse(schedCourse);
        this.fireTableDataChanged();
    }
}

