/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.Schedule;
import javax.swing.table.AbstractTableModel;
import resources.Course;

class CoursesTableModel
extends AbstractTableModel {
    private Schedule schedule;
    final String[] columnNames = new String[]{"Pre", "Num", "Section", "Name", "Credits"};

    public CoursesTableModel() {
        this.schedule = Schedule.getSchedule();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.schedule.getCourses().size();
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Class getColumnClass(int c) {
        return " ".getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public Object getValueAt(int row, int col) {
        Course course = (Course)this.schedule.getCourses().get(row);
        switch (col) {
            case 0: {
                return course.getField();
            }
            case 1: {
                return course.getCourseNumber();
            }
            case 2: {
                return course.getSectionString();
            }
            case 3: {
                return course.getCourseName();
            }
            case 4: {
                return "" + course.getCreditHours();
            }
        }
        return "";
    }

    public void setValueAt(Object value, int row, int col) {
    }
}

