-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:        ENTITY
--
--     ENT_ID
--        Identifies the Entity. (Part of Primary Key)
--           ALBUM_IDENTIFIER        = 1;
--           BOOK_IDENTIFIER         = 2;
--           MOVIE_IDENTIFIER        = 3;
--           OPERA_IDENTIFIER        = 4;
--           SCORE_IDENTIFIER        = 5;
--           TRACK_IDENTIFIER        = 6;
--           SOFTWARE_IDENTIFIER     = 7;
--
--     ENT_SEQ
--        Sequential integer (Part of Primary Key)
--
--     ENT_MEDIA
--        MEDIA_CD                = 1;
--        MEDIA_DVD               = 2;
--        MEDIA_VHS               = 3;
--        MEDIA_FILE              = 4; (a file on the hard drive)
--        MEDIA_OTHER             = 5;
--
--     ENT_TITLE
--        Title of the Album
--
--     ENT_LOCATION
--        Physical location of the media.  Could be anything the user
--        wants to enter, e.g. "The brown bookcase."  In the event of
--        a file, it should have the filespec of the file name,
--        e.g. "D:\My Albums\albumName" or however it's done on
--        Linux.
--
--     ENT_COMMENTS
--        May contain any comments the user wants to include, such as
--        a synopsis or a review.
--
--     ENT_DATE
--        Recorded material:  Date recorded
--        Printed material :  Date published
--
--
-----------------------------------------------------------------------
--DROP TABLE ENTITY;
--COMMIT;
CREATE CACHED TABLE ENTITY (
  ENT_ID               INTEGER  NOT NULL,
  ENT_SEQ              INTEGER  NOT NULL,
  ENT_MEDIA            INTEGER  NOT NULL,
  ENT_TITLE            CHAR(50) NOT NULL,
  ENT_LOCATION         CHAR(50) NOT NULL,
  ENT_COMMENTS         CHAR(100),
  ENT_DATE             CHAR(10),
  PRIMARY KEY          (ENT_ID, ENT_SEQ)
  );
COMMIT;
CREATE INDEX ENT_SECIX1
  ON ENTITY(ENT_TITLE);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:        ALBUMS
--
--     ALB_SEQ
--        Sequential integer (Primary Key)
--
--     ALB_COMPOSER
--        Composer's name (may be a list of composers if necessary)
--
--     ALB_ORCHESTRA
--        Name of Orchestra
--
--     ALB_CONDUCTOR
--        Conductor's name
--
--     ALB_GENRE
--        1 = Operatic and other classical vocals
--            (e.g. Arias, Neapolitan Songs)
--        2 = Symphonic
--        3 = Other classical music
--        4 = Operetta and or Broadway Musicals
--        5 = Popular
--        6 = Jazz
--        7 = Other
--
--     ALB_PARENT_ID  and
--     ALB_PARENT_KEY
--        Identify the Primary Key of the Entity which owns this Album
--        (Freign Key)
--
--
-----------------------------------------------------------------------
--DROP TABLE ALBUMS;
--COMMIT;
CREATE CACHED TABLE ALBUMS (
  ALB_SEQ              INTEGER  NOT NULL,
  ALB_COMPOSER         CHAR(50),
  ALB_ORCHESTRA        CHAR(50),
  ALB_CONDUCTOR        CHAR(50),
  ALB_GENRE            INTEGER  NOT NULL,
  ALB_PARENT_ID        INTEGER  NOT NULL,
  ALB_PARENT_KEY       INTEGER  NOT NULL,
  FOREIGN KEY          (ALB_PARENT_ID, ALB_PARENT_KEY)
  REFERENCES ENTITY    (ENT_ID, ENT_SEQ)
  ON DELETE            CASCADE
  );
COMMIT;
CREATE INDEX ALB_SECIX1
  ON ALBUMS(ALB_COMPOSER);
CREATE INDEX ALB_SECIX2
  ON ALBUMS(ALB_CONDUCTOR);
CREATE INDEX ALB_SECIX3
  ON ALBUMS(ALB_ORCHESTRA);
CREATE INDEX ALB_SECIX4
  ON ALBUMS(ALB_GENRE);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:        BOOKS
--
--     BOO_SEQ
--        Sequential integer (Primary Key)
--
--     BOO_AUTHOR
--        Author of the Book
--
--     BOO_PUBLISHER
--        Publisher of the Book
--
--     BOO_GENRE
--        GENRE_FICTION   = 1;
--        GENRE_SCI_FI    = 2;
--        GENRE_BIOGRAPHY = 3;
--        GENRE_REFERENCE = 4;
--        GENRE_TECHNICAL = 5;
--        GENRE_OTHER     = 6;
--
--
--     BOO_PGCOUNT
--        Number of pages in the book
--
--     BOO_PARENT_ID and
--     BOO_PARENT_KEY
--        Identify the Primary Key of the Entity owning this Book
--        (Foreign Key)
--
--
-----------------------------------------------------------------------
--DROP TABLE BOOKS;
--COMMIT;
CREATE CACHED TABLE BOOKS (
  BOO_SEQ              INTEGER  NOT NULL  PRIMARY KEY,
  BOO_AUTHOR           CHAR(30),
  BOO_PUBLISHER        CHAR(30),
  BOO_PGCOUNT          INTEGER,
  BOO_GENRE            INTEGER,
  BOO_PARENT_ID        INTEGER  NOT NULL,
  BOO_PARENT_KEY       INTEGER  NOT NULL,
  FOREIGN KEY          (BOO_PARENT_ID, BOO_PARENT_KEY)
  REFERENCES ENTITY    (ENT_ID, ENT_SEQ)
  ON DELETE            CASCADE
  );
COMMIT;
CREATE INDEX BOO_SECIX1
  ON BOOKS(BOO_AUTHOR);
CREATE INDEX BOO_SECIX2
  ON BOOKS(BOO_PUBLISHER);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:        MOVIES
--
--     MOV_SEQ
--        Sequential integer (Primary Key)
--
--     MOV_DIRECTOR
--        Director's name.
--
--     MOV_GENRE
--        GENRE_DRAMA       = 1;
--        GENRE_COMEDY      = 2;
--        GENRE_SUSPENSE    = 3;
--        GENRE_THRILLER    = 4;
--        GENRE_SCI_FI      = 5;
--        GENRE_DOCUMENTARY = 6;
--        GENRE_OTHER       = 7;
--
--     MOV_PARENT_ID  and
--     MOV_PARENT_KEY
--        Identify the Primary Key of the Entity which owns this Movie
--        (Foreign Key)
--
--
-----------------------------------------------------------------------
--DROP TABLE MOVIES;
--COMMIT;
CREATE CACHED TABLE MOVIES (
  MOV_SEQ              INTEGER  NOT NULL  PRIMARY KEY,
  MOV_DIRECTOR         CHAR(30),
  MOV_GENRE            INTEGER  NOT NULL,
  MOV_PARENT_ID        INTEGER  NOT NULL,
  MOV_PARENT_KEY       INTEGER  NOT NULL,
  FOREIGN KEY          (MOV_PARENT_ID, MOV_PARENT_KEY)
  REFERENCES ENTITY    (ENT_ID, ENT_SEQ)
  ON DELETE            CASCADE
  );
COMMIT;
CREATE INDEX MOV_SECIX1
  ON MOVIES(MOV_DIRECTOR);
CREATE INDEX MOV_SECIX2
  ON MOVIES(MOV_GENRE);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:        OPERAS
--
--    OPE_ID
--       Always set to 4 (Part of Primary Key)
--
--    OPE_SEQ
--       Sequential integer (primary key)
--
--    OPE_COMPOSER
--       Composer's name.
--
--    OPE_LIBRETTIST
--       Librettist's name.
--
--    OPE_CONDUCTOR
--       Conductor's name.
--
--    OPE_ORCHESTRA
--       Orchestra's name.
--
--    OPE_CHORUS
--       Chorus's name.
--
--    OPE_CHORUSMASTER
--       Chorusmaster's name.
--
--    OPE_DIRECTOR
--       Director's name.
--
--
-----------------------------------------------------------------------
--DROP TABLE OPERAS;
--COMMIT;
CREATE CACHED TABLE OPERAS (
  OPE_SEQ              INTEGER  NOT NULL  PRIMARY KEY,
  OPE_COMPOSER         CHAR(30) NOT NULL,
  OPE_LIBRETTIST       CHAR(30) NOT NULL,
  OPE_CONDUCTOR        CHAR(30) NOT NULL,
  OPE_ORCHESTRA        CHAR(30) NOT NULL,
  OPE_CHORUS           CHAR(30) NOT NULL,
  OPE_CHORUSMASTER     CHAR(30) NOT NULL,
  OPE_DIRECTOR         CHAR(30) NOT NULL,
  OPE_PARENT_ID        INTEGER  NOT NULL,
  OPE_PARENT_KEY       INTEGER  NOT NULL,
  FOREIGN KEY          (OPE_PARENT_ID, OPE_PARENT_KEY)
  REFERENCES ENTITY    (ENT_ID, ENT_SEQ)
  ON DELETE            CASCADE
  );
COMMIT;
CREATE INDEX OPE_SECIX1
  ON OPERAS(OPE_COMPOSER);
CREATE INDEX OPE_SECIX2
  ON OPERAS(OPE_CONDUCTOR);
CREATE INDEX OPE_SECIX3
  ON OPERAS(OPE_ORCHESTRA);
CREATE INDEX OPE_SECIX4
  ON OPERAS(OPE_DIRECTOR);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:        SCORES
--
--    SCO_SEQ
--       Sequential integer (Part of Primary Key)
--
--    SCO_COMPOSER
--       Composer's name.
--
--    SCO_GENRE
--       1 = Operatic and other classical vocals
--           (e.g. Arias, Neapolitan Songs)
--       2 = Symphonic
--       3 = Other classical music
--       4 = Operetta and or Broadway Musicals
--       5 = Popular
--       6 = Jazz
--       7 = Other
--
--    SCO_INSTRUMENTATION
--       1 = Vocal w/Piano
--       2 = Piano Solo
--       3 = String Solo
--       4 = String w/Piano
--       5 = String Ensemble
--       6 = String Quartet
--       7 = Brass Solo
--       8 = Brass Ensemble
--       9 = Woodwind Solo
--      10 = Woodwind Ensemble
--      11 = Full Orchestra
--      12 = Other Ensemble
--      13 = Lead Sheet
--      14 = Other
--
--    SCO_LIBRETTIST
--       Librettist's name.
--       (an optional field with might be blanks)
--
-----------------------------------------------------------------------
--DROP TABLE SCORES;
--COMMIT;
CREATE CACHED TABLE SCORES (
  SCO_SEQ              INTEGER  NOT NULL  PRIMARY KEY,
  SCO_COMPOSER         CHAR(30) NOT NULL,
  SCO_GENRE            INTEGER  NOT NULL,
  SCO_INSTRUMENTATION  INTEGER  NOT NULL,
  SCO_LIBRETTIST       CHAR(30),
  SCO_PARENT_ID        INTEGER  NOT NULL,
  SCO_PARENT_KEY       INTEGER  NOT NULL,
  FOREIGN KEY          (SCO_PARENT_ID, SCO_PARENT_KEY)
  REFERENCES ENTITY    (ENT_ID, ENT_SEQ)
  ON DELETE            CASCADE
  );
COMMIT;
CREATE INDEX SCO_SECIX1
  ON SCORES(SCO_COMPOSER);
CREATE INDEX SCO_SECIX2
  ON SCORES(SCO_INSTRUMENTATION);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:        SOFTWARE
--
--    SOF_SEQ
--       Sequential integer (Part of Primary Key)
--
--    SOF AUTHOR
--       Author's name.
--
--    SOF_PUBLISHER
--       Publisher's name.
--
--    Note:  Should never leave both Author and Publisher NULL.
--
--    SOF_VERSION
--       Version or release of this Software.  It is possible to have
--       more than one version of the same software in the system.
--
--    SOF_WEBSITE
--       The URL of the Publisher's web site or other web site where
--       this product can be found.
--
-----------------------------------------------------------------------
--DROP TABLE SOFTWARE;
--COMMIT;
CREATE CACHED TABLE SOFTWARE (
  SOF_SEQ              INTEGER  NOT NULL  PRIMARY KEY,
  SOF_AUTHOR           CHAR(30),
  SOF_PUBLISHER        CHAR(30),
  SOF_VERSION          CHAR(50),
  SOF_WEBSITE          CHAR(50),
  SOF_PARENT_ID        INTEGER  NOT NULL,
  SOF_PARENT_KEY       INTEGER  NOT NULL,
  FOREIGN KEY          (SOF_PARENT_ID, SOF_PARENT_KEY)
  REFERENCES ENTITY    (ENT_ID, ENT_SEQ)
  ON DELETE            CASCADE
  );
COMMIT;
CREATE INDEX SOF_SECIX1
  ON SOFTWARE(SOF_AUTHOR);
CREATE INDEX SOF_SECIX2
  ON SOFTWARE(SOF_PUBLISHER);
CREATE INDEX SOF_SECIX3
  ON SOFTWARE(SOF_WEBSITE);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:        TRACKS
--
--     TRK_SEQ
--        Sequential integer (primary key)
--        Cannot begin with zero.
--
--     TRK_TITLE
--        Title of the Track
--
--     TRK_PARENT_ID
--        Entity Identifier
--
--     TRK_PARENT_KEY
--        The primary key of this track's parent.
--
--
-----------------------------------------------------------------------
--DROP TABLE TRACKS;
--COMMIT;
CREATE CACHED TABLE TRACKS (
  TRK_SEQ              INTEGER  NOT NULL PRIMARY KEY,
  TRK_TITLE            CHAR(50) NOT NULL,
  TRK_PARENT_ID        INTEGER  NOT NULL,
  TRK_PARENT_KEY       INTEGER  NOT NULL,
  FOREIGN KEY          (TRK_PARENT_ID, TRK_PARENT_KEY)
  REFERENCES ENTITY    (ENT_ID, ENT_SEQ)
  ON DELETE            CASCADE
  );
COMMIT;
CREATE INDEX TRK_SECIX1
  ON TRACKS(TRK_TITLE);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:       ARTISTS:
--
--     ART_SEQ
--        Sequential integer (primary key)
--        Cannot begin with zero.
--
--     ART_NAME
--        Artist's name or alias
--
--     ART_FORTE
--        What he is best known for (Actor, Tenor, Soprano, etc.)
--
--     ART_ROLE
--        Role portrayed by this artist in this instance
--
--     ART_PARENT_ID
--        What he is best known for (Actor, Tenor, Soprano, etc.)
--
--     ART_PARENT_KEY
--        What he is best known for (Actor, Tenor, Soprano, etc.)
--
--
-----------------------------------------------------------------------
--DROP TABLE ARTISTS;
--COMMIT;
CREATE CACHED TABLE ARTISTS (
  ART_SEQ              INTEGER  NOT NULL PRIMARY KEY,
  ART_NAME             CHAR(30) NOT NULL,
  ART_FORTE            CHAR(22),
  ART_ROLE             CHAR(30),
  ART_PARENT_ID        INTEGER  NOT NULL,
  ART_PARENT_KEY       INTEGER  NOT NULL,
  FOREIGN KEY          (ART_PARENT_ID, ART_PARENT_KEY)
  REFERENCES ENTITY    (ENT_ID, ENT_SEQ)
  ON DELETE            CASCADE
  );
COMMIT;
CREATE INDEX ART_SECIX
  ON ARTISTS(ART_NAME);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:       SYSCONFIG:
--
--     SYS_OPTION
--        Primary Key
--
--     SYS_INTEGER_VALUE
--        0 = Not Used
--
--     SYS_DOUBLE_VALUE
--        0 = Not Used
--
--     SYS_CHAR_VALUE
--        Spaces = Not Used
--
--
-----------------------------------------------------------------------
--DROP TABLE SYSCONFIG;
--COMMIT;
CREATE CACHED TABLE SYSCONFIG (
  SYS_OPTION           CHAR(20) NOT NULL PRIMARY KEY,
  SYS_CHAR_VALUE       VARCHAR,
  SYS_INTEGER_VALUE    INTEGER,
  SYS_DOUBLE_VALUE     DOUBLE
  );
COMMIT;
-----------------------------------------------------------------------
INSERT INTO SYSCONFIG VALUES('CURRENT_LANGUAGE', '  ', 0, 0);
COMMIT;
-----------------------------------------------------------------------
-----------------------------------------------------------------------
--  *******************************************************************
--  Database Name:    BrutusDB
--  *******************************************************************
--
--
--  Table Name:       MESSAGES:
--
--     MSG_NUM
--        Message Number (primary key)
--
--     MSG_TEXT
--        Text of the message number.
--
--     Notes:  This table will be loaded from the NLS .ddl files
--
--
-----------------------------------------------------------------------
--DROP TABLE MESSAGES;
--COMMIT;
CREATE CACHED TABLE MESSAGES (
  MSG_NUM              INTEGER  NOT NULL PRIMARY KEY,
  MSG_TEXT             CHAR(32) NOT NULL
  );
COMMIT;
-----------------------------------------------------------------------
INSERT INTO MESSAGES VALUES(0000, 'File');
INSERT INTO MESSAGES VALUES(0001, 'Options');
INSERT INTO MESSAGES VALUES(0002, 'Configure');
INSERT INTO MESSAGES VALUES(0003, 'Search');
INSERT INTO MESSAGES VALUES(0004, 'Help');
INSERT INTO MESSAGES VALUES(0005, 'Album');
INSERT INTO MESSAGES VALUES(0006, 'Book');
INSERT INTO MESSAGES VALUES(0007, 'Movie');
INSERT INTO MESSAGES VALUES(0008, 'Opera');
INSERT INTO MESSAGES VALUES(0009, 'Score');
INSERT INTO MESSAGES VALUES(0010, 'Track');
INSERT INTO MESSAGES VALUES(0011, 'Language');
INSERT INTO MESSAGES VALUES(0012, 'New');
INSERT INTO MESSAGES VALUES(0013, 'Edit');
INSERT INTO MESSAGES VALUES(0014, 'View');
INSERT INTO MESSAGES VALUES(0015, 'Deutsch');
INSERT INTO MESSAGES VALUES(0016, 'English');
INSERT INTO MESSAGES VALUES(0017, 'Espaol');
INSERT INTO MESSAGES VALUES(0018, 'Italiano');
INSERT INTO MESSAGES VALUES(0019, 'Play MP3');
INSERT INTO MESSAGES VALUES(0020, 'MP3 Player');
INSERT INTO MESSAGES VALUES(0021, 'MPG Player');
INSERT INTO MESSAGES VALUES(0022, 'Author/Composer');
INSERT INTO MESSAGES VALUES(0023, 'Conductor');
INSERT INTO MESSAGES VALUES(0024, 'Director');
INSERT INTO MESSAGES VALUES(0025, 'Artist');
INSERT INTO MESSAGES VALUES(0026, 'Title');
INSERT INTO MESSAGES VALUES(0027, 'Contents');
INSERT INTO MESSAGES VALUES(0028, 'About');
INSERT INTO MESSAGES VALUES(0029, 'View HTML');
INSERT INTO MESSAGES VALUES(0030, 'Brutus - v. 1.0beta3');
INSERT INTO MESSAGES VALUES(0031, 'Software');
INSERT INTO MESSAGES VALUES(0032, 'Album Dialog');
INSERT INTO MESSAGES VALUES(0033, 'Book Dialog');
INSERT INTO MESSAGES VALUES(0034, 'Movie Dialog');
INSERT INTO MESSAGES VALUES(0035, 'Opera Dialog');
INSERT INTO MESSAGES VALUES(0036, 'Score Dialog');
INSERT INTO MESSAGES VALUES(0037, 'Software Dialog');
INSERT INTO MESSAGES VALUES(0038, 'Character');
INSERT INTO MESSAGES VALUES(0039, 'Orchestra');
INSERT INTO MESSAGES VALUES(0040, 'Chorus');
INSERT INTO MESSAGES VALUES(0041, 'Chorusmaster');
INSERT INTO MESSAGES VALUES(0042, 'Librettist');
INSERT INTO MESSAGES VALUES(0043, 'Date');
INSERT INTO MESSAGES VALUES(0044, 'Media');
INSERT INTO MESSAGES VALUES(0045, 'Location');
INSERT INTO MESSAGES VALUES(0046, 'Comments');
INSERT INTO MESSAGES VALUES(0047, 'Artists');
INSERT INTO MESSAGES VALUES(0048, 'Role');
INSERT INTO MESSAGES VALUES(0049, 'Fach');
INSERT INTO MESSAGES VALUES(0050, 'Composer');
INSERT INTO MESSAGES VALUES(0051, 'CD');
INSERT INTO MESSAGES VALUES(0052, 'DVD');
INSERT INTO MESSAGES VALUES(0053, 'VHS');
INSERT INTO MESSAGES VALUES(0054, 'Other');
INSERT INTO MESSAGES VALUES(0055, 'Add Row');
INSERT INTO MESSAGES VALUES(0056, 'Save');
INSERT INTO MESSAGES VALUES(0057, 'Update');
INSERT INTO MESSAGES VALUES(0058, 'Delete');
INSERT INTO MESSAGES VALUES(0059, 'Main Window');
INSERT INTO MESSAGES VALUES(0060, 'Required Field');
INSERT INTO MESSAGES VALUES(0061, 'Track Name');
INSERT INTO MESSAGES VALUES(0062, 'Add Track');
INSERT INTO MESSAGES VALUES(0063, 'View PDF');
INSERT INTO MESSAGES VALUES(0064, 'Genre');
INSERT INTO MESSAGES VALUES(0065, 'Symphony');
INSERT INTO MESSAGES VALUES(0066, 'Operetta');
INSERT INTO MESSAGES VALUES(0067, 'Other Classical');
INSERT INTO MESSAGES VALUES(0068, 'Popular');
INSERT INTO MESSAGES VALUES(0069, 'Jazz');
INSERT INTO MESSAGES VALUES(0070, 'Author');
INSERT INTO MESSAGES VALUES(0071, 'Page Count');
INSERT INTO MESSAGES VALUES(0072, 'Fiction');
INSERT INTO MESSAGES VALUES(0073, 'Sci Fi');
INSERT INTO MESSAGES VALUES(0074, 'Biography');
INSERT INTO MESSAGES VALUES(0075, 'Reference');
INSERT INTO MESSAGES VALUES(0076, 'Technical');
INSERT INTO MESSAGES VALUES(0077, 'Only numeric digits allowed');
INSERT INTO MESSAGES VALUES(0078, 'Drama');
INSERT INTO MESSAGES VALUES(0079, 'Comedy');
INSERT INTO MESSAGES VALUES(0080, 'Mystery');
INSERT INTO MESSAGES VALUES(0081, 'Thriller');
INSERT INTO MESSAGES VALUES(0082, 'Documentary');
INSERT INTO MESSAGES VALUES(0083, 'Instrumentation');
INSERT INTO MESSAGES VALUES(0084, 'Vocal with Piano');
INSERT INTO MESSAGES VALUES(0085, 'Piano Solo');
INSERT INTO MESSAGES VALUES(0086, 'String Solo');
INSERT INTO MESSAGES VALUES(0087, 'String with Piano');
INSERT INTO MESSAGES VALUES(0088, 'String Ensemble');
INSERT INTO MESSAGES VALUES(0089, 'String Quartet');
INSERT INTO MESSAGES VALUES(0090, 'Brass Solo');
INSERT INTO MESSAGES VALUES(0091, 'Brass Ensemble');
INSERT INTO MESSAGES VALUES(0092, 'Woodwind Solo');
INSERT INTO MESSAGES VALUES(0093, 'Woodwind Ensemble');
INSERT INTO MESSAGES VALUES(0094, 'Full Orchestra');
INSERT INTO MESSAGES VALUES(0095, 'Other Ensemble');
INSERT INTO MESSAGES VALUES(0096, 'Lead Sheet');
INSERT INTO MESSAGES VALUES(0097, 'Other Instruments');
INSERT INTO MESSAGES VALUES(0098, 'Publisher');
INSERT INTO MESSAGES VALUES(0099, 'Version');
INSERT INTO MESSAGES VALUES(0100, 'Website URL');
INSERT INTO MESSAGES VALUES(0101, 'Acrobat Reader');
INSERT INTO MESSAGES VALUES(0102, 'Browser');
INSERT INTO MESSAGES VALUES(0103, 'No Albums found');
INSERT INTO MESSAGES VALUES(0104, 'No Books found');
INSERT INTO MESSAGES VALUES(0105, 'No Movies found');
INSERT INTO MESSAGES VALUES(0106, 'No Operas found');
INSERT INTO MESSAGES VALUES(0107, 'No Scores found');
INSERT INTO MESSAGES VALUES(0108, 'No Software found');
INSERT INTO MESSAGES VALUES(0109, 'SQL Error Occurred');
INSERT INTO MESSAGES VALUES(0110, 'See the Brutus.log file for details');
INSERT INTO MESSAGES VALUES(0111, 'Cast of Characters');
INSERT INTO MESSAGES VALUES(0112, 'Delete Row');
INSERT INTO MESSAGES VALUES(0113, 'DeleteTrack');
INSERT INTO MESSAGES VALUES(0114, 'Characters and Interpreters');
INSERT INTO MESSAGES VALUES(0115, 'Tracks');
INSERT INTO MESSAGES VALUES(0116, 'Enter Name of Author/Composer');
INSERT INTO MESSAGES VALUES(0117, 'Enter Name of Conductor');
INSERT INTO MESSAGES VALUES(0118, 'Enter Name of Director');
INSERT INTO MESSAGES VALUES(0119, 'Enter Name of Artist');
INSERT INTO MESSAGES VALUES(0120, 'Enter Title');
INSERT INTO MESSAGES VALUES(0121, 'Author/Composer not found');
INSERT INTO MESSAGES VALUES(0122, 'Conductor not found');
INSERT INTO MESSAGES VALUES(0123, 'Director not found');
INSERT INTO MESSAGES VALUES(0124, 'Artist not found');
INSERT INTO MESSAGES VALUES(0125, 'Title not found');
INSERT INTO MESSAGES VALUES(0126, 'Enter Complete Path to MP3 Player');
INSERT INTO MESSAGES VALUES(0127, 'Enter Complete Path to MPG Player');
INSERT INTO MESSAGES VALUES(0128, 'Enter Complete Path to Acrobat Reader');
INSERT INTO MESSAGES VALUES(0129, 'Enter Complete Path to Browser');
INSERT INTO MESSAGES VALUES(0130, 'Country');
INSERT INTO MESSAGES VALUES(0131, 'Instrumental');
INSERT INTO MESSAGES VALUES(0132, 'Latino');
INSERT INTO MESSAGES VALUES(0133, 'Rock');
INSERT INTO MESSAGES VALUES(0134, 'Folk');
INSERT INTO MESSAGES VALUES(0135, 'German Schlager');
INSERT INTO MESSAGES VALUES(0136, 'German Volksmusik');
INSERT INTO MESSAGES VALUES(0137, 'Are you sure you want to delete');
INSERT INTO MESSAGES VALUES(0138, 'has been deleted from the database');
UPDATE SYSCONFIG SET SYS_INTEGER_VALUE = 0, SYS_DOUBLE_VALUE = 0,
   SYS_CHAR_VALUE = 'en' WHERE SYS_OPTION = 'CURRENT_LANGUAGE';
-----------------------------------------------------------------------
