/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import com.casaerwin.brutus.DBM;
import com.casaerwin.brutus.Software;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DBMSoftware
extends DBM {
    private static PreparedStatement newKeySoftware;
    private static PreparedStatement insertSoftware;
    private static PreparedStatement deleteSoftware;
    private static PreparedStatement retrieveSoftware;
    public static boolean psOpened;
    int DBMSwareRC;
    SQLException sqlEx;
    Vector softwareTitles;
    Vector row;

    DBMSoftware() {
        if (!psOpened) {
            try {
                String string = "SELECT MAX SOF_SEQ + 1 AS NEW_KEY FROM SOFTWARE;";
                newKeySoftware = conn.prepareStatement(string);
                string = "INSERT INTO SOFTWARE VALUES (?, ?, ?, ?, ?, ?, ?);";
                insertSoftware = conn.prepareStatement(string);
                string = "DELETE SOFTWARE WHERE SOF_PARENT_ID = ? AND SOF_PARENT_KEY = ?;";
                deleteSoftware = conn.prepareStatement(string);
                string = "SELECT SOF_AUTHOR, SOF_PUBLISHER, SOF_VERSION, SOF_WEBSITE FROM SOFTWARE WHERE SOF_PARENT_ID = ? AND SOF_PARENT_KEY = ?;";
                retrieveSoftware = conn.prepareStatement(string);
                this.DBMSwareRC = 0;
                psOpened = true;
            }
            catch (SQLException sQLException) {
                this.sqlEx = sQLException;
                this.DBMSwareRC = 12;
                this.handleSQLException(sQLException);
            }
        }
    }

    public void storeSoftware(Software software) {
        try {
            insertSoftware.setInt(1, this.getNewPrimaryKey());
            if (this.DBMSwareRC > 0) {
                return;
            }
            insertSoftware.setString(2, software.getAuthor());
            insertSoftware.setString(3, software.getPublisher());
            insertSoftware.setString(4, software.getVersion());
            insertSoftware.setString(5, software.getWebSite());
            insertSoftware.setInt(6, software.getIdentifier());
            insertSoftware.setInt(7, software.getSequence());
            insertSoftware.executeUpdate();
            this.DBMSwareRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMSwareRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    int getNewPrimaryKey() {
        try {
            ResultSet resultSet = newKeySoftware.executeQuery();
            if (resultSet.next()) {
                this.DBMSwareRC = 0;
                return resultSet.getInt("NEW_KEY");
            }
            this.DBMSwareRC = 8;
            return 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMSwareRC = 12;
            this.handleSQLException(sQLException);
            return 0;
        }
    }

    public void deleteSoftware(int n, int n2) {
        try {
            deleteSoftware.setInt(1, n);
            deleteSoftware.setInt(9, n2);
            deleteSoftware.executeUpdate();
            this.DBMSwareRC = 0;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMSwareRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    public void retrieveSoftware(Software software) {
        try {
            retrieveSoftware.setInt(1, software.getIdentifier());
            retrieveSoftware.setInt(2, software.getSequence());
            ResultSet resultSet = retrieveSoftware.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                software.setAuthor(resultSet.getString("SOF_AUTHOR"));
                software.setPublisher(resultSet.getString("SOF_PUBLISHER"));
                software.setVersion(resultSet.getString("SOF_VERSION"));
                software.setWebSite(resultSet.getString("SOF_WEBSITE"));
                ++n;
            }
            this.DBMSwareRC = n > 0 ? 0 : 8;
        }
        catch (SQLException sQLException) {
            this.sqlEx = sQLException;
            this.DBMSwareRC = 12;
            this.handleSQLException(sQLException);
        }
    }

    static {
        psOpened = false;
    }
}

