/*
 * Decompiled with CFR 0.152.
 */
package com.casaerwin.brutus;

import com.casaerwin.brutus.Book;
import com.casaerwin.brutus.DBMBook;
import com.casaerwin.brutus.DBMEntity;
import com.casaerwin.brutus.DBMMessenger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class BookDialog
extends JDialog
implements ActionListener {
    private int rc = 0;
    DBMMessenger dbmMessenger = new DBMMessenger();
    Font hdr1Font = new Font("sanserif", 1, 16);
    Font hdr2Font = new Font("sanserif", 1, 12);
    Font labelFont = new Font("sanserif", 1, 10);
    Color lblColor = new Color(204, 204, 102);
    Color bttnColor = new Color(185, 255, 185);
    JLabel titleLabel = new JLabel(this.dbmMessenger.getMessage(26) + ": ");
    JLabel authLabel = new JLabel(this.dbmMessenger.getMessage(70) + ": ");
    JLabel publLabel = new JLabel(this.dbmMessenger.getMessage(98) + ": ");
    JLabel dteLabel = new JLabel(this.dbmMessenger.getMessage(43) + ": ");
    JLabel pgCntLabel = new JLabel(this.dbmMessenger.getMessage(71) + ": ");
    JLabel mediaLabel = new JLabel(this.dbmMessenger.getMessage(44) + ": ");
    JLabel genreLabel = new JLabel(this.dbmMessenger.getMessage(64) + ": ");
    JLabel locLabel = new JLabel(this.dbmMessenger.getMessage(45) + ": ");
    JLabel commLabel = new JLabel(this.dbmMessenger.getMessage(46) + ": ");
    Object[] mediaOb = new Object[]{"1 - " + this.dbmMessenger.getMessage(51), "2 - " + this.dbmMessenger.getMessage(52), "3 - " + this.dbmMessenger.getMessage(53), "4 - " + this.dbmMessenger.getMessage(0), "5 - " + this.dbmMessenger.getMessage(54)};
    Object[] genreOb = new Object[]{"1 - " + this.dbmMessenger.getMessage(72), "2 - " + this.dbmMessenger.getMessage(73), "3 - " + this.dbmMessenger.getMessage(74), "4 - " + this.dbmMessenger.getMessage(75), "5 - " + this.dbmMessenger.getMessage(76), "6 - " + this.dbmMessenger.getMessage(54)};
    JTextField titleTF = new JTextField();
    JTextField authTF = new JTextField();
    JTextField publTF = new JTextField();
    JTextField dteTF = new JTextField();
    JTextField pgCntTF = new JTextField();
    JTextField locTF = new JTextField();
    JTextArea commTA;
    JComboBox mediaCB = new JComboBox<Object>(this.mediaOb);
    JComboBox genreCB = new JComboBox<Object>(this.genreOb);
    JButton newButton = new JButton(this.dbmMessenger.getMessage(56));
    JButton updButton = new JButton(this.dbmMessenger.getMessage(57));
    JButton delOButton = new JButton(this.dbmMessenger.getMessage(58));
    JButton retButton = new JButton(this.dbmMessenger.getMessage(59));
    Book book;

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, double d, double d2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
    }

    BookDialog(Frame frame, Book book, int n) {
        super(frame, true);
        if (n != 1) {
            if (n != 2) {
                return;
            }
        }
        this.book = book;
        this.setSize(560, 300);
        this.setTitle(this.dbmMessenger.getMessage(33));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        this.commTA = new JTextArea(5, 50);
        this.commTA.setFont(this.hdr2Font);
        JScrollPane jScrollPane = new JScrollPane(this.commTA, 22, 31);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 25.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.newButton.setFont(this.hdr1Font);
        this.newButton.addActionListener(this);
        if (n != 1) {
            this.newButton.setEnabled(false);
        }
        gridBagLayout.setConstraints(this.newButton, gridBagConstraints);
        jPanel.add(this.newButton);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 25.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.updButton.setFont(this.hdr1Font);
        this.updButton.addActionListener(this);
        if (n != 2) {
            this.updButton.setEnabled(false);
        }
        gridBagLayout.setConstraints(this.updButton, gridBagConstraints);
        jPanel.add(this.updButton);
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 25.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.delOButton.setFont(this.hdr1Font);
        this.delOButton.addActionListener(this);
        if (n != 2) {
            this.delOButton.setEnabled(false);
        }
        gridBagLayout.setConstraints(this.delOButton, gridBagConstraints);
        jPanel.add(this.delOButton);
        this.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 25.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.retButton.setFont(this.hdr1Font);
        this.retButton.addActionListener(this);
        gridBagLayout.setConstraints(this.retButton, gridBagConstraints);
        jPanel.add(this.retButton);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.titleLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.titleLabel, gridBagConstraints);
        jPanel.add(this.titleLabel);
        this.buildConstraints(gridBagConstraints, 1, 1, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.titleTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.titleTF, gridBagConstraints);
        jPanel.add(this.titleTF);
        if (n == 2) {
            this.titleTF.setText(this.book.getTitle());
        }
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.authLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.authLabel, gridBagConstraints);
        jPanel.add(this.authLabel);
        this.buildConstraints(gridBagConstraints, 1, 2, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.authTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.authTF, gridBagConstraints);
        jPanel.add(this.authTF);
        if (n == 2) {
            this.authTF.setText(this.book.getAuthor());
        }
        this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.publLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.publLabel, gridBagConstraints);
        jPanel.add(this.publLabel);
        this.buildConstraints(gridBagConstraints, 1, 3, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.publTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.publTF, gridBagConstraints);
        jPanel.add(this.publTF);
        if (n == 2) {
            this.publTF.setText(this.book.getPublisher());
        }
        this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.dteLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.dteLabel, gridBagConstraints);
        jPanel.add(this.dteLabel);
        this.buildConstraints(gridBagConstraints, 1, 4, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.dteTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.dteTF, gridBagConstraints);
        jPanel.add(this.dteTF);
        if (n == 2) {
            this.dteTF.setText(this.book.getDate());
        }
        this.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.pgCntLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.pgCntLabel, gridBagConstraints);
        jPanel.add(this.pgCntLabel);
        this.buildConstraints(gridBagConstraints, 1, 5, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.pgCntTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.pgCntTF, gridBagConstraints);
        jPanel.add(this.pgCntTF);
        if (n == 2) {
            this.pgCntTF.setText("" + this.book.getPageCount());
        }
        this.buildConstraints(gridBagConstraints, 0, 6, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.locLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.locLabel, gridBagConstraints);
        jPanel.add(this.locLabel);
        this.buildConstraints(gridBagConstraints, 1, 6, 3, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.locTF.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.locTF, gridBagConstraints);
        jPanel.add(this.locTF);
        if (n == 2) {
            this.locTF.setText(this.book.getLocation());
        }
        this.buildConstraints(gridBagConstraints, 0, 7, 1, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.mediaLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.mediaLabel, gridBagConstraints);
        jPanel.add(this.mediaLabel);
        this.buildConstraints(gridBagConstraints, 1, 7, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.mediaCB.setFont(this.hdr2Font);
        this.mediaCB.setEditable(false);
        gridBagLayout.setConstraints(this.mediaCB, gridBagConstraints);
        jPanel.add(this.mediaCB);
        if (n == 2) {
            this.mediaCB.setSelectedIndex(this.book.getMedia() - 1);
        }
        this.buildConstraints(gridBagConstraints, 2, 7, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        this.genreLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.genreLabel, gridBagConstraints);
        jPanel.add(this.genreLabel);
        this.buildConstraints(gridBagConstraints, 3, 7, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.genreCB.setFont(this.hdr2Font);
        this.genreCB.setEditable(false);
        gridBagLayout.setConstraints(this.genreCB, gridBagConstraints);
        jPanel.add(this.genreCB);
        if (n == 2) {
            this.genreCB.setSelectedIndex(this.book.getGenre() - 1);
        }
        this.buildConstraints(gridBagConstraints, 0, 8, 4, 1, 0.0, 5.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.commLabel.setFont(this.hdr2Font);
        gridBagLayout.setConstraints(this.commLabel, gridBagConstraints);
        jPanel.add(this.commLabel);
        this.buildConstraints(gridBagConstraints, 0, 9, 4, 1, 0.0, 25.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        if (n == 2) {
            this.commTA.append(this.book.getComments());
        }
        this.setContentPane(jPanel);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.newButton) {
            this.validateBook();
            if (this.rc == 0) {
                this.populateBook();
                DBMEntity dBMEntity = new DBMEntity();
                dBMEntity.storeEntity(this.book);
                DBMBook dBMBook = new DBMBook();
                dBMBook.storeBook(this.book);
                this.resetDialog();
            }
        } else if (object == this.updButton) {
            this.validateBook();
            if (this.rc == 0) {
                this.populateBook();
                DBMEntity dBMEntity = new DBMEntity();
                dBMEntity.updateEntity(this.book);
                DBMBook dBMBook = new DBMBook();
                dBMBook.deleteBook(this.book.getIdentifier(), this.book.getSequence());
                dBMBook.storeBook(this.book);
                if (dBMEntity.DBMEntityRC == 0) {
                    if (dBMBook.DBMBookRC == 0) {
                        this.setVisible(false);
                    }
                }
            }
        } else if (object == this.delOButton) {
            String string = this.dbmMessenger.getMessage(137) + " " + this.book.getTitle() + " " + this.dbmMessenger.getMessage(139) + "?";
            int n = JOptionPane.showConfirmDialog(null, string);
            if (n == 0) {
                DBMEntity dBMEntity = new DBMEntity();
                dBMEntity.deleteEntity(this.book);
                if (dBMEntity.DBMEntityRC == 0) {
                    string = this.book.getTitle() + " " + this.dbmMessenger.getMessage(138) + ".";
                    JOptionPane.showMessageDialog(null, string);
                    this.setVisible(false);
                }
            }
        } else if (object == this.retButton) {
            this.setVisible(false);
        }
    }

    public void validateBook() {
        DBMMessenger dBMMessenger = new DBMMessenger();
        String string = dBMMessenger.getMessage(60);
        if (this.titleTF.getText().equals("") || this.titleTF.getText() == null) {
            String string2 = dBMMessenger.getMessage(26) + ": " + string;
            JOptionPane.showMessageDialog(null, string2, string, 0);
            this.titleTF.setCaretPosition(0);
            this.rc = 1;
        } else if (this.locTF.getText().equals("") || this.locTF.getText() == null) {
            String string3 = dBMMessenger.getMessage(45) + ": " + string;
            JOptionPane.showMessageDialog(null, string3, string, 0);
            this.locTF.setCaretPosition(0);
            this.rc = 1;
        }
    }

    public void populateBook() {
        String string;
        this.book.setTitle(this.titleTF.getText());
        this.book.setAuthor(this.authTF.getText());
        this.book.setPublisher(this.publTF.getText());
        this.book.setDate(this.dteTF.getText());
        try {
            this.book.setPageCount(Integer.parseInt(this.pgCntTF.getText().substring(0)));
        }
        catch (NumberFormatException numberFormatException) {
            string = this.dbmMessenger.getMessage(71);
            String string2 = this.dbmMessenger.getMessage(77);
            JOptionPane.showMessageDialog(null, string2, string, 0);
        }
        this.book.setLocation(this.locTF.getText());
        String string3 = (String)this.mediaCB.getSelectedItem();
        this.book.setMedia(Integer.parseInt(string3.substring(0, 1)));
        string = (String)this.genreCB.getSelectedItem();
        this.book.setGenre(Integer.parseInt(string.substring(0, 1)));
        this.book.setComments(this.commTA.getText());
    }

    public void resetDialog() {
        this.titleTF.setText("");
        this.locTF.setText("");
        this.authTF.setText("");
        this.publTF.setText("");
        this.dteTF.setText("");
        this.pgCntTF.setText("");
        this.commTA.setText("");
        this.mediaCB.setSelectedItem(this.mediaOb[0]);
        this.genreCB.setSelectedItem(this.genreOb[0]);
    }
}

