/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import net.sf.accolorhelper.ui.CellMouseAdapter;
import net.sf.accolorhelper.ui.ValueValidator;

public class ValueTableComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private int[][] aValues;
    private ValueValidator aValidator;
    private boolean[][] aSelection;

    public ValueTableComponent(int[][] pValues, ValueValidator pValidator, boolean[][] pSelection) {
        this.aValues = pValues;
        this.aValidator = pValidator;
        this.aSelection = pSelection;
        this.addMouseListener(new CellMouseAdapter(){

            public void mouseClicked(MouseEvent pEvent) {
                if (this.isInCell(pEvent.getX(), pEvent.getY())) {
                    int lHorizontalCellIndex = this.getCellIndex(pEvent.getX());
                    int lVerticalCellIndex = this.getCellIndex(pEvent.getY());
                    if (lHorizontalCellIndex < ValueTableComponent.this.aValues.length && lVerticalCellIndex < ValueTableComponent.this.aValues.length) {
                        ((ValueTableComponent)ValueTableComponent.this).aSelection[lHorizontalCellIndex][lVerticalCellIndex] = !ValueTableComponent.this.aSelection[lHorizontalCellIndex][lVerticalCellIndex];
                        ((ValueTableComponent)ValueTableComponent.this).aSelection[lVerticalCellIndex][lHorizontalCellIndex] = ValueTableComponent.this.aSelection[lHorizontalCellIndex][lVerticalCellIndex];
                        ValueTableComponent.this.repaint();
                    }
                }
            }
        });
    }

    public Dimension getMinimumSize() {
        return new Dimension(45 * this.aValues.length + 5, 45 * this.aValues.length + 5);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics pGraphics) {
        Color lForegroundColor = pGraphics.getColor();
        Font lInvalidFont = pGraphics.getFont();
        Font lValidFont = lInvalidFont.deriveFont(1, (int)((double)lInvalidFont.getSize() * 1.3));
        for (int lOuterValueIndex = 0; lOuterValueIndex < this.aValues.length; ++lOuterValueIndex) {
            for (int lInnerValueIndex = 0; lInnerValueIndex < this.aValues.length; ++lInnerValueIndex) {
                if (this.aSelection[lOuterValueIndex][lInnerValueIndex]) {
                    pGraphics.fillRect(5 + lOuterValueIndex * 45, 5 + lInnerValueIndex * 45, 40, 40);
                    pGraphics.setColor(this.getBackground());
                    pGraphics.fillRect(5 + lOuterValueIndex * 45 + 5 - 1, 5 + lInnerValueIndex * 45 + 5 - 1, 32, 32);
                    pGraphics.setColor(lForegroundColor);
                }
                if (this.aValidator.isValid(this.aValues[lOuterValueIndex][lInnerValueIndex])) {
                    pGraphics.setFont(lValidFont);
                } else {
                    pGraphics.setFont(lInvalidFont);
                }
                String lText = String.valueOf(this.aValues[lOuterValueIndex][lInnerValueIndex]);
                FontMetrics lFontMetrics = pGraphics.getFontMetrics();
                int lTextX = (30 - (int)lFontMetrics.getStringBounds(lText, pGraphics).getWidth()) / 2;
                int lTextY = (30 - lFontMetrics.getHeight()) / 2 + lFontMetrics.getAscent();
                pGraphics.drawString(lText, 5 + lOuterValueIndex * 45 + 5 + lTextX, 5 + lInnerValueIndex * 45 + 5 + lTextY);
            }
        }
    }

    public void setValues(int[][] pBrightnessDifference, boolean[][] pSelection) {
        this.aValues = pBrightnessDifference;
        this.aSelection = pSelection;
        this.invalidate();
        this.repaint();
    }
}

