/*
 * Decompiled with CFR 0.152.
 */
package net.sf.accolorhelper.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sf.accolorhelper.ui.ColorCombinationsComponent;
import net.sf.accolorhelper.ui.GreaterThanValidator;
import net.sf.accolorhelper.ui.ValueTableComponent;

public class ColorComparisonComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ColorCombinationsComponent aColorChart;
    private ValueTableComponent aDifference400Chart;
    private ValueTableComponent aDifference500Chart;
    private ValueTableComponent aBrightnessChart;
    private ResourceBundle aResources;

    public ColorComparisonComponent() {
    }

    public ColorComparisonComponent(Color[] pColors, boolean[][] pSelection) {
        this.init(pColors, pSelection);
    }

    public ColorComparisonComponent(boolean pIsDoubleBuffered, Color[] pColors, boolean[][] pSelection) {
        super(pIsDoubleBuffered);
        this.init(pColors, pSelection);
    }

    public void setColors(Color[] pColors, boolean[][] pSelection) {
        int lNumberOfColors = pColors.length;
        int[][] lBrightnessDifference = new int[lNumberOfColors][lNumberOfColors];
        int[][] lColorDifference = new int[lNumberOfColors][lNumberOfColors];
        this.calculateDifferences(pColors, lBrightnessDifference, lColorDifference);
        this.aColorChart.setColors(pColors, pSelection);
        this.aBrightnessChart.setValues(lBrightnessDifference, pSelection);
        this.aDifference500Chart.setValues(lColorDifference, pSelection);
        this.aDifference400Chart.setValues(lColorDifference, pSelection);
    }

    private void init(Color[] pColors, boolean[][] pSelection) {
        this.aResources = ResourceBundle.getBundle(ColorComparisonComponent.class.getName());
        int lNumberOfColors = pColors.length;
        int[][] lBrightnessDifference = new int[lNumberOfColors][lNumberOfColors];
        int[][] lColorDifference = new int[lNumberOfColors][lNumberOfColors];
        this.calculateDifferences(pColors, lBrightnessDifference, lColorDifference);
        GridBagLayout lLayout = new GridBagLayout();
        this.setLayout(lLayout);
        JTabbedPane lInnerPane = this.createInnerChildren(pColors, lBrightnessDifference, lColorDifference, pSelection);
        this.add(lInnerPane);
        GridBagConstraints lConstraints = new GridBagConstraints();
        lConstraints.insets = new Insets(10, 10, 10, 10);
        lConstraints.weightx = 1.0;
        lConstraints.weighty = 1.0;
        lConstraints.fill = 1;
        lLayout.setConstraints(lInnerPane, lConstraints);
    }

    private JTabbedPane createInnerChildren(Color[] pColors, int[][] pBrightnessDifference, int[][] pColorDifference, boolean[][] pSelection) {
        JTabbedPane result = new JTabbedPane(1, 0);
        this.aColorChart = new ColorCombinationsComponent(pColors, pSelection);
        JScrollPane lScrollPane = new JScrollPane(this.aColorChart);
        result.add(this.aResources.getString("tab.color"), lScrollPane);
        this.aBrightnessChart = new ValueTableComponent(pBrightnessDifference, new GreaterThanValidator(125), pSelection);
        lScrollPane = new JScrollPane(this.aBrightnessChart);
        result.add(this.aResources.getString("tab.brightness"), lScrollPane);
        this.aDifference500Chart = new ValueTableComponent(pColorDifference, new GreaterThanValidator(500), pSelection);
        lScrollPane = new JScrollPane(this.aDifference500Chart);
        result.add(this.aResources.getString("tab.colordifference500"), lScrollPane);
        this.aDifference400Chart = new ValueTableComponent(pColorDifference, new GreaterThanValidator(400), pSelection);
        lScrollPane = new JScrollPane(this.aDifference400Chart);
        result.add(this.aResources.getString("tab.colordifference400"), lScrollPane);
        return result;
    }

    private void calculateDifferences(Color[] pColors, int[][] lBrightnessDifference, int[][] aColorDifference) {
        int lOuterColorIndex;
        int numberOfColors = pColors.length;
        int[] lBrightness = new int[numberOfColors];
        for (lOuterColorIndex = 0; lOuterColorIndex < numberOfColors; ++lOuterColorIndex) {
            Color color = pColors[lOuterColorIndex];
            lBrightness[lOuterColorIndex] = (color.getRed() * 299 + color.getGreen() * 587 + color.getBlue() * 114 + 500) / 1000;
            for (int lInnerColorIndex = 0; lInnerColorIndex < numberOfColors; ++lInnerColorIndex) {
                Color otherColor = pColors[lInnerColorIndex];
                aColorDifference[lOuterColorIndex][lInnerColorIndex] = Math.max(color.getRed(), otherColor.getRed()) - Math.min(color.getRed(), otherColor.getRed()) + Math.max(color.getGreen(), otherColor.getGreen()) - Math.min(color.getGreen(), otherColor.getGreen()) + Math.max(color.getBlue(), otherColor.getBlue()) - Math.min(color.getBlue(), otherColor.getBlue());
            }
        }
        for (lOuterColorIndex = 0; lOuterColorIndex < numberOfColors; ++lOuterColorIndex) {
            for (int lInnerColorIndex = 0; lInnerColorIndex < numberOfColors; ++lInnerColorIndex) {
                lBrightnessDifference[lOuterColorIndex][lInnerColorIndex] = Math.abs(lBrightness[lOuterColorIndex] - lBrightness[lInnerColorIndex]);
            }
        }
    }
}

