/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.AggManager;
import borland.jbcl.dataset.CalcAggFieldsListener;
import borland.jbcl.dataset.CalcFieldsListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnList;
import borland.jbcl.dataset.DataFile;
import borland.jbcl.dataset.DataRow;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DataSetView;
import borland.jbcl.dataset.EditListener;
import borland.jbcl.dataset.InternalRow;
import borland.jbcl.dataset.LoadCancel;
import borland.jbcl.dataset.LoadEvent;
import borland.jbcl.dataset.LoadListener;
import borland.jbcl.dataset.MasterLinkDescriptor;
import borland.jbcl.dataset.MasterUpdateEvent;
import borland.jbcl.dataset.MasterUpdateListener;
import borland.jbcl.dataset.MatrixData;
import borland.jbcl.dataset.MemoryStore;
import borland.jbcl.dataset.ReadRow;
import borland.jbcl.dataset.ReadWriteRow;
import borland.jbcl.dataset.Res;
import borland.jbcl.dataset.Resolver;
import borland.jbcl.dataset.StatusEvent;
import borland.jbcl.dataset.StatusListener;
import borland.jbcl.dataset.Store;
import borland.jbcl.dataset.TableDataSet;
import borland.jbcl.dataset.ValidationException;
import borland.jbcl.util.ErrorResponse;
import borland.jbcl.util.EventMulticaster;
import borland.jbcl.util.Variant;
import java.beans.Beans;
import java.util.Locale;
import java.util.TooManyListenersException;

public abstract class StorageDataSet
extends DataSet {
    private static int BlockReadOnly = 1;
    private static int BlockRestructure = 2;
    private static int BlockNotUpdatable = 4;
    private static int BlockNotOpen = 8;
    private static int BlockCorrupt = 16;
    private static int BlockResolve = 32;
    private static int BlockResolvePending = 64;
    private int maxRows;
    private int maxDesignRows;
    private MatrixData data;
    private DataSet[] dataChangeListeners;
    private EventMulticaster validationErrorListeners;
    private EventMulticaster statusListeners;
    private EventMulticaster accessListeners;
    private EventMulticaster loadListeners;
    private EventMulticaster masterUpdateListeners;
    private MasterUpdateEvent masterUpdateEvent;
    private String schemaName;
    private String tableName;
    private String storeName;
    private int editBlocked;
    private int loadBlocked;
    private boolean loading;
    private int loadedRows;
    private int maxLoadRows;
    private StatusEvent loadingEvent;
    private LoadCancel loader;
    private DataRow loadRow;
    private Variant[] loadValues;
    private int loadStatus;
    private boolean loadAsync;
    private int metaDataUpdate;
    private boolean dataFileChanged;
    private DataFile dataFile;
    private CalcFieldsListener calcFieldsListener;
    CalcAggFieldsListener calcAggFieldsListener;
    DataRow calcFieldsRow;
    private Column[] calcFieldsColumns;
    private Variant[] calcFieldsValues;
    private AggManager aggManager;
    private Resolver resolver;
    private Store store;
    EditListener editListener;
    private boolean restructureColumns;
    private ErrorResponse response;
    private Locale locale;
    private boolean editable;

    StorageDataSet() {
        this.dataSetStore = this;
        this.loadingEvent = new StatusEvent(this, 1, null);
        this.maxRows = -1;
        this.maxDesignRows = 50;
        this.editBlocked = BlockNotOpen;
        this.aggManager = null;
        this.metaDataUpdate = 1;
        this.editable = true;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    private final void addDataColumn(Column column) throws DataSetException {
        if (this.data != null) {
            this.data.addColumn(column);
        }
    }

    private void initData() throws DataSetException {
        this.data = this.produceStore().openDataSet(this, this.data);
    }

    public final void setStore(Store store) {
        this.store = store;
    }

    public final Store getStore() {
        return this.store;
    }

    private Store produceStore() {
        if (this.store == null) {
            this.store = new MemoryStore();
        }
        return this.store;
    }

    public final boolean isStorageOpen() {
        return (this.editBlocked & BlockNotOpen) == 0;
    }

    protected void failIfOpen() throws DataSetException {
        if (this.isStorageOpen()) {
            DataSetException.throwDataSetOpen();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized boolean openStorage(DataSet dataSet, AccessEvent accessEvent) throws DataSetException {
        block14: {
            if (this.isStorageOpen()) return false;
            if (this.restructureColumns) {
                this.columnList = new ColumnList(this, this.columnList);
            }
            if (this.calcFieldsListener != null && this.columnList.getCalcFieldColumns(false) == null) {
                DataSetException.throwNoCalcFields();
            }
            if (this.calcAggFieldsListener != null && this.columnList.getCalcFieldColumns(true) == null) {
                DataSetException.throwNoCalcFields();
            }
            if (this.dataFileChanged && this.dataFile != null && this.dataFile.isLoadOnOpen()) {
                this.dataFileChanged = false;
                if (this.columnCount() != 0) {
                    this._empty();
                }
                try {
                    try {
                        this.dataFile.load(this);
                    }
                    catch (Exception exception) {
                        this.closeStorage(7);
                        DataSetException.throwException(60, Res.getString(53), exception);
                        Object var5_4 = null;
                        if (!this.isOpen()) {
                            this.closeStorage(7);
                        }
                        break block14;
                    }
                    Object var5_3 = null;
                    if (this.isOpen()) break block14;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (this.isOpen()) throw throwable;
                    this.closeStorage(7);
                    throw throwable;
                }
                this.closeStorage(7);
            }
        }
        this.initData();
        this.setEditBlock(BlockNotOpen, false);
        if (this.accessListeners != null) {
            DataSet.dispatchOpenAccessEvent(this.accessListeners, this, accessEvent);
        }
        if (this.getNeedsRecalc()) {
            this.recalc();
        }
        try {
            this.open();
            Object var7_8 = null;
            if (this.isOpen()) return true;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (this.isOpen()) throw throwable;
            this.closeStorage(7);
            throw throwable;
        }
        this.closeStorage(7);
        return true;
    }

    synchronized void columnStructuralChange() throws DataSetException {
        this.failIfOpen();
        this.restructureColumns = true;
    }

    public final boolean closeStorage(int n) throws DataSetException {
        if (this.isStorageOpen()) {
            if (this.accessListeners != null) {
                DataSet.dispatchAccessEvent(this.accessListeners, new AccessEvent(this, 2, n));
            }
            StorageDataSet storageDataSet = this;
            synchronized (storageDataSet) {
                try {
                    this.setEditBlock(BlockNotOpen, true);
                    this.data = this.produceStore().closeDataSet(this, this.data, n);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
            return true;
        }
        return false;
    }

    final void startEditing() throws DataSetException {
        if (this.editBlocked != 0) {
            this.editError();
        }
    }

    private final void editError() throws DataSetException {
        if ((this.editBlocked & BlockCorrupt) != 0) {
            DataSetException.throwDataSetCorrupt();
        }
        if ((this.editBlocked & BlockNotOpen) != 0) {
            DataSetException.throwDataSetNotOpen();
        }
        if ((this.editBlocked & BlockReadOnly) != 0) {
            ValidationException.throwReadOnlyDataSet();
        }
        if ((this.editBlocked & BlockRestructure) != 0) {
            DataSetException.throwRestructureInProgress();
        }
        if ((this.editBlocked & BlockNotUpdatable) != 0) {
            DataSetException.throwNotUpdatable();
        }
        if ((this.loadBlocked & (BlockResolve | BlockResolvePending)) != 0) {
            DataSetException.throwResolveInProgress();
        }
    }

    private boolean prepareRestructure() throws DataSetException {
        boolean bl = this.closeStorage(8);
        this.columnList = new ColumnList(this, this.columnList);
        this.setEditBlock(BlockRestructure, true);
        if (this.data != null) {
            this.data.prepareRestructure(this);
        }
        return bl;
    }

    private void commitRestructure(AccessEvent accessEvent, boolean bl) throws DataSetException {
        this.failIfOpen();
        this.columnList.invalidateDataRows();
        this.columnList.clearCache();
        this.setEditBlock(BlockRestructure, false);
        if (this.data != null) {
            this.data.commitRestructure(this);
        }
        if (bl) {
            this.openStorage(null, accessEvent);
        }
    }

    public final int addColumn(Column column) throws DataSetException {
        int n = -1;
        Column column2 = (Column)column.clone();
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            try {
                boolean bl = this.prepareRestructure();
                try {
                    ColumnList columnList = new ColumnList(this, this.columnList);
                    n = columnList.addColumn(this, column2);
                    this.addDataColumn(columnList.columns[n]);
                    this.columnList = columnList;
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.commitRestructure(new AccessEvent(this, 1, 3), bl);
                    throw throwable;
                }
                this.commitRestructure(new AccessEvent(this, 1, 3), bl);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                throw throwable;
            }
        }
        return n;
    }

    public final int addUniqueColumn(Column column) throws DataSetException {
        Column column2 = this.hasColumn(column.getColumnName());
        if (column2 == null) {
            return this.addColumn(column);
        }
        return column2.ordinal;
    }

    public final int addColumn(String string, String string2, int n) throws DataSetException {
        return this.addColumn(new Column(string, string2, n));
    }

    public final int addColumn(String string, int n) throws DataSetException {
        return this.addColumn(string, string, n);
    }

    public final synchronized void changeColumn(int n, Column column) throws DataSetException {
        AccessEvent accessEvent;
        Column column2 = this.getColumn(n);
        boolean bl = this.prepareRestructure();
        try {
            if (this.data != null) {
                this.data.changeColumn(n, column2, column);
            }
            this.columnList.changeColumn(this, n, column);
            Object var6_5 = null;
            accessEvent = new AccessEvent((Object)this, 1, 5, column2, column);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            AccessEvent accessEvent2 = new AccessEvent((Object)this, 1, 5, column2, column);
            this.commitRestructure(accessEvent2, bl);
            throw throwable;
        }
        this.commitRestructure(accessEvent, bl);
    }

    public final synchronized void moveColumn(int n, int n2) throws DataSetException {
        AccessEvent accessEvent;
        boolean bl = this.prepareRestructure();
        try {
            this.columnList.moveColumn(n, n2);
            if (this.data != null) {
                this.data.moveColumn(n, n2);
            }
            Object var5_4 = null;
            accessEvent = new AccessEvent((Object)this, 1, 6, n, n2);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            AccessEvent accessEvent2 = new AccessEvent((Object)this, 1, 6, n, n2);
            this.commitRestructure(accessEvent2, bl);
            throw throwable;
        }
        this.commitRestructure(accessEvent, bl);
    }

    public final boolean getNeedsRestructure() {
        if (this.data != null) {
            return this.data.getNeedsRestructure();
        }
        return false;
    }

    public final void restructure(boolean bl) throws DataSetException {
        if (bl) {
            this.initCalcs();
        }
        boolean bl2 = false;
        try {
            this.data.restructure(this, bl, this.calcFieldsColumns, this.calcFieldsValues, this.aggManager);
            bl2 = true;
            Object var4_3 = null;
            if (bl) {
                if (bl2) {
                    this.setNeedsRecalc(false);
                } else {
                    this.clearCalcFieldsState();
                }
                if (this.aggManager != null) {
                    this.aggManager.setLoading(false);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (bl) {
                if (bl2) {
                    this.setNeedsRecalc(false);
                } else {
                    this.clearCalcFieldsState();
                }
                if (this.aggManager != null) {
                    this.aggManager.setLoading(false);
                }
            }
            throw throwable;
        }
    }

    final synchronized void setNeedsRecalc(boolean bl) {
        if (this.data != null) {
            this.data.setNeedsRecalc(bl);
        }
        if (bl) {
            this.clearCalcFieldsState();
        }
    }

    private final boolean getNeedsRecalc() {
        if (this.data != null) {
            return this.data.getNeedsRecalc();
        }
        return false;
    }

    public synchronized void setColumns(Column[] columnArray) throws DataSetException {
        this.failIfOpen();
        if (this.data != null) {
            this.dropColumns(false, true, columnArray);
        }
        this.addUniqueColumns(columnArray);
        for (int i = 0; i < this.columnList.columns.length; ++i) {
            this.columnList.columns[i].setPersist(true);
        }
    }

    protected int[] replaceColumns(Column[] columnArray, boolean bl) throws DataSetException {
        this.dropColumns(true, bl, columnArray);
        return this.addUniqueColumns(columnArray);
    }

    private int[] addUniqueColumns(Column[] columnArray) throws DataSetException {
        boolean bl = false;
        int[] nArray = new int[columnArray.length];
        try {
            for (int i = 0; i < columnArray.length; ++i) {
                Column column = columnArray[i];
                Column column2 = this.hasColumn(column.getColumnName());
                if (column2 != null) {
                    nArray[i] = column2.ordinal;
                    Column column3 = (Column)column2.clone();
                    column3.reconcile(column, this.forceNewMetadata());
                    this.changeColumn(column2.ordinal, column3);
                    continue;
                }
                nArray[i] = this.addColumn(columnArray[i]);
            }
            bl = true;
            Object var9_8 = null;
            if (!bl) {
                this.editBlocked |= BlockCorrupt;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!bl) {
                this.editBlocked |= BlockCorrupt;
            }
            throw throwable;
        }
        return nArray;
    }

    private static final Column hasColumn(Column[] columnArray, String string) {
        for (int i = 0; i < columnArray.length; ++i) {
            if (!columnArray[i].getColumnName().equals(string)) continue;
            return columnArray[i];
        }
        return null;
    }

    private final void dropColumns(boolean bl, boolean bl2, Column[] columnArray) throws DataSetException {
        Column[] columnArray2 = this.columnList.columns;
        if (columnArray2 != null) {
            for (int i = 0; i < columnArray2.length; ++i) {
                if (bl && columnArray2[i].isPersist() || bl2 && StorageDataSet.hasColumn(columnArray, columnArray2[i].getColumnName()) != null) continue;
                this.dropColumn(columnArray2[i]);
            }
        }
    }

    public Column[] cloneColumns() {
        return this.columnList.cloneColumns();
    }

    public Column[] getColumns() {
        return this.columnList.getColumns();
    }

    public final void dropColumn(String string) throws DataSetException {
        this.dropColumn(this.columnList.getColumn(string));
    }

    public final void dropColumn(Column column) throws DataSetException {
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            try {
                AccessEvent accessEvent;
                boolean bl = this.prepareRestructure();
                try {
                    int n = this.columnList.dropColumn((Column)column).ordinal;
                    if (this.data != null) {
                        this.data.dropColumn(n);
                    }
                    Object var6_5 = null;
                    accessEvent = new AccessEvent(this, 1, 4, column);
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    AccessEvent accessEvent2 = new AccessEvent(this, 1, 4, column);
                    this.commitRestructure(accessEvent2, bl);
                    throw throwable;
                }
                this.commitRestructure(accessEvent, bl);
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                throw throwable;
            }
        }
    }

    final void storageAddMasterUpdateListener(MasterUpdateListener masterUpdateListener) {
        this.masterUpdateListeners = EventMulticaster.add(this.masterUpdateListeners, masterUpdateListener);
        if (this.masterUpdateEvent == null) {
            this.masterUpdateEvent = new MasterUpdateEvent(this);
        }
    }

    final void storageRemoveMasterUpdateListener(MasterUpdateListener masterUpdateListener) {
        this.masterUpdateListeners = EventMulticaster.remove(this.masterUpdateListeners, masterUpdateListener);
    }

    public final void addLoadListener(LoadListener loadListener) {
        this.loadListeners = EventMulticaster.add(this.loadListeners, loadListener);
    }

    public final void removeLoadListener(LoadListener loadListener) {
        this.loadListeners = EventMulticaster.remove(this.loadListeners, loadListener);
    }

    synchronized void openIndex(DataSet dataSet) throws DataSetException {
        dataSet.index = this.data.openIndex(dataSet);
    }

    synchronized void closeIndex(DataSet dataSet) {
        if (dataSet.index != null) {
            dataSet.index.close(dataSet);
        }
    }

    final synchronized boolean lookup(DataSet dataSet, Column[] columnArray, ReadRow readRow, DataRow dataRow, int n) throws DataSetException {
        int n2 = this.find(dataSet, columnArray, readRow, n);
        if (n2 < 0) {
            return false;
        }
        if (dataRow != null) {
            int n3 = dataSet.index.internalRow(n2);
            if (dataRow.columnList.hasScopedColumns() || this.aggManager != null) {
                this.getScopedRowData(dataSet, n3, dataRow);
            } else {
                this.data.getRowData(n3, dataRow.getRowValues(this.columnList));
            }
        }
        return true;
    }

    synchronized boolean locate(DataSet dataSet, Column[] columnArray, ReadRow readRow, int n) throws DataSetException {
        int n2 = this.find(dataSet, columnArray, readRow, n);
        return n2 >= 0 && dataSet._goToRow(n2);
    }

    private final int find(DataSet dataSet, Column[] columnArray, ReadRow readRow, int n) throws DataSetException {
        int n2;
        boolean bl = false;
        dataSet._post();
        int n3 = n & 0x66;
        switch (n3) {
            case 2: {
                if (dataSet.currentRow < dataSet.index.lastRow()) {
                    n2 = dataSet.currentRow + 1;
                    break;
                }
                return -1;
            }
            case 4: {
                if (dataSet.currentRow > 0) {
                    n2 = dataSet.currentRow - 1;
                    break;
                }
                return -1;
            }
            case 64: {
                n2 = dataSet.index.lastRow();
                break;
            }
            case 32: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
                DataSetException.throwNeedLocateStartOption();
            }
        }
        return dataSet.index.locate(n2, columnArray, readRow.getRowValues(this.columnList), n);
    }

    final void getStorageVariant(int n, int n2, Variant variant) throws DataSetException {
        if (this.aggManager != null && this.aggManager.isCalc(n2)) {
            this.aggManager.getVariant(n, n2, variant);
        } else {
            this.data.getVariant(n, n2, variant);
        }
    }

    final Variant getVariantStorage(DataSet dataSet, String string) throws DataSetException {
        int n = this.columnList.getOrdinal(string);
        if (this.aggManager != null && this.aggManager.isCalc(n)) {
            this.aggManager.getVariant(dataSet, n, (Variant)dataSet.readRow.rowValues[n]);
        } else {
            this.data.getVariant(dataSet.internalRow, n, dataSet.readRow.rowValues[n]);
        }
        return dataSet.readRow.rowValues[n];
    }

    final Variant getVariantStorage(DataSet dataSet, int n) throws DataSetException {
        if (this.aggManager != null && this.aggManager.isCalc(n)) {
            this.aggManager.getVariant(dataSet, n, (Variant)dataSet.readRow.rowValues[n]);
        } else {
            this.data.getVariant(dataSet.internalRow, n, dataSet.readRow.rowValues[n]);
        }
        return dataSet.readRow.rowValues[n];
    }

    final synchronized void editRow(DataSet dataSet) throws DataSetException {
        this.data.getRowData(dataSet.index.internalRow(dataSet.currentRow), dataSet.getRowValues());
        dataSet._editRow();
    }

    private final int addReadWriteRow(ReadWriteRow readWriteRow) throws DataSetException {
        int n;
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            block6: {
                try {
                    if (this.editBlocked == 0) {
                        if (this.calcFieldsColumns != null) {
                            this.calcFields(readWriteRow, true);
                        }
                        n = this.data.addRow(readWriteRow.getRowValues(this.columnList), 4);
                        if (this.aggManager != null) {
                            this.aggManager.add(readWriteRow, n);
                        }
                        break block6;
                    }
                    this.editError();
                    int n2 = -1;
                    Object var6_5 = null;
                    return n2;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    throw throwable;
                }
            }
            Object var6_6 = null;
            {
            }
        }
        return n;
    }

    final int storageAddRow(DataSet dataSet) throws DataSetException {
        if (dataSet.hasRequiredColumns) {
            dataSet.requiredColumnsCheck();
        }
        return this.addReadWriteRow(dataSet);
    }

    final int storageAddRow(DataRow dataRow) throws DataSetException {
        if (dataRow.hasRequiredColumns) {
            dataRow.requiredColumnsCheck();
        }
        int n = this.addReadWriteRow(dataRow);
        if (this.dataChangeListeners != null) {
            this.processDataChangeEvent(1, n);
        }
        return n;
    }

    public final synchronized Variant[] startLoading(LoadCancel loadCancel, int n, boolean bl) throws DataSetException {
        if (this.loading) {
            DataSetException.throwAlreadyLoading();
        }
        if (this.editBlocked != 0 && (this.editBlocked & (BlockNotUpdatable | BlockReadOnly | BlockNotOpen)) != this.editBlocked) {
            this.editError();
        }
        if (this.loadBlocked != 0) {
            this.editError();
        }
        this.initData();
        if (this.getNeedsRecalc()) {
            this.recalc();
        }
        this.maxLoadRows = Beans.isDesignTime() ? this.maxDesignRows : this.maxRows;
        this.loadStatus = n;
        this.loading = true;
        this.loadAsync = bl;
        this.loadedRows = 0;
        this.loadRow = new DataRow(this);
        this.loadValues = this.loadRow.getRowValues(this.columnList);
        this.loader = loadCancel;
        return this.loadValues;
    }

    public final void endLoading() throws DataSetException {
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            try {
                if (this.loading) {
                    this.loading = false;
                    this.loadRow = null;
                    this.loadValues = null;
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
        this.displayRowsLoaded();
        if (this.loadListeners != null) {
            this.loadListeners.dispatch(new LoadEvent(this));
        }
    }

    public final void loadRow() throws DataSetException {
        if (!this.loading) {
            DataSetException.throwLoadingNotStarted();
        }
        if (this.maxLoadRows > -1 && this.loadedRows >= this.maxLoadRows) {
            this.processDataChanged();
            this.loader.cancelLoad();
            return;
        }
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            try {
                if (this.calcFieldsColumns != null) {
                    this.calcFields(this.loadRow, true);
                }
                int n = this.data.addRow(this.loadValues, this.loadStatus);
                if (this.aggManager != null) {
                    this.aggManager.add(this.loadRow, n);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        ++this.loadedRows;
        if (this.loadAsync && (this.loadedRows == 25 || this.loadedRows % 500 == 0)) {
            this.displayRowsLoaded();
            try {
                Thread thread = Thread.currentThread();
                int n = thread.getPriority();
                thread.setPriority(2);
                thread.setPriority(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void displayRowsLoaded() throws DataSetException {
        if (this.statusListeners != null) {
            this.loadingEvent.setMessage(String.valueOf(this.loadedRows).concat(String.valueOf(Res.getString(71))));
            if (this.statusListeners != null) {
                this.statusListeners.dispatch(this.loadingEvent);
            }
        }
        this.processDataChanged();
    }

    void cancelDataSetLoading() {
        if (this.loader != null) {
            this.loader.cancelLoad();
        }
    }

    public final synchronized void setMaxRows(int n) {
        this.maxRows = n;
    }

    public final synchronized int getMaxRows() {
        return this.maxRows;
    }

    public final synchronized void setMaxDesignRows(int n) {
        this.maxDesignRows = n;
    }

    public final synchronized int getMaxDesignRows() {
        return this.maxDesignRows;
    }

    final void deleteRow(DataSet dataSet) throws DataSetException {
        int n;
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            block10: {
                try {
                    if (dataSet.isEditingNewRow()) {
                        dataSet._cancel();
                        n = dataSet.index.internalRow(dataSet.currentRow);
                        break block10;
                    }
                    if (this.editBlocked == 0) {
                        if (dataSet.rowCount() < 1) {
                            ValidationException.throwNoRowsToDelete(dataSet);
                        }
                        if (this.aggManager != null) {
                            this.aggManager.delete(dataSet, dataSet.getInternalRow());
                        }
                        if (this.masterUpdateListeners != null) {
                            this.processMasterDeleting();
                        }
                        dataSet._cancel();
                        n = dataSet.index.internalRow(dataSet.currentRow);
                        this.data.deleteRow(n);
                        if (dataSet.currentRow <= this.index.lastRow()) {
                            n = dataSet.index.internalRow(dataSet.currentRow);
                        }
                        break block10;
                    }
                    this.editError();
                    Object var5_4 = null;
                    return;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            Object var5_5 = null;
            {
            }
        }
        if (n > -1 && this.dataChangeListeners != null) {
            this.processDataChangeEvent(2, n);
        }
    }

    public final synchronized void empty() throws DataSetException {
        boolean bl = this.closeStorage(8);
        this._empty();
        if (bl) {
            this.openStorage(null, new AccessEvent(this, 1, 2));
        }
    }

    final synchronized void _empty() throws DataSetException {
        if (this.data != null) {
            this.data = this.produceStore().emptyDataSet(this, this.data);
        }
    }

    final void deleteAllRows(DataSet dataSet) throws DataSetException {
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            try {
                if (this.editBlocked == 0) {
                    dataSet._cancel();
                    dataSet.open();
                    int n = dataSet.rowCount();
                    while (--n >= 0) {
                        if (this.masterUpdateListeners != null) {
                            this.processMasterDeleting();
                        }
                        this.data.deleteRow(dataSet.index.internalRow(n));
                    }
                } else {
                    this.editError();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        this.processDataChanged();
    }

    final boolean isNewRow(int n) {
        return (this.data.getStatus(n) & 4) != 0;
    }

    final void getRowData(int n, Variant[] variantArray) throws DataSetException {
        this.data.getRowData(n, variantArray);
    }

    final int getStatus(DataSet dataSet) throws DataSetException {
        return this.data.getStatus(dataSet.index.internalRow(dataSet.currentRow));
    }

    final void storageResolvePending(boolean bl) throws DataSetException {
        this.data.resolvePending(bl);
    }

    private void setEditBlock(int n, boolean bl) {
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            try {
                this.editBlocked = bl ? (this.editBlocked |= n) : (this.editBlocked &= ~n);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public final void setReadOnly(boolean bl) {
        this.setEditBlock(BlockReadOnly, bl);
    }

    public final boolean isReadOnly() {
        return (this.editBlocked & BlockReadOnly) != 0;
    }

    public final void setEditable(boolean bl) {
        this.editable = bl;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setUpdatable(boolean bl) {
        this.setEditBlock(BlockNotUpdatable, !bl);
    }

    public final boolean isUpdatable() {
        return (this.editBlocked & BlockNotUpdatable) == 0;
    }

    boolean analyzeUpdatable() {
        return this.metaDataUpdate == 1;
    }

    boolean forceNewMetadata() {
        return this.metaDataUpdate == 1;
    }

    public final int getMetaDataUpdate() {
        return this.metaDataUpdate;
    }

    public final void setMetaDataUpdate(int n) throws DataSetException {
        this.failIfOpen();
        this.metaDataUpdate = n;
    }

    final void startEdit(DataSet dataSet, Column column) throws DataSetException {
        if (this.masterUpdateListeners != null) {
            this.masterUpdateEvent.setProperties(3, column);
            try {
                this.masterUpdateListeners.exceptionDispatch(this.masterUpdateEvent);
            }
            catch (Exception exception) {
                ValidationException.throwCannotOrphanDetails(exception);
            }
        }
        if (this.editBlocked != 0) {
            this.editError();
        }
        if (!this.editable) {
            ValidationException.throwReadOnlyDataSet();
        }
        column.startEdit(true);
    }

    final void updateRow(DataSet dataSet, ReadWriteRow readWriteRow, Column[] columnArray) throws DataSetException {
        StorageDataSet storageDataSet = this;
        synchronized (storageDataSet) {
            try {
                if (this.editBlocked != 0) {
                    this.editError();
                }
                if (this.editListener != null) {
                    this.processUpdating(dataSet, readWriteRow);
                }
                if (readWriteRow.hasRequiredColumns) {
                    readWriteRow.requiredColumnsCheck();
                }
                if (this.masterUpdateListeners != null) {
                    this.processMasterChanging(readWriteRow);
                }
                if (this.calcFieldsColumns != null) {
                    this.calcFields(readWriteRow, true);
                }
                int n = dataSet.index.internalRow(dataSet.currentRow);
                if (this.aggManager != null) {
                    this.aggManager.update(this.getInternalReadRow(dataSet), readWriteRow, n);
                }
                this.data.updateRow(n, readWriteRow.getRowValues(this.columnList), columnArray);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    final void getRowData(DataSet dataSet, int n, DataRow dataRow) throws DataSetException {
        if (dataRow.columnList.hasScopedColumns()) {
            this.getScopedRowData(dataSet, dataSet.index.internalRow(n), dataRow);
        } else {
            this.data.getRowData(dataSet.index.internalRow(n), dataRow.getRowValues(this.columnList));
        }
        if (this.aggManager != null) {
            this.aggManager.getRowData(dataSet.index.internalRow(n), (ReadWriteRow)dataRow);
        }
    }

    private final void getScopedRowData(DataSet dataSet, int n, DataRow dataRow) throws DataSetException {
        Column[] columnArray = dataRow.columnList.getScopedColumns();
        Variant[] variantArray = dataRow.getRowValues(this.columnList);
        for (int i = 0; i < columnArray.length; ++i) {
            int n2 = columnArray[i].ordinal;
            this.getStorageVariant(n, n2, variantArray[n2]);
        }
    }

    final synchronized void addStorageDataChangeListener(DataSet dataSet) throws DataSetException {
        this.dataChangeListeners = StorageDataSet.addDataSet(this.dataChangeListeners, dataSet);
    }

    final synchronized void removeStorageDataChangeListener(DataSet dataSet) {
        this.dataChangeListeners = StorageDataSet.removeDataSet(this.dataChangeListeners, dataSet);
    }

    static int findDataSet(DataSet[] dataSetArray, DataSet dataSet) {
        if (dataSetArray != null) {
            for (int i = 0; i < dataSetArray.length; ++i) {
                if (dataSetArray[i] != dataSet) continue;
                return i;
            }
        }
        return -1;
    }

    static final synchronized DataSet[] addDataSet(DataSet[] dataSetArray, DataSet dataSet) {
        if (StorageDataSet.findDataSet(dataSetArray, dataSet) < 0) {
            DataSet[] dataSetArray2;
            if (dataSetArray == null) {
                dataSetArray2 = new DataSet[1];
            } else {
                dataSetArray2 = new DataSet[dataSetArray.length + 1];
                System.arraycopy(dataSetArray, 0, dataSetArray2, 0, dataSetArray.length);
            }
            dataSetArray2[dataSetArray2.length - 1] = dataSet;
            dataSetArray = dataSetArray2;
        }
        return dataSetArray;
    }

    private final void processDataChangeEvent(int n, int n2) throws DataSetException {
        for (int i = 0; i < this.dataChangeListeners.length; ++i) {
            this.dataChangeListeners[i].dataChanged(n, n2);
        }
    }

    static final synchronized DataSet[] removeDataSet(DataSet[] dataSetArray, DataSet dataSet) {
        int n = StorageDataSet.findDataSet(dataSetArray, dataSet);
        if (n > -1) {
            if (dataSetArray.length == 1) {
                dataSetArray = null;
            } else {
                DataSet[] dataSetArray2 = new DataSet[dataSetArray.length - 1];
                System.arraycopy(dataSetArray, 0, dataSetArray2, 0, n);
                if (n < dataSetArray2.length) {
                    System.arraycopy(dataSetArray, n + 1, dataSetArray2, n, dataSetArray2.length - n);
                }
                dataSetArray = dataSetArray2;
            }
        }
        return dataSetArray;
    }

    final synchronized void addStorageAccessListener(AccessListener accessListener) throws DataSetException {
        this.accessListeners = EventMulticaster.add(this.accessListeners, accessListener);
    }

    public final void removeStorageAccessListener(AccessListener accessListener) {
        this.accessListeners = EventMulticaster.remove(this.accessListeners, accessListener);
    }

    public void postAllDataSets() throws DataSetException {
        if (this.dataChangeListeners != null) {
            for (int i = 0; i < this.dataChangeListeners.length; ++i) {
                this.dataChangeListeners[i].postDataSet();
            }
        }
    }

    final synchronized void addStorageStatusListener(StatusListener statusListener) throws DataSetException {
        this.statusListeners = EventMulticaster.add(this.statusListeners, statusListener);
    }

    final void removeStorageStatusListener(StatusListener statusListener) {
        this.statusListeners = EventMulticaster.remove(this.statusListeners, statusListener);
    }

    final void processDataChanged() throws DataSetException {
        if (this.dataChangeListeners != null) {
            this.processDataChangeEvent(5, -1);
        }
    }

    final void processRowChangePosted(int n) throws DataSetException {
        if (this.dataChangeListeners != null) {
            this.processDataChangeEvent(4, n);
        }
    }

    public final synchronized StorageDataSet cloneDataSetStructure() throws DataSetException {
        TableDataSet tableDataSet = new TableDataSet();
        for (int i = 0; i < this.columnCount(); ++i) {
            Column column = this.getColumn(i);
            tableDataSet.addColumn(column.getColumnName(), column.getCaption(), column.getDataType());
        }
        return tableDataSet;
    }

    public final synchronized void getDeletedRows(DataSetView dataSetView) throws DataSetException {
        dataSetView.close();
        dataSetView.setVisibleMask(1, 0);
        dataSetView.setStorageDataSet(this);
        dataSetView.open();
    }

    public final synchronized void getInsertedRows(DataSetView dataSetView) throws DataSetException {
        dataSetView.close();
        dataSetView.setVisibleMask(4, 1);
        dataSetView.setStorageDataSet(this);
        dataSetView.open();
    }

    public final synchronized void getUpdatedRows(DataSetView dataSetView) throws DataSetException {
        dataSetView.close();
        dataSetView.setVisibleMask(2, 1);
        dataSetView.setStorageDataSet(this);
        dataSetView.open();
    }

    public final void getOriginalRow(DataSet dataSet, DataRow dataRow) throws DataSetException {
        this.data.getOriginalRow(dataSet.index.internalRow(dataSet.currentRow), dataRow.getRowValues(this.columnList));
    }

    public void setDataFile(DataFile dataFile) throws DataSetException {
        this.dataFile = dataFile;
        this.dataFileChanged = true;
        if (dataFile != null && dataFile.isLoadOnOpen() && this.close()) {
            this.open();
        }
    }

    public final DataFile getDataFile() {
        return this.dataFile;
    }

    public abstract void loadDetailRows(DataSet var1, DataSet var2) throws DataSetException;

    public void checkMasterDetail(MasterLinkDescriptor masterLinkDescriptor) throws DataSetException {
    }

    public final synchronized void setRowId(String string, boolean bl) throws DataSetException {
        this.columnList.getColumn(string).setRowId(bl);
    }

    public final synchronized boolean hasRowIds() {
        return this.columnList.hasRowIds();
    }

    protected final synchronized void setAllRowIds(boolean bl) {
        this.columnList.setAllRowIds(bl);
    }

    public final Variant[] allocateValues() {
        int n = this.columnList.columnCount();
        Variant[] variantArray = new Variant[n];
        for (int i = 0; i < n; ++i) {
            variantArray[i] = new Variant(this.columnList.columns[i].getDataType());
        }
        return variantArray;
    }

    final synchronized String getBestLocateColumn(int n) {
        return this.columnList.getBestLocateColumn(n);
    }

    public synchronized void setTableName(String string) throws DataSetException {
        if (this.store != null) {
            this.store.renameTableName(this, string);
        }
        this.tableName = string;
    }

    final String getStorageTableName() {
        return this.tableName;
    }

    public synchronized void setStoreName(String string) throws DataSetException {
        if (this.store != null) {
            this.store.renameStoreName(this, string);
        }
        this.storeName = string;
    }

    public final String getStoreName() {
        if (this.storeName == null) {
            return this.tableName;
        }
        return this.storeName;
    }

    public synchronized void setSchemaName(String string) throws DataSetException {
        this.schemaName = string;
    }

    final String getStorageSchemaName() {
        return this.schemaName;
    }

    public synchronized void addCalcFieldsListener(CalcFieldsListener calcFieldsListener) throws DataSetException, TooManyListenersException {
        if (calcFieldsListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.calcFieldsListener != null) {
            throw new TooManyListenersException();
        }
        this.calcFieldsListener = calcFieldsListener;
        this.setNeedsRecalc(true);
    }

    public synchronized void removeCalcFieldsListener(CalcFieldsListener calcFieldsListener) {
        if (this.calcFieldsListener != calcFieldsListener) {
            throw new IllegalArgumentException();
        }
        this.calcFieldsListener = null;
        this.setNeedsRecalc(true);
    }

    public synchronized void addCalcAggFieldsListener(CalcAggFieldsListener calcAggFieldsListener) throws DataSetException, TooManyListenersException {
        if (calcAggFieldsListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.calcAggFieldsListener != null) {
            throw new TooManyListenersException();
        }
        this.calcAggFieldsListener = calcAggFieldsListener;
        this.setNeedsRecalc(true);
    }

    public synchronized void removeCalcAggFieldsListener(CalcAggFieldsListener calcAggFieldsListener) {
        if (this.calcAggFieldsListener != calcAggFieldsListener) {
            throw new IllegalArgumentException();
        }
        this.calcAggFieldsListener = null;
        this.setNeedsRecalc(true);
    }

    private boolean initCalcs() throws DataSetException {
        boolean bl;
        String[] stringArray;
        this.clearCalcFieldsState();
        if ((this.calcFieldsListener != null || this.calcAggFieldsListener != null) && (stringArray = this.columnList.getCalcFieldColumns(this.calcAggFieldsListener != null)) != null) {
            bl = false;
            try {
                this.calcFieldsRow = new DataRow(this, stringArray, false);
                if (this.calcFieldsListener != null) {
                    this.calcFieldsColumns = this.calcFieldsRow.columnList.getScopedColumns();
                    this.calcFieldsValues = this.calcFieldsRow.getRowValues(this.columnList);
                }
                bl = true;
                Object var4_3 = null;
                if (!bl) {
                    this.clearCalcFieldsState();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!bl) {
                    this.clearCalcFieldsState();
                }
                throw throwable;
            }
        }
        bl = false;
        try {
            this.aggManager = AggManager.init(this);
            if (this.aggManager != null) {
                this.aggManager.setLoading(true);
            }
            bl = true;
            Object var6_6 = null;
            if (!bl) {
                this.clearCalcFieldsState();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!bl) {
                this.clearCalcFieldsState();
            }
            throw throwable;
        }
        return this.calcFieldsListener != null || this.aggManager != null;
    }

    public final synchronized void recalc() throws DataSetException {
        if (this.initCalcs()) {
            boolean bl = false;
            try {
                if (this.data.getRowCount() > 1) {
                    this.data.recalc(this, this.aggManager);
                }
                bl = true;
                Object var3_2 = null;
                if (bl) {
                    this.setNeedsRecalc(false);
                } else {
                    this.clearCalcFieldsState();
                }
                if (this.aggManager != null) {
                    this.aggManager.setLoading(false);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (bl) {
                    this.setNeedsRecalc(false);
                } else {
                    this.clearCalcFieldsState();
                }
                if (this.aggManager != null) {
                    this.aggManager.setLoading(false);
                }
                throw throwable;
            }
        }
    }

    final boolean copyStreams() {
        return this.data.copyStreams();
    }

    final StorageDataSet createAggDataSet() {
        return this.produceStore().createAggDataSet(this);
    }

    final InternalRow getInternalReadRow() {
        return this.data.getInternalReadRow(this);
    }

    final InternalRow getInternalReadRow(DataSet dataSet) throws DataSetException {
        InternalRow internalRow = this.data.getInternalReadRow(this);
        internalRow.setInternalRow(dataSet.index.internalRow(dataSet.currentRow));
        return internalRow;
    }

    private void clearCalcFieldsState() {
        this.aggManager = null;
        this.calcFieldsValues = null;
        this.calcFieldsColumns = null;
        this.calcFieldsRow = null;
    }

    void calcUnpostedFields(ReadWriteRow readWriteRow) throws DataSetException {
        if (this.calcFieldsListener != null) {
            this.calcFields(readWriteRow, false);
        }
        if (this.aggManager != null) {
            this.aggManager.getRowData(readWriteRow, readWriteRow);
        }
    }

    public void calcFields(ReadWriteRow readWriteRow, boolean bl) throws DataSetException {
        this.calcFieldsRow._clearValues();
        this.calcFieldsListener.calcFields(readWriteRow, this.calcFieldsRow, bl);
        for (int i = 0; i < this.calcFieldsColumns.length; ++i) {
            int n = this.calcFieldsColumns[i].ordinal;
            readWriteRow.setVariantNoValidate(n, this.calcFieldsValues[n]);
        }
    }

    public MatrixData getMatrixData() {
        return this.data;
    }

    final void processCanceling(DataSet dataSet) throws DataSetException {
        if (this.editListener != null) {
            try {
                this.editListener.canceling(dataSet);
            }
            catch (Exception exception) {
                ValidationException.throwApplicationError(exception);
            }
        }
    }

    final void processUpdating(DataSet dataSet, ReadWriteRow readWriteRow) throws DataSetException, ValidationException {
        if (this.editListener != null) {
            try {
                this.editListener.updating(dataSet, readWriteRow, this.getInternalReadRow(dataSet));
            }
            catch (Exception exception) {
                ValidationException.throwApplicationError(exception);
            }
        }
    }

    final void processUpdated(DataSet dataSet) throws DataSetException {
        if (this.editListener != null) {
            this.editListener.updated(dataSet);
        }
    }

    final void processAdding(DataSet dataSet, ReadWriteRow readWriteRow) throws DataSetException, ValidationException {
        if (this.editListener != null) {
            try {
                this.editListener.adding(dataSet, readWriteRow);
            }
            catch (Exception exception) {
                ValidationException.throwApplicationError(exception);
            }
        }
    }

    final void processAdded(DataSet dataSet) throws DataSetException {
        if (this.editListener != null) {
            this.editListener.added(dataSet);
        }
    }

    final void processDeleting(DataSet dataSet) throws DataSetException, ValidationException {
        if (this.editListener != null) {
            try {
                this.editListener.deleting(dataSet);
            }
            catch (Exception exception) {
                ValidationException.throwApplicationError(exception);
            }
        }
    }

    final void processDeleted(DataSet dataSet) throws DataSetException {
        if (this.editListener != null) {
            this.editListener.deleted(dataSet);
        }
    }

    final void processModifying(DataSet dataSet) throws DataSetException {
        if (this.editListener != null) {
            try {
                this.editListener.modifying(dataSet);
            }
            catch (Exception exception) {
                ValidationException.throwApplicationError(exception);
            }
        }
    }

    final void processInserting(DataSet dataSet) throws DataSetException {
        if (this.editListener != null) {
            try {
                this.editListener.inserting(dataSet);
            }
            catch (Exception exception) {
                ValidationException.throwApplicationError(exception);
            }
        }
    }

    final void processInserted(DataSet dataSet) throws DataSetException {
        if (this.editListener != null) {
            this.editListener.inserted(dataSet);
        }
    }

    final ErrorResponse processEditError(DataSet dataSet, Column column, Variant variant, DataSetException dataSetException) throws DataSetException {
        if (this.editListener != null) {
            this.response.abort();
            this.editListener.editError(dataSet, column, variant, dataSetException, this.response);
            return this.response;
        }
        return null;
    }

    final ErrorResponse processUpdateError(DataSet dataSet, ReadWriteRow readWriteRow, DataSetException dataSetException) throws DataSetException {
        if (this.editListener != null) {
            this.response.abort();
            this.editListener.updateError(dataSet, readWriteRow, dataSetException, this.response);
            return this.response;
        }
        return null;
    }

    final ErrorResponse processAddError(DataSet dataSet, ReadWriteRow readWriteRow, DataSetException dataSetException) throws DataSetException {
        if (this.editListener != null) {
            this.response.abort();
            this.editListener.addError(dataSet, readWriteRow, dataSetException, this.response);
            return this.response;
        }
        return null;
    }

    final ErrorResponse processDeleteError(DataSet dataSet, DataSetException dataSetException) throws DataSetException {
        if (this.editListener != null) {
            this.response.abort();
            this.editListener.deleteError(dataSet, dataSetException, this.response);
            return this.response;
        }
        return null;
    }

    public void addEditListener(EditListener editListener) throws TooManyListenersException {
        if (editListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.editListener != null) {
            throw new TooManyListenersException();
        }
        this.editListener = editListener;
        this.response = new ErrorResponse();
    }

    public synchronized void removeEditListener(EditListener editListener) {
        if (this.editListener != editListener) {
            throw new IllegalArgumentException();
        }
        this.editListener = null;
        this.response = null;
    }

    void processMasterDeleting() throws DataSetException {
        this.masterUpdateEvent.setProperties(1);
        try {
            this.masterUpdateListeners.exceptionDispatch(this.masterUpdateEvent);
        }
        catch (Exception exception) {
            ValidationException.throwCannotOrphanDetails(exception);
        }
    }

    void processMasterChanging(ReadRow readRow) throws DataSetException {
        this.masterUpdateEvent.setProperties(2, readRow);
        try {
            this.masterUpdateListeners.exceptionDispatch(this.masterUpdateEvent);
        }
        catch (Exception exception) {
            ValidationException.throwCannotOrphanDetails(exception);
        }
    }

    public synchronized void startResolution() throws DataSetException {
        if ((this.loadBlocked & BlockResolvePending) != this.loadBlocked) {
            this.editError();
        }
        if ((this.loadBlocked & BlockResolvePending) != 0) {
            this.loadBlocked &= ~BlockResolvePending;
            this.loadBlocked |= BlockResolve;
        } else {
            this.postAllDataSets();
            this.loadBlocked |= BlockResolvePending;
        }
    }

    public synchronized void endResolution() {
        this.loadBlocked &= ~(BlockResolve | BlockResolvePending);
    }

    public boolean saveChangesSupported() {
        return false;
    }

    public boolean refreshSupported() {
        return false;
    }

    public void saveChanges(DataSet dataSet) throws DataSetException {
        DataSetException.throwCannotSaveChanges(this);
    }

    public void refresh() throws DataSetException {
        DataSetException.throwCannotRefresh(this);
    }

    synchronized void detailsFetched(int n) {
        this.data.setStatus(n, this.data.getStatus(n) | 0x20);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    void freeIndex(DataSet dataSet) throws DataSetException {
        this.failIfOpen();
        if (this.data != null) {
            this.data.freeIndex(dataSet);
        }
    }

    public void freeAllIndexes() throws DataSetException {
        boolean bl = this.close();
        if (this.dataSetStore != null) {
            this.data.freeAllIndexes();
        }
        if (bl) {
            this.open();
        }
    }

    public boolean usesStoredProcedure() {
        return false;
    }
}

