/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.NullState;
import borland.jbcl.util.Variant;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;

abstract class DataColumn {
    protected static final byte NULL_BYTE = 127;
    protected static final short NULL_SHORT = Short.MAX_VALUE;
    protected static final int NULL_INT = Integer.MAX_VALUE;
    protected static final float NULL_FLOAT = Float.MAX_VALUE;
    protected static final double NULL_DOUBLE = Double.MAX_VALUE;
    protected static final long NULL_LONG = Long.MAX_VALUE;
    protected static final String NULL_STRING = "\u7fff\u7fff\u7fff";
    protected static final InputStream NULL_STREAM = new ByteArrayInputStream(new byte[1]);
    protected static final BigDecimal nullBigDecimal = new BigDecimal("99999999999999999999");
    static final int InitialSize = 16;
    int lastRow;
    protected int vectorLength;
    boolean immutable;
    protected boolean hasNulls;
    protected NullState nullState;
    protected int assignedMask;
    protected int unassignedMask;
    protected int nullMask;
    int comp;
    protected int[] indexVector;
    protected int pivotDataRow;

    DataColumn(NullState nullState) {
        this.nullState = nullState;
        if (nullState != null) {
            this.assignedMask = 1 << nullState.slot;
            this.unassignedMask = 2 << nullState.slot;
            this.nullMask = this.assignedMask | this.unassignedMask;
        }
        this.lastRow = 1;
    }

    static int getNewSize(int n) {
        if (n < 16) {
            n = 16;
        }
        if (n < 65535) {
            return n * 2;
        }
        return n + 65535;
    }

    final void growTo(int n, int n2) {
        if (this.vectorLength < n) {
            this.grow(n);
            if (this.hasNulls) {
                this.nullState.grow(n);
            }
        }
        if (this.lastRow < n2 && this.nullState != null) {
            Variant variant = new Variant();
            variant.setUnassignedNull();
            for (int i = this.lastRow; i <= n2; ++i) {
                this.append();
                this.setVariant(i, variant);
            }
            this.lastRow = n2;
        }
    }

    final void append() {
        if (++this.lastRow >= this.vectorLength) {
            this.grow(DataColumn.getNewSize(this.vectorLength));
            if (this.hasNulls) {
                this.nullState.grow(this.vectorLength);
            }
        }
    }

    final void setNull(int n, int n2) {
        if (!this.hasNulls) {
            this.nullState.grow(this.vectorLength);
            this.hasNulls = true;
        }
        this.nullState.setNull(n, n2, this.nullMask, this.assignedMask, this.unassignedMask);
    }

    final boolean isNull(int n) {
        if (!this.hasNulls) {
            return false;
        }
        return (this.nullState.vector[n] & this.nullMask) != 0;
    }

    boolean partialCompare(int n, int n2, boolean bl) {
        return false;
    }

    void copyReference(int n, int n2) {
    }

    void setPivot(int[] nArray, int n) {
        this.indexVector = nArray;
        this.pivotDataRow = n;
    }

    int forwardCompare(int n, boolean bl) {
        while ((this.comp = this.compare(this.indexVector[++n], this.pivotDataRow)) < 0) {
        }
        return n;
    }

    int reverseCompare(int n, boolean bl) {
        while ((this.comp = this.compare(this.indexVector[--n], this.pivotDataRow)) > 0) {
        }
        return n;
    }

    protected abstract void grow(int var1);

    abstract void copy(int var1, int var2);

    abstract int compare(int var1, int var2);

    abstract int compareIgnoreCase(int var1, int var2);

    abstract void getVariant(int var1, Variant var2);

    abstract void setVariant(int var1, Variant var2);
}

