/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.Res;
import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.SingletonDataSetManager;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.BasicViewManager;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.util.BlackBox;
import borland.jbcl.view.FieldView;
import borland.jbcl.view.FocusableItemPainter;
import borland.jbcl.view.SelectableTextItemPainter;
import borland.jbcl.view.TextItemEditor;
import java.awt.event.KeyEvent;

public class FieldControl
extends FieldView
implements NavigationListener,
DataChangeListener,
AccessListener,
WritableSingletonModel,
BlackBox {
    private DataSet dataSet;
    private String columnName;
    private boolean initialized = false;

    public FieldControl() {
        this.setDefaultLayout();
    }

    public synchronized String getText() {
        Object object = this.get();
        return object != null ? object.toString() : "";
    }

    public synchronized void setText(String string) {
        if (this.canSet(true)) {
            this.set(string);
        }
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(67));
        }
        super.setModel(singletonModel);
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                this.endEdit(false);
                this.setDefaultLayout();
                break;
            }
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.openDataSet(dataSet);
    }

    private void openDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
            this.dataSet.removeAccessListener(this);
        }
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setDefaultLayout();
        } else if (this.initialized || this.dataSet.isOpen()) {
            if (!this.dataSet.isOpen()) {
                try {
                    this.dataSet.open();
                }
                catch (DataSetException dataSetException) {
                    DataSetException.handleException(this.dataSet, this, dataSetException);
                    this.setDefaultLayout();
                    return;
                }
                this.initialized = true;
            }
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
            this.bindDataSet();
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        this.openDataSet(this.dataSet);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void bindDataSet() {
        Column column;
        this.endEdit(false);
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            SingletonDataSetManager singletonDataSetManager = new SingletonDataSetManager(this.dataSet, column, this, this.getAlignment(), null);
            this.setModel(singletonDataSetManager);
            this.setViewManager(singletonDataSetManager);
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.endEdit(false);
        this.repaint();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        this.endEdit();
        if (this.isEditing()) {
            throw new IllegalStateException();
        }
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        super.processKeyPressed(keyEvent);
        if (keyEvent.isConsumed() || this.dataSet == null || !this.dataSet.isOpen()) {
            return;
        }
        try {
            switch (keyEvent.getKeyCode()) {
                case 155: {
                    this.dataSet.insertRow(false);
                    break;
                }
                case 127: {
                    if (keyEvent.isControlDown()) {
                        this.dataSet.deleteRow();
                    }
                    break;
                }
                case 34: {
                    this.dataSet.next();
                    break;
                }
                case 33: {
                    this.dataSet.prior();
                }
            }
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    private void setDefaultLayout() {
        this.setModel(new BasicSingletonContainer());
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new SelectableTextItemPainter(this.getAlignment())), new TextItemEditor(this.getAlignment())));
    }

    public Object get() {
        return this.getModel().get();
    }

    public boolean canSet(boolean bl) {
        return this.getWriteModel() != null ? this.getWriteModel().canSet(bl) : false;
    }

    public void set(Object object) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(object);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void enableModelEvents(boolean bl) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(bl);
        }
    }
}

