/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import COM.objectspace.jgl.Array;
import borland.jbcl.control.ButtonDescriptor;
import borland.jbcl.control.Res;
import borland.jbcl.util.ActionMulticaster;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class ButtonDialog
extends Dialog
implements ActionListener,
KeyListener {
    public static final String NONE_COMMAND = "none";
    public static final String OK_COMMAND = "ok";
    public static final String YES_COMMAND = "yes";
    public static final String NO_COMMAND = "no";
    public static final String CANCEL_COMMAND = "cancel";
    public static final String DONE_COMMAND = "done";
    public static final String HELP_COMMAND = "help";
    public static final String APPLY_COMMAND = "apply";
    public static final String NEXT_COMMAND = "next";
    public static final String PREVIOUS_COMMAND = "previous";
    public static final String DETAILS_COMMAND = "details";
    public static final int NONE = 0;
    public static final int OK = 1;
    public static final int YES = 2;
    public static final int NO = 4;
    public static final int CANCEL = 8;
    public static final int DONE = 16;
    public static final int HELP = 32;
    public static final int APPLY = 64;
    public static final int NEXT = 128;
    public static final int PREVIOUS = 256;
    public static final int DETAILS = 512;
    public static final int OK_CANCEL = 9;
    public static final int YES_NO = 6;
    public static final int YES_NO_CANCEL = 14;
    public static final int OK_CANCEL_APPLY = 73;
    public static final int APPLY_DONE = 80;
    public static final int ALL = 127;
    protected Panel buttonPanel;
    protected ActionMulticaster actionMulticaster;
    protected int buttonSet;
    protected boolean centered = true;
    protected boolean enterOK = true;
    protected ButtonDescriptor[] buttonDescriptors;
    protected String[] labels;
    protected Panel buttonPanelHolder;
    protected int buttonAlignment = 1;
    protected ButtonDescriptor result;

    protected static final ButtonDescriptor[] buttonSetToButtonDescriptors(int n) {
        Array array = new Array();
        if ((n & 0x100) != 0) {
            array.add(new ButtonDescriptor(PREVIOUS_COMMAND, Res.getString(8), 256, false));
        }
        if ((n & 0x80) != 0) {
            array.add(new ButtonDescriptor(NEXT_COMMAND, Res.getString(7), 128, false));
        }
        if ((n & 0x200) != 0) {
            array.add(new ButtonDescriptor(DETAILS_COMMAND, Res.getString(9), 512, false));
        }
        if ((n & 1) != 0) {
            array.add(new ButtonDescriptor(OK_COMMAND, Res.getString(0), 1, true));
        }
        if ((n & 2) != 0) {
            array.add(new ButtonDescriptor(YES_COMMAND, Res.getString(1), 2, true));
        }
        if ((n & 4) != 0) {
            array.add(new ButtonDescriptor(NO_COMMAND, Res.getString(2), 4, true));
        }
        if ((n & 8) != 0) {
            array.add(new ButtonDescriptor(CANCEL_COMMAND, Res.getString(3), 8, true));
        }
        if ((n & 0x10) != 0) {
            array.add(new ButtonDescriptor(DONE_COMMAND, Res.getString(6), 16, true));
        }
        if ((n & 0x20) != 0) {
            array.add(new ButtonDescriptor(HELP_COMMAND, Res.getString(4), 32, false));
        }
        if ((n & 0x40) != 0) {
            array.add(new ButtonDescriptor(APPLY_COMMAND, Res.getString(5), 64, false));
        }
        Object[] objectArray = new ButtonDescriptor[array.size()];
        array.copyTo(objectArray);
        return objectArray;
    }

    protected ButtonDialog(Frame frame, String string, boolean bl, Component component, Panel panel, ButtonDescriptor[] buttonDescriptorArray) {
        super(frame, string, bl);
        this.buttonPanel = panel;
        if (panel == null) {
            this.buttonPanelHolder = new Panel();
            this.buttonPanelHolder.setLayout(new FlowLayout(1));
            this.buttonPanel = new Panel();
            this.buttonPanel.setLayout(new GridLayout(1, 0, 6, 0));
            this.buttonPanelHolder.add(this.buttonPanel);
        }
        if (component != null) {
            this.setLayout(new BorderLayout());
            ((Component)this).setBackground(SystemColor.control);
            this.add(component, "Center");
            if (this.buttonPanelHolder != null) {
                this.add((Component)this.buttonPanelHolder, "South");
            } else {
                this.add((Component)this.buttonPanel, "South");
            }
        }
        this.buttonSet = -1;
        this.setButtonSet(buttonDescriptorArray);
        this.listenForKeys(this);
        this.enableEvents(64L);
    }

    protected ButtonDialog(Frame frame, String string, Component component, int n) {
        this(frame, string, true, component, null, ButtonDialog.buttonSetToButtonDescriptors(n));
    }

    public ButtonDialog(Frame frame, String string, Component component) {
        this(frame, string, component, 1);
    }

    protected ButtonDialog(Frame frame, String string) {
        this(frame, string, null, 1);
    }

    protected ButtonDialog(Frame frame) {
        this(frame, "", null, 1);
    }

    public void setButtonSet(int n) {
        if ((n & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException(Res.format(30, new String[]{Integer.toString(n & 0xFFFFFF80)}));
        }
        if (n != this.buttonSet) {
            this.buttonSet = n;
            this.setButtonSet(ButtonDialog.buttonSetToButtonDescriptors(n));
        }
    }

    private void setButtonSet(ButtonDescriptor[] buttonDescriptorArray) {
        this.buttonDescriptors = buttonDescriptorArray;
        this.buttonPanel.removeAll();
        for (int i = 0; i < buttonDescriptorArray.length; ++i) {
            Button button;
            buttonDescriptorArray[i].button = button = new Button();
            button.setActionCommand(buttonDescriptorArray[i].command);
            button.addActionListener(this);
            this.buttonPanel.add(button);
        }
        this.setDefaultLabels();
        this.setupButtonLabels();
    }

    public int getButtonSet() {
        return this.buttonSet;
    }

    public void setCentered(boolean bl) {
        this.centered = bl;
    }

    public boolean getCentered() {
        return this.centered;
    }

    public void setEnterOK(boolean bl) {
        this.enterOK = bl;
    }

    public boolean getEnterOK() {
        return this.enterOK;
    }

    public void setButtonAlignment(int n) {
        if (n == this.buttonAlignment || this.buttonPanelHolder == null) {
            return;
        }
        FlowLayout flowLayout = (FlowLayout)this.buttonPanelHolder.getLayout();
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        flowLayout.setAlignment(n);
        this.buttonAlignment = n;
        this.invalidate();
        this.repaint(100L);
    }

    public int getButtonAlignment() {
        return this.buttonAlignment;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.actionMulticaster == null) {
            this.actionMulticaster = new ActionMulticaster();
        }
        this.actionMulticaster.add(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.remove(actionListener);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        block4: {
            this.result = this.buttonFromCommand(actionEvent.getActionCommand());
            if (this.actionMulticaster != null) {
                try {
                    this.actionMulticaster.dispatch(actionEvent);
                }
                catch (Exception exception) {
                    if (this.result == null || !this.result.closeDialog) break block4;
                    return;
                }
            }
        }
        if (this.result != null && this.result.closeDialog || actionEvent.getActionCommand().equals(CANCEL_COMMAND)) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void setLabels(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < this.labels.length && i < stringArray.length; ++i) {
                this.labels[i] = stringArray[i];
            }
        } else {
            this.setDefaultLabels();
        }
        this.setupButtonLabels();
    }

    private void setDefaultLabels() {
        this.labels = new String[this.buttonDescriptors.length];
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = this.buttonDescriptors[i].label;
        }
    }

    protected void setupButtonLabels() {
        if (this.labels.length == this.buttonDescriptors.length) {
            for (int i = 0; i < this.labels.length; ++i) {
                this.buttonDescriptors[i].button.setLabel(this.labels[i]);
            }
        } else {
            for (int i = 0; i < this.buttonPanel.getComponentCount(); ++i) {
                ((Button)this.buttonPanel.getComponent(i)).setLabel(this.labels[i]);
            }
        }
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setResult(int n) {
        this.result = this.buttonFromID(n);
    }

    public int getResult() {
        return this.result != null ? this.result.getID() : 0;
    }

    public ButtonDescriptor buttonFromID(int n) {
        for (int i = 0; i < this.buttonDescriptors.length; ++i) {
            if (this.buttonDescriptors[i].id != n) continue;
            return this.buttonDescriptors[i];
        }
        return null;
    }

    public ButtonDescriptor buttonFromCommand(String string) {
        for (int i = 0; i < this.buttonDescriptors.length; ++i) {
            if (!this.buttonDescriptors[i].command.equals(string)) continue;
            return this.buttonDescriptors[i];
        }
        return null;
    }

    public void enableButton(String string, boolean bl) {
        ButtonDescriptor buttonDescriptor = this.buttonFromCommand(string);
        if (buttonDescriptor != null) {
            buttonDescriptor.button.setEnabled(bl);
        }
    }

    public void show() {
        this.result = null;
        this.pack();
        if (this.centered) {
            this.centerOnScreen();
        } else {
            this.assureOnScreen();
        }
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.processActionEvent(actionEvent);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.processActionEvent(new ActionEvent(this, 1001, CANCEL_COMMAND));
        } else if (windowEvent.getID() == 200 && this.getComponentCount() > 0) {
            this.getComponent(this.getComponentCount() - 1).transferFocus();
        }
    }

    protected void centerOnScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    protected void assureOnScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        if (rectangle.x + rectangle.width > dimension.width || rectangle.y + rectangle.height > dimension.height) {
            if (rectangle.x + rectangle.width > dimension.width) {
                rectangle.x -= rectangle.x + rectangle.width - dimension.width;
            }
            if (rectangle.y + rectangle.height > dimension.height) {
                rectangle.y -= rectangle.y + rectangle.height - dimension.height;
            }
            ((Component)this).setLocation(rectangle.x, rectangle.y);
        }
    }

    protected void listenForKeys(Component component) {
        component.addKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.listenForKeys(container.getComponent(i));
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 && (keyEvent.getModifiers() & 0xB) == 0) {
            this.processActionEvent(new ActionEvent(keyEvent.getSource(), 1001, CANCEL_COMMAND));
        } else if (keyEvent.getKeyCode() == 10 && (keyEvent.getModifiers() & 9) == 0) {
            boolean bl;
            boolean bl2 = (keyEvent.getModifiers() & 2) != 0;
            boolean bl3 = bl = !this.enterOK || keyEvent.getSource() instanceof TextArea;
            if (bl2 == bl) {
                this.processActionEvent(new ActionEvent(keyEvent.getSource(), 1001, OK_COMMAND));
            }
        } else if (keyEvent.getKeyCode() == 112 && (keyEvent.getModifiers() & 0xB) == 0) {
            this.processActionEvent(new ActionEvent(keyEvent.getSource(), 1001, HELP_COMMAND));
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

