/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import proxy.ProxyConnector;
import proxy.ProxyConnectorException;
import proxy.SSLProxyProps;
import uiutil.ChangeListener;
import uiutil.ErrorMgr;
import uiutil.PropertySheet;
import util.JUtil;
import util.KeyBindings;
import util.Log;

public class SSLProxyConnector
implements ProxyConnector {
    public static String MODULE = "SSLProxy";
    public static String HOSTNAME_KEY = "hostname";
    public static String PORT_KEY = "port";
    public static String USEAUTH_KEY = "useAuth";
    String Phost;
    int Pport;
    boolean useAuth;
    String userpass64;

    public Socket makeConnection(String string, int n) throws IOException, ProxyConnectorException {
        int n2;
        String string2;
        DataOutputStream dataOutputStream;
        BufferedReader bufferedReader;
        Socket socket;
        block9: {
            socket = new Socket(this.Phost, this.Pport);
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            dataOutputStream = new DataOutputStream(socket.getOutputStream());
            String string3 = "CONNECT " + string + ":" + n + " HTTP/1.0";
            dataOutputStream.writeBytes(String.valueOf(string3) + "\r\n");
            if (this.useAuth) {
                dataOutputStream.writeBytes("Proxy-Authorization: basic " + this.userpass64);
                dataOutputStream.writeBytes("\r\n");
            }
            dataOutputStream.writeBytes("\r\n");
            string2 = bufferedReader.readLine();
            Log.log((String)MODULE, (int)Log.INFO, (String)("#0 :" + string2));
            try {
                n2 = string2.indexOf(32);
                while (string2.charAt(n2) == ' ') {
                    ++n2;
                }
                int n3 = Integer.parseInt(string2.substring(n2, n2 + 3));
                string2.substring(n2 + 4).trim();
                if (n3 == 407) {
                    String string4 = this.useAuth ? "Specified username and/or password for SSLProxy\nis incorrect." : "Need to specify username and password for SSLProxy.";
                    ErrorMgr.warn((String)MODULE, (String)string4);
                    return null;
                }
                if (n3 == 200) break block9;
                try {
                    while ((string2 = bufferedReader.readLine()) != null) {
                        Log.log((String)MODULE, (int)Log.INFO, (String)string2);
                    }
                }
                catch (Exception exception) {}
                return null;
            }
            catch (Exception exception) {}
        }
        n2 = 1;
        while (true) {
            string2 = bufferedReader.readLine();
            Log.log((String)MODULE, (int)Log.INFO, (String)("#" + n2 + " :" + string2));
            if (string2.length() < 3) break;
            ++n2;
        }
        dataOutputStream.flush();
        return socket;
    }

    public String getProxyName() {
        return "SSLProxy";
    }

    public void configure(KeyBindings keyBindings) {
        this.Phost = keyBindings.getValueDefault(HOSTNAME_KEY, "localhost");
        String string = keyBindings.getValueDefault(PORT_KEY, "3128");
        try {
            this.Pport = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.Pport = 3128;
        }
        this.useAuth = JUtil.isTrue((String)keyBindings.getValueDefault(USEAUTH_KEY, "false"));
        if (this.useAuth) {
            String string2 = keyBindings.getValueDefault("username", "guest");
            String string3 = JUtil.getPassword((KeyBindings)keyBindings, (String)"password");
            this.userpass64 = JUtil.toBase64((String)(String.valueOf(string2) + ':' + string3));
        }
        Log.log((String)MODULE, (int)Log.INFO, (String)("SSL Proxy Host = " + this.Phost));
        Log.log((String)MODULE, (int)Log.INFO, (String)("SSL Proxy Port = " + this.Pport));
    }

    public void unconfigure(KeyBindings keyBindings) {
    }

    public boolean hasPropertySheet() {
        return true;
    }

    public PropertySheet getPropertySheet(KeyBindings keyBindings, ChangeListener changeListener) {
        return new SSLProxyProps(keyBindings, changeListener);
    }
}

