/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.responder;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import main.Oscar;
import module.aolim.responder.ResponderBean;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.KeyBindings;

class ResponderProps
extends PropertySheet
implements KeyListener,
ActionListener,
ItemListener {
    private ChangeListener changeListener;
    private List messagesList;
    private TextField messageField;
    private Button addMessage;
    private Button removeMessage;
    private boolean changed;
    private KeyBindings config;
    private ResponderBean responder;
    private static String RESPONDER_KEY = "im.responder";

    public ResponderProps(ResponderBean responderBean, ChangeListener changeListener) {
        this.responder = responderBean;
        this.changeListener = changeListener;
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        ((Container)((Object)this)).setLayout(new BorderLayout(5, 5));
        ((Container)((Object)this)).add("East", (Component)new Spacer());
        ((Container)((Object)this)).add("West", (Component)new Spacer());
        ((Container)((Object)this)).add("North", new Label("Away Messages:"));
        this.messagesList = new List();
        ((Container)((Object)this)).add("Center", this.messagesList);
        this.messagesList.addActionListener(this);
        this.messagesList.addItemListener(this);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        ((Container)((Object)this)).add("South", (Component)transparentPanel);
        this.messageField = new TextField();
        transparentPanel.add("North", this.messageField);
        transparentPanel.add("East", (Component)new Spacer());
        transparentPanel.add("West", (Component)new Spacer());
        this.messageField.addKeyListener(this);
        this.messageField.addActionListener(this);
        TransparentPanel transparentPanel2 = new TransparentPanel((LayoutManager)new FlowLayout());
        transparentPanel.add("South", (Component)transparentPanel2);
        this.addMessage = new Button("Add Message");
        transparentPanel2.add(this.addMessage);
        this.addMessage.addActionListener(this);
        this.addMessage.setEnabled(false);
        this.removeMessage = new Button("Remove Message");
        transparentPanel2.add(this.removeMessage);
        this.removeMessage.addActionListener(this);
        this.removeMessage.setEnabled(false);
        this.config = Oscar.config.getKeyBindingsOrAdd(RESPONDER_KEY);
        this.setValues();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        int n = this.messagesList.getSelectedIndex();
        if (n != -1) {
            this.messagesList.deselect(n);
        }
        this.addMessage.setEnabled(this.messageField.getText().length() > 0);
        this.removeMessage.setEnabled(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addMessage || object == this.messageField) {
            this.messagesList.addItem(this.messageField.getText());
            this.setChanged(true);
            ((TextComponent)this.messageField).setText("");
            this.addMessage.setEnabled(false);
            return;
        }
        if (object == this.removeMessage) {
            int n = this.messagesList.getSelectedIndex();
            if (n != -1) {
                this.messagesList.remove(n);
                this.setChanged(true);
                return;
            }
        } else {
            ((TextComponent)this.messageField).setText(actionEvent.getActionCommand());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.removeMessage.setEnabled(itemEvent.getStateChange() == 1);
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI((String)"Aol Biff Password Help", (String)"This folder is where you save your login and password for checking your mail on AOL.  When changes are made the 'Check Now!' button is disabled until you save the changes.");
        return true;
    }

    public boolean save() {
        KeyBindings keyBindings = this.config.getKeyBindingsOrAdd("messages");
        keyBindings.setKeySeparator('\u0001');
        while (keyBindings.size() > 0) {
            keyBindings.deleteKey(keyBindings.getKeyAt(0));
        }
        int n = 0;
        while (n < this.messagesList.getItemCount()) {
            String string = this.messagesList.getItem(n);
            keyBindings.setValue(string, "");
            ++n;
        }
        keyBindings.setKeySeparator('.');
        this.responder.createMenu();
        this.setChanged(false);
        return true;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setValues() {
        KeyBindings keyBindings = this.config.getKeyBindingsOrAdd("messages");
        int n = keyBindings.size();
        int n2 = 0;
        while (n2 < n) {
            this.messagesList.addItem(keyBindings.getKeyAt(n2));
            ++n2;
        }
        this.setChanged(false);
    }
}

