/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import uiutil.ErrorMgr;
import util.Log;
import util.TimerEvent;
import util.TimerListener;

public class Timer
extends Thread {
    private static String MODULE = "Timer";
    private static Hashtable timers = null;
    private static int defaultResolution = 100;
    private static String debugName = "";
    private Vector events;
    private boolean running = true;
    private int sleepTime;
    private String name;

    public Timer(String string, int n) {
        super(String.valueOf(string) + " Timer");
        this.name = string;
        this.events = new Vector();
        this.setResolution(n);
        this.start();
        if (timers == null) {
            timers = new Hashtable();
        }
        timers.put(string, this);
    }

    public static synchronized TimerEvent createEvent(String string, TimerListener timerListener, int n, Object object, int n2) {
        Timer timer = null;
        if (timers != null) {
            timer = Timer.getTimer(string);
        }
        if (timer == null) {
            timer = new Timer(string, defaultResolution);
        }
        return timer.createEvent(timerListener, n, object, n2);
    }

    public static synchronized void shutdown() {
        Log.log(MODULE, Log.INFO, "Timer got shutdown.");
        Enumeration enumeration = timers.elements();
        try {
            while (enumeration.hasMoreElements()) {
                Timer timer = (Timer)enumeration.nextElement();
                timer.stopTimer();
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static synchronized Timer getTimer(String string) {
        if (timers == null) {
            return null;
        }
        return (Timer)timers.get(string);
    }

    public void setResolution(int n) {
        if (n > 50) {
            this.sleepTime = n;
        }
    }

    public long getResolution(int n) {
        return this.sleepTime;
    }

    public synchronized TimerEvent createEvent(TimerListener timerListener, int n, Object object, int n2) {
        if (this.name.equals(debugName)) {
            Log.log(MODULE, Log.DB0, "createEvent " + this.toString() + " " + timerListener + " " + n + " " + object + " " + n2);
        }
        TimerEvent timerEvent = new TimerEvent(timerListener, n, object, System.currentTimeMillis() + (long)n2);
        if (this.name.equals(debugName)) {
            Log.log(MODULE, Log.DB0, "\tadding " + timerEvent);
        }
        this.scheduleEvent(timerEvent);
        if (this.name.equals(debugName)) {
            Log.log(MODULE, Log.DB0, "added event to " + this.toStringDetail());
        }
        return timerEvent;
    }

    public synchronized String toStringDetail() {
        String string = this.toString();
        int n = 0;
        while (n < this.events.size()) {
            TimerEvent timerEvent = this.getEvent(n);
            string = String.valueOf(string) + "\n\t" + timerEvent.toString();
            ++n;
        }
        return string;
    }

    public String toString() {
        int n = 0;
        if (this.events != null) {
            n = this.events.size();
        }
        return String.valueOf(this.name) + " pending #:" + n + " active?:" + this.running + " sleepTime:" + this.sleepTime;
    }

    public synchronized boolean rescheduleEvent(TimerEvent timerEvent, int n) {
        if (this.removeEventFromTimer(timerEvent)) {
            timerEvent.activationTime = System.currentTimeMillis() + (long)n;
            this.scheduleEvent(timerEvent);
            return true;
        }
        return false;
    }

    public synchronized boolean removeEventFromTimer(TimerEvent timerEvent) {
        int n = this.events.size() - 1;
        while (n >= 0) {
            TimerEvent timerEvent2 = (TimerEvent)this.events.elementAt(n);
            if (timerEvent2 == timerEvent) {
                this.events.removeElementAt(n);
                return true;
            }
            --n;
        }
        return false;
    }

    public static synchronized boolean removeEvent(TimerEvent timerEvent) {
        if (timers == null) {
            return false;
        }
        Enumeration enumeration = timers.elements();
        try {
            while (enumeration.hasMoreElements()) {
                Timer timer = (Timer)enumeration.nextElement();
                if (!timer.removeEventFromTimer(timerEvent)) continue;
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
        return false;
    }

    private synchronized TimerEvent getRunnableEvent(long l) {
        if (this.name.equals(debugName)) {
            Log.log(MODULE, Log.DB0, "in getRunnableEvent, " + this.toString() + " " + l);
        }
        TimerEvent timerEvent = null;
        if (this.events != null && this.events.size() > 0) {
            timerEvent = this.getEvent(0);
            if (timerEvent.activationTime < l) {
                this.events.removeElementAt(0);
            } else {
                timerEvent = null;
            }
        }
        if (this.name.equals(debugName)) {
            if (timerEvent == null) {
                Log.log(MODULE, Log.DB0, "\tno events ready to fire");
            } else {
                Log.log(MODULE, Log.DB0, "\tfiring " + timerEvent);
            }
        }
        return timerEvent;
    }

    public synchronized void stopTimer() {
        if (this.name.equals(debugName)) {
            Log.log(MODULE, Log.DB0, "stoping " + this.toStringDetail() + " " + Thread.currentThread().toString());
        }
        this.running = false;
        this.events = null;
        timers.remove(this);
        super.stop();
    }

    public void run() {
        while (this.running) {
            try {
                long l = System.currentTimeMillis();
                while (this.running) {
                    TimerEvent timerEvent = this.getRunnableEvent(l);
                    if (timerEvent == null) break;
                    if (!timerEvent.active) continue;
                    timerEvent.listener.timerEvent(this.name, timerEvent.eventID, timerEvent.callback);
                }
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                ErrorMgr.error("Timer", "Exception in run thread " + interruptedException.getMessage());
            }
        }
    }

    private TimerEvent getEvent(int n) {
        return (TimerEvent)this.events.elementAt(n);
    }

    private void scheduleEvent(TimerEvent timerEvent) {
        if (this.events.size() == 0) {
            this.events.addElement(timerEvent);
            return;
        }
        if (this.events.size() == 1) {
            if (this.getEvent((int)0).activationTime < timerEvent.activationTime) {
                this.events.addElement(timerEvent);
                return;
            }
            this.events.insertElementAt(timerEvent, 0);
            return;
        }
        if (this.getEvent((int)(this.events.size() - 1)).activationTime <= timerEvent.activationTime) {
            this.events.addElement(timerEvent);
            return;
        }
        int n = 0;
        while (n < this.events.size()) {
            if (this.getEvent((int)n).activationTime > timerEvent.activationTime) {
                this.events.insertElementAt(timerEvent, n);
                return;
            }
            ++n;
        }
    }
}

