/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import util.EventBusEvent;
import util.EventBusProducer;
import util.Log;

public class EventBus
extends Thread {
    private static final String MODULE = "EventBus";
    String name;
    Hashtable eventListeners;
    Hashtable eventProducers;
    Vector events;
    int cnt;
    Vector removeVector;
    static Hashtable eventBuses = new Hashtable();
    public static String SYSTEM_BUS = "System";
    static /* synthetic */ Class class$util$EventBusEvent;
    static /* synthetic */ Class class$java$awt$AWTEvent;

    EventBus(String string) {
        super("EventBus: " + string + " Thread");
        this.name = string;
        this.eventListeners = new Hashtable();
        this.eventProducers = new Hashtable();
        this.events = new Vector();
        this.cnt = 1;
        this.removeVector = new Vector();
        this.start();
    }

    public void addListenerFor(EventListener eventListener, Class clazz) {
        if (!(class$util$EventBusEvent != null ? class$util$EventBusEvent : (class$util$EventBusEvent = EventBus.class$("util.EventBusEvent"))).isAssignableFrom(clazz)) {
            Log.log(MODULE, Log.ERROR, "Event bus can only only listen for events that implement EventBusEvent");
            return;
        }
        Vector<EventListener> vector = (Vector<EventListener>)this.eventListeners.get(clazz);
        if (vector == null) {
            vector = new Vector<EventListener>();
            this.eventListeners.put(clazz, vector);
        }
        vector.addElement(eventListener);
        Vector vector2 = (Vector)this.eventProducers.get(clazz);
        if (vector2 != null) {
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                EventBusProducer eventBusProducer = (EventBusProducer)vector2.elementAt(n2);
                eventBusProducer.eventListenerAdded(this.name, clazz, eventListener);
                ++n2;
            }
        }
    }

    public void removeListenerFor(EventListener eventListener, Class clazz) {
        Vector vector = this.removeVector;
        synchronized (vector) {
            this.removeVector.addElement(eventListener);
            this.removeVector.addElement(clazz);
            return;
        }
    }

    public void addProducerFor(EventBusProducer eventBusProducer, Class clazz) {
        Vector<EventBusProducer> vector = (Vector<EventBusProducer>)this.eventProducers.get(clazz);
        if (vector == null) {
            vector = new Vector<EventBusProducer>();
            this.eventProducers.put(clazz, vector);
        }
        vector.addElement(eventBusProducer);
    }

    public void removeProducerFor(EventBusProducer eventBusProducer, Class clazz) {
        Vector vector = (Vector)this.eventProducers.get(clazz);
        if (vector != null) {
            vector.removeElement(eventBusProducer);
        }
    }

    public synchronized void postEvent(EventBusEvent eventBusEvent) {
        this.events.addElement(eventBusEvent);
        this.notifyAll();
    }

    synchronized EventBusEvent getNextEvent() throws InterruptedException {
        while (this.events.size() == 0) {
            this.wait();
        }
        EventBusEvent eventBusEvent = (EventBusEvent)this.events.elementAt(0);
        this.events.removeElementAt(0);
        return eventBusEvent;
    }

    void dispatchEvent(EventBusEvent eventBusEvent) {
        Class<?> clazz = eventBusEvent.getClass();
        Vector vector = (Vector)this.eventListeners.get(clazz);
        if (vector == null) {
            Log.log(MODULE, Log.DB3, "No listeners for event class " + clazz);
            return;
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            EventListener eventListener = (EventListener)vector.elementAt(n2);
            eventBusEvent.deliverEvent(eventListener);
            ++n2;
        }
    }

    void removeListener(Class clazz, EventListener eventListener) {
        Vector vector = (Vector)this.eventListeners.get(clazz);
        if (vector == null) {
            return;
        }
        if (!vector.removeElement(eventListener)) {
            return;
        }
        Vector vector2 = (Vector)this.eventProducers.get(clazz);
        if (vector2 != null) {
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                EventBusProducer eventBusProducer = (EventBusProducer)vector2.elementAt(n2);
                eventBusProducer.eventListenerAdded(this.name, clazz, eventListener);
                ++n2;
            }
        }
    }

    public void run() {
        try {
            while (this.cnt > 0) {
                EventBusEvent eventBusEvent = this.getNextEvent();
                Vector vector = this.removeVector;
                synchronized (vector) {
                    while (this.removeVector.size() > 0) {
                        EventListener eventListener = (EventListener)this.removeVector.elementAt(0);
                        Class clazz = (Class)this.removeVector.elementAt(1);
                        this.removeVector.removeElementAt(0);
                        this.removeVector.removeElementAt(0);
                        this.removeListener(clazz, eventListener);
                    }
                }
                this.dispatchEvent(eventBusEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Log.log(MODULE, Log.DB1, String.valueOf(this.name) + " terminating.");
    }

    public void leaveBus(EventListener eventListener) {
        Hashtable hashtable = this.eventListeners;
        synchronized (hashtable) {
            --this.cnt;
            Enumeration enumeration = this.eventListeners.keys();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                this.removeListener(clazz, eventListener);
            }
            if (this.cnt == 0) {
                eventBuses.remove(this.name);
            }
            return;
        }
    }

    public static synchronized EventBus joinBus(String string) {
        EventBus eventBus = (EventBus)eventBuses.get(string);
        if (eventBus == null) {
            eventBus = new EventBus(string);
            eventBuses.put(string, eventBus);
        } else {
            Hashtable hashtable = eventBus.eventListeners;
            synchronized (hashtable) {
                ++eventBus.cnt;
            }
        }
        return eventBus;
    }

    public static void main(String[] stringArray) {
        EventBus eventBus = EventBus.joinBus("System");
        eventBus.addListenerFor(null, class$java$awt$AWTEvent != null ? class$java$awt$AWTEvent : (class$java$awt$AWTEvent = EventBus.class$("java.awt.AWTEvent")));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

