/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Stack;
import java.util.Vector;
import uiutil.OFrameEventWatcher;

public class OFrame
extends Frame
implements FocusListener,
WindowListener {
    public static Stack frameStack = new Stack();
    public static OFrame defaultFrame = new OFrame();
    public static long lastEventTime = System.currentTimeMillis();
    static OFrameEventWatcher watcher = new OFrameEventWatcher();
    private Vector focusComponents = new Vector();
    private int focusIndex;
    protected boolean discardingKeyEvents = false;

    public OFrame() {
        this.addListeners();
    }

    public OFrame(String string) {
        super(string);
        this.addListeners();
    }

    private final void addListeners() {
        this.addWindowListener(this);
        this.addKeyListener(watcher);
        this.addMouseListener(watcher);
        this.addMouseMotionListener(watcher);
        this.addContainerListener(watcher);
    }

    public String[] getAvailableFonts() {
        Toolkit toolkit = this.getToolkit();
        return toolkit.getFontList();
    }

    public ColorModel printColorModel() {
        Toolkit toolkit = this.getToolkit();
        ColorModel colorModel = toolkit.getColorModel();
        System.out.println("Color Model is " + colorModel.getClass().getName());
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n = indexColorModel.getMapSize();
            byte[] byArray = new byte[n];
            indexColorModel.getReds(byArray);
            byte[] byArray2 = new byte[n];
            indexColorModel.getGreens(byArray2);
            byte[] byArray3 = new byte[n];
            indexColorModel.getBlues(byArray3);
            int n2 = 0;
            while (n2 < n) {
                System.out.println(String.valueOf(n2) + " <" + Integer.toHexString(byArray[n2] & 0xFF) + ", " + Integer.toHexString(byArray2[n2] & 0xFF) + " " + Integer.toHexString(byArray3[n2] & 0xFF) + ">");
                ++n2;
            }
        }
        return colorModel;
    }

    public void toFront() {
        super.toFront();
        super.requestFocus();
    }

    public void toBack() {
        super.toBack();
    }

    public void dispose() {
        Stack stack = frameStack;
        synchronized (stack) {
            while (frameStack.removeElement(this)) {
            }
        }
        ((Component)this).setVisible(false);
        super.dispose();
    }

    public void focusGained(FocusEvent focusEvent) {
        Stack stack = frameStack;
        synchronized (stack) {
            frameStack.push(this);
            return;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Stack stack = frameStack;
        synchronized (stack) {
            frameStack.removeElement(this);
            return;
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public static OFrame getTopOFrame() {
        OFrame oFrame = null;
        Stack stack = frameStack;
        synchronized (stack) {
            if (frameStack != null && frameStack.size() > 0) {
                oFrame = (OFrame)frameStack.peek();
            }
        }
        if (oFrame == null) {
            oFrame = defaultFrame;
        }
        return oFrame;
    }

    public void addFocusComponent(Component component) {
        this.focusComponents.addElement(component);
    }

    public void deleteFocusComponent(Component component) {
        this.focusComponents.removeElement(component);
    }

    public void startEventDiscarding() {
        this.discardingKeyEvents = true;
    }

    public void stopEventDiscarding() {
        this.discardingKeyEvents = false;
    }

    public void incrementFocusIndex() {
        ++this.focusIndex;
        if (this.focusIndex == this.focusComponents.size()) {
            this.focusIndex = 0;
        }
    }

    public void setFocus(Component component) {
        int n = this.focusComponents.size();
        if (component == null) {
            return;
        }
        component.requestFocus();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = (Component)this.focusComponents.elementAt(n2);
            if (component2.equals(component)) {
                this.focusIndex = n2;
                return;
            }
            ++n2;
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }
}

