/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import component.OscarLabelButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import main.Oscar;
import uiutil.ColorButton;
import uiutil.ColorButtonListener;
import uiutil.ColorDesc;
import uiutil.ColorSampler;
import uiutil.ColorSelectorListener;
import uiutil.ImagePanel;
import uiutil.TransparentPanel;
import uiutil.UIPack;

public class ColorSelector
extends Dialog
implements UIPack,
ColorButtonListener,
WindowListener,
ActionListener,
KeyListener {
    private static ColorDesc[] colorArray = new ColorDesc[]{new ColorDesc("aliceblue", 240, 248, 255), new ColorDesc("antiquewhite", 250, 235, 215), new ColorDesc("aqua", 0, 255, 255), new ColorDesc("aquamarine", 127, 255, 212), new ColorDesc("azure", 240, 255, 255), new ColorDesc("beige", 245, 245, 220), new ColorDesc("bisque", 255, 228, 196), new ColorDesc("black", 0, 0, 0), new ColorDesc("blanchedalmond", 255, 235, 205), new ColorDesc("blue", 0, 0, 255), new ColorDesc("blueviolet", 138, 43, 226), new ColorDesc("brown", 165, 42, 42), new ColorDesc("burlywood", 222, 184, 135), new ColorDesc("cadetblue", 95, 158, 160), new ColorDesc("chartreuse", 127, 255, 0), new ColorDesc("chocolate", 210, 105, 30), new ColorDesc("coral", 255, 127, 80), new ColorDesc("cornflowerblue", 100, 149, 237), new ColorDesc("cornsilk", 255, 248, 220), new ColorDesc("crimson", 220, 20, 60), new ColorDesc("cyan", 0, 255, 255), new ColorDesc("darkblue", 0, 0, 139), new ColorDesc("darkcyan", 0, 139, 139), new ColorDesc("darkgoldenrod", 184, 134, 11), new ColorDesc("darkgray", 169, 169, 169), new ColorDesc("darkgreen", 0, 100, 0), new ColorDesc("darkkhaki", 189, 183, 107), new ColorDesc("darkmagenta", 139, 0, 139), new ColorDesc("darkolivegreen", 85, 107, 47), new ColorDesc("darkorange", 255, 140, 0), new ColorDesc("darkorchid", 153, 50, 204), new ColorDesc("darkred", 139, 0, 0), new ColorDesc("darksalmon", 233, 150, 122), new ColorDesc("darkseagreen", 143, 188, 143), new ColorDesc("darkslateblue", 72, 61, 139), new ColorDesc("darkslategray", 47, 79, 79), new ColorDesc("darkturquoise", 0, 206, 209), new ColorDesc("darkviolet", 148, 0, 211), new ColorDesc("deeppink", 255, 20, 147), new ColorDesc("deepskyblue", 0, 191, 255), new ColorDesc("dimgray", 105, 105, 105), new ColorDesc("dodgerblue", 30, 144, 255), new ColorDesc("firebrick", 178, 34, 34), new ColorDesc("floralwhite", 255, 250, 240), new ColorDesc("forestgreen", 34, 139, 34), new ColorDesc("fuchsia", 255, 0, 255), new ColorDesc("gainsboro", 220, 220, 220), new ColorDesc("ghostwhite", 248, 248, 255), new ColorDesc("gold", 255, 215, 0), new ColorDesc("goldenrod", 218, 165, 32), new ColorDesc("gray", 128, 128, 128), new ColorDesc("green", 0, 128, 0), new ColorDesc("greenyellow", 173, 255, 47), new ColorDesc("honeydew", 240, 255, 240), new ColorDesc("hotpink", 255, 105, 180), new ColorDesc("indianred", 205, 92, 92), new ColorDesc("indigo", 75, 0, 130), new ColorDesc("ivory", 255, 255, 240), new ColorDesc("khaki", 240, 230, 140), new ColorDesc("lavender", 230, 230, 250), new ColorDesc("lavenderblush", 255, 240, 245), new ColorDesc("lawngreen", 124, 252, 0), new ColorDesc("lemonchiffon", 255, 250, 205), new ColorDesc("lightblue", 173, 216, 230), new ColorDesc("lightcoral", 240, 128, 128), new ColorDesc("lightcyan", 224, 255, 255), new ColorDesc("lightgoldenrodyellow", 250, 250, 210), new ColorDesc("lightgreen", 144, 238, 144), new ColorDesc("lightgrey", 211, 211, 211), new ColorDesc("lightpink", 255, 182, 193), new ColorDesc("lightsalmon", 255, 160, 122), new ColorDesc("lightseagreen", 32, 178, 170), new ColorDesc("lightskyblue", 135, 206, 250), new ColorDesc("lightslategray", 119, 136, 153), new ColorDesc("lightsteelblue", 176, 196, 222), new ColorDesc("lightyellow", 255, 255, 224), new ColorDesc("lime", 0, 255, 0), new ColorDesc("limegreen", 50, 205, 50), new ColorDesc("linen", 250, 240, 230), new ColorDesc("magenta", 255, 0, 255), new ColorDesc("maroon", 128, 0, 0), new ColorDesc("mediumaquamarine", 102, 205, 170), new ColorDesc("mediumblue", 0, 0, 205), new ColorDesc("mediumorchid", 186, 85, 211), new ColorDesc("mediumpurple", 147, 112, 219), new ColorDesc("mediumseagreen", 60, 179, 113), new ColorDesc("mediumslateblue", 123, 104, 238), new ColorDesc("mediumspringgreen", 0, 250, 154), new ColorDesc("mediumturquoise", 72, 209, 204), new ColorDesc("mediumvioletred", 199, 21, 133), new ColorDesc("midnightblue", 25, 25, 112), new ColorDesc("mintcream", 245, 255, 250), new ColorDesc("mistyrose", 255, 228, 225), new ColorDesc("moccasin", 255, 228, 181), new ColorDesc("navajowhite", 255, 222, 173), new ColorDesc("navy", 0, 0, 128), new ColorDesc("oldlace", 253, 245, 230), new ColorDesc("olive", 128, 128, 0), new ColorDesc("olivedrab", 107, 142, 35), new ColorDesc("orange", 255, 165, 0), new ColorDesc("orangered", 255, 69, 0), new ColorDesc("orchid", 218, 112, 214), new ColorDesc("palegoldenrod", 238, 232, 170), new ColorDesc("palegreen", 152, 251, 152), new ColorDesc("paleturquoise", 175, 238, 238), new ColorDesc("palevioletred", 219, 112, 147), new ColorDesc("papayawhip", 255, 239, 213), new ColorDesc("peachpuff", 255, 218, 185), new ColorDesc("peru", 205, 133, 63), new ColorDesc("pink", 255, 192, 203), new ColorDesc("plum", 221, 160, 221), new ColorDesc("powderblue", 176, 224, 230), new ColorDesc("purple", 128, 0, 128), new ColorDesc("red", 255, 0, 0), new ColorDesc("rosybrown", 188, 143, 143), new ColorDesc("royalblue", 65, 105, 225), new ColorDesc("saddlebrown", 139, 69, 19), new ColorDesc("salmon", 250, 128, 114), new ColorDesc("sandybrown", 244, 164, 96), new ColorDesc("seagreen", 46, 139, 87), new ColorDesc("seashell", 255, 245, 238), new ColorDesc("sienna", 160, 82, 45), new ColorDesc("silver", 192, 192, 192), new ColorDesc("skyblue", 135, 206, 235), new ColorDesc("slateblue", 106, 90, 205), new ColorDesc("slategray", 112, 128, 144), new ColorDesc("snow", 255, 250, 250), new ColorDesc("springgreen", 0, 255, 127), new ColorDesc("steelblue", 70, 130, 180), new ColorDesc("tan", 210, 180, 140), new ColorDesc("teal", 0, 128, 128), new ColorDesc("thistle", 216, 191, 216), new ColorDesc("tomato", 255, 99, 71), new ColorDesc("turquoise", 64, 224, 208), new ColorDesc("violet", 238, 130, 238), new ColorDesc("wheat", 245, 222, 179), new ColorDesc("white", 255, 255, 255), new ColorDesc("whitesmoke", 245, 245, 245), new ColorDesc("yellow", 255, 255, 0), new ColorDesc("yellowgreen", 154, 205, 50)};
    private static ColorSelector theSelector = null;
    private ColorSelectorListener listener;
    private Object callback;
    private boolean setFG;
    private OscarLabelButton ok;
    private TransparentPanel buttonPanel;
    ColorSampler sampler;
    private ColorButton currentSelection;

    public void dispose() {
        ((Component)this).setVisible(false);
        this.listener = null;
        this.callback = null;
        if (this.ok != null) {
            this.ok.destroy();
        }
        this.ok = null;
        if (this.buttonPanel != null) {
            this.buttonPanel.destroy();
        }
        this.buttonPanel = null;
        if (this.sampler != null) {
            this.sampler.destroy();
        }
        this.sampler = null;
        if (this.currentSelection != null) {
            this.currentSelection.destroy();
        }
        this.currentSelection = null;
        super.dispose();
    }

    public static void main(String[] stringArray) {
        new ColorSelector(null, "Set Foreground Color", Color.black, Color.white, true);
    }

    public ColorSelector(ColorSelectorListener colorSelectorListener, String string, Color color, Color color2, boolean bl) {
        this(colorSelectorListener, null, string, color, color2, bl);
    }

    public ColorSelector(ColorSelectorListener colorSelectorListener, Object object, String string, Color color, Color color2, boolean bl) {
        super(new Frame(), true);
        this.callback = object;
        this.setTitle(string);
        this.setFG = bl;
        this.listener = colorSelectorListener;
        ((Component)this).setSize(210, 200);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        ImagePanel imagePanel = new ImagePanel();
        this.add("Center", imagePanel);
        Image image = Oscar.images.getImage(this, Oscar.BG_TILE, imagePanel, true);
        imagePanel.setTile(image);
        imagePanel.setLayout(new BorderLayout(15, 15));
        TransparentPanel transparentPanel = new TransparentPanel();
        imagePanel.add("Center", transparentPanel);
        transparentPanel.setLayout(new GridLayout(4, 5, 2, 2));
        transparentPanel.add(new ColorButton(Color.white, this));
        transparentPanel.add(new ColorButton(Color.lightGray, this));
        transparentPanel.add(new ColorButton(Color.gray, this));
        transparentPanel.add(new ColorButton(Color.black, this));
        transparentPanel.add(new ColorButton(Color.red, this));
        transparentPanel.add(new ColorButton(Color.yellow, this));
        transparentPanel.add(new ColorButton(Color.green, this));
        transparentPanel.add(new ColorButton(Color.magenta, this));
        transparentPanel.add(new ColorButton(Color.cyan, this));
        transparentPanel.add(new ColorButton(Color.blue, this));
        transparentPanel.add(new ColorButton(Color.darkGray, this));
        transparentPanel.add(new ColorButton(Color.orange, this));
        transparentPanel.add(new ColorButton(Color.pink, this));
        transparentPanel.add(new ColorButton(ColorSelector.getColor("green"), this));
        transparentPanel.add(new ColorButton(ColorSelector.getColor("maroon"), this));
        transparentPanel.add(new ColorButton(ColorSelector.getColor("olive"), this));
        transparentPanel.add(new ColorButton(ColorSelector.getColor("teal"), this));
        transparentPanel.add(new ColorButton(ColorSelector.getColor("navy"), this));
        transparentPanel.add(new ColorButton(ColorSelector.getColor("purple"), this));
        transparentPanel.add(new ColorButton(ColorSelector.getColor("tan"), this));
        this.buttonPanel = new TransparentPanel();
        imagePanel.add("South", this.buttonPanel);
        this.sampler = new ColorSampler("Sample Text", color, color2);
        this.buttonPanel.add(this.sampler);
        this.ok = new OscarLabelButton("OK", this, this.buttonPanel);
        this.buttonPanel.add(this.ok);
        this.ok.addActionListener(this);
        this.addWindowListener(this);
        this.addKeyListener(this);
        ((Component)this).setVisible(true);
    }

    private static Color getColor(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < colorArray.length) {
            if (string.equals(ColorSelector.colorArray[n].name)) {
                return new Color(ColorSelector.colorArray[n].red, ColorSelector.colorArray[n].green, ColorSelector.colorArray[n].blue);
            }
            ++n;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.okAction();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 32 || n == 10) {
            this.okAction();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void okAction() {
        if (this.currentSelection != null && this.listener != null) {
            this.listener.setColor(this.callback, this.setFG, this.currentSelection.color);
        }
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void colorButtonSelected(ColorButton colorButton) {
        if (this.currentSelection != null) {
            this.currentSelection.selected(false);
        }
        this.currentSelection = colorButton;
        if (this.setFG) {
            this.sampler.setFG(colorButton.color);
            return;
        }
        this.sampler.setBG(colorButton.color);
    }

    public String getDisplayName() {
        return "Color Selector";
    }

    public String getName() {
        return "color selector";
    }
}

