/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import uiutil.ACheckboxGroup;

public class ACheckbox
extends Component
implements ItemSelectable {
    private static final int defaultVal = 14;
    private static final int interLabelGap = 2;
    protected String label;
    protected Image labelImg;
    private int labelWidth;
    private int labelHeight;
    protected ItemListener itemListener;
    protected boolean isChecked;
    protected boolean hasFocus;
    protected int width;
    protected int height;
    private int labelY;
    private final int padding = 4;
    private int cbWidth;
    private int cbHeight;
    private boolean isTraversable;
    private ACheckboxGroup group;
    private boolean mouseDown;
    private boolean isEnabled = true;
    private int leftMargin;
    private Image normalImg;
    private Image checkedImg;

    public ACheckbox() {
        this(null, false);
    }

    public ACheckbox(String string) {
        this(string, false);
    }

    public ACheckbox(String string, boolean bl) {
        this.label = string;
        this.isChecked = bl;
        this.enableEvents(28L);
    }

    public ACheckbox(String string, boolean bl, int n) {
        this(string, bl);
        this.leftMargin = n;
    }

    public ACheckbox(String string, ACheckboxGroup aCheckboxGroup) {
        this(string, false);
        this.setCheckboxGroup(aCheckboxGroup);
    }

    public ACheckbox(String string, ACheckboxGroup aCheckboxGroup, boolean bl) {
        this(string, bl);
        this.setCheckboxGroup(aCheckboxGroup);
    }

    public ACheckbox(String string, ACheckboxGroup aCheckboxGroup, boolean bl, int n) {
        this(string, bl);
        this.setCheckboxGroup(aCheckboxGroup);
        this.leftMargin = n;
    }

    public ACheckbox(Image image, Image image2) {
        this(null, false);
        this.normalImg = image;
        this.checkedImg = image2;
    }

    public ACheckbox(Image image, Image image2, String string) {
        this(string, false);
        this.normalImg = image;
        this.checkedImg = image2;
    }

    public ACheckbox(Image image, String string, boolean bl) {
        this(string, bl);
        this.labelImg = image;
    }

    public ACheckbox(Image image, String string) {
        this(string, false);
        this.labelImg = image;
    }

    public ACheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public void setCheckboxGroup(ACheckboxGroup aCheckboxGroup) {
        this.group = aCheckboxGroup;
        aCheckboxGroup.addCheckbox(this, this.isChecked);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        if (!this.isChecked) {
            return null;
        }
        return new Object[]{this};
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    private void calculateDimensions() {
        FontMetrics fontMetrics = this.getFontMetrics(super.getFont());
        this.cbWidth = this.normalImg != null ? this.normalImg.getWidth(this) : 14;
        int n = this.cbHeight = this.normalImg != null ? this.normalImg.getHeight(this) : 14;
        if (fontMetrics != null) {
            this.labelHeight = fontMetrics.getHeight();
            this.labelWidth = this.label != null ? fontMetrics.stringWidth(this.label) : 14;
            this.cbHeight = Math.max(this.labelHeight, this.cbHeight);
            if (this.normalImg == null) {
                this.cbWidth = this.cbHeight = this.labelHeight;
            }
            this.width = this.leftMargin + 1 + this.cbWidth + 4 + this.labelWidth + (this.labelImg != null ? 2 + this.labelImg.getWidth(this) : 0);
            this.height = Math.max(this.cbHeight, this.labelHeight) + 1;
            this.labelY = (this.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public boolean contains(int n, int n2) {
        return n > 0 && n < this.width && n2 > 0 && n2 < this.height;
    }

    public void setLabel(String string) {
        this.label = string;
        this.invalidate();
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setState(boolean bl) {
        this.isChecked = bl;
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.isEnabled = bl;
        this.repaint();
    }

    public void setLeftMargin(int n) {
        if (n < 0) {
            return;
        }
        this.leftMargin = n;
        this.calculateDimensions();
        this.repaint();
    }

    public boolean getState() {
        return this.isChecked;
    }

    public void addNotify() {
        super.addNotify();
        this.calculateDimensions();
    }

    public void removeNotify() {
        this.itemListener = null;
        this.normalImg = null;
        this.checkedImg = null;
    }

    public boolean isFocusTraversable() {
        return this.isTraversable;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1004: {
                if (!this.isTraversable) break;
                this.hasFocus = true;
                break;
            }
            case 1005: {
                this.hasFocus = false;
            }
        }
        this.repaint();
        super.processFocusEvent(focusEvent);
    }

    private final void processChange() {
        if (!this.isEnabled) {
            return;
        }
        if (this.isChecked && this.group != null) {
            return;
        }
        boolean bl = this.isChecked = !this.isChecked;
        if (this.group != null && this.isChecked) {
            this.group.setSelectedCheckbox(this);
        }
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this, this.isChecked ? 1 : 2));
        }
        this.repaint();
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.getID() == 401 && n == 32 && this.hasFocus) {
            this.processChange();
        }
        super.processKeyEvent(keyEvent);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (!this.contains(mouseEvent.getX(), mouseEvent.getY())) break;
                this.requestFocus();
                this.mouseDown = true;
                this.repaint();
                break;
            }
            case 502: {
                if (!this.contains(mouseEvent.getX(), mouseEvent.getY()) || !this.mouseDown) break;
                this.processChange();
                this.mouseDown = false;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void drawNormalCheckbox(Graphics graphics) {
        int n = (this.height - this.cbHeight) / 2;
        graphics.setColor(super.getBackground());
        if (this.group == null) {
            graphics.fillRect(2, n + 2, this.cbWidth + this.leftMargin - 4, this.cbHeight - 4);
        } else {
            graphics.fillOval(2, n + 2, this.cbWidth + this.leftMargin - 4, this.cbHeight - 4);
        }
        if (this.group == null) {
            if (this.isChecked) {
                graphics.setColor(super.getBackground().darker());
            } else {
                graphics.setColor(super.getBackground().brighter());
            }
            graphics.drawLine(this.leftMargin + 2, n + 2, this.leftMargin + this.cbWidth - 1, n + 2);
            graphics.drawLine(this.leftMargin + 2, n + 2, this.leftMargin + 2, n + this.cbHeight - 1);
            if (this.isChecked) {
                graphics.setColor(super.getBackground().brighter());
            } else {
                graphics.setColor(super.getBackground().darker());
            }
            graphics.drawLine(this.leftMargin + this.cbWidth - 1, n + 2, this.leftMargin + this.cbWidth - 1, n + this.cbHeight - 1);
            graphics.drawLine(this.leftMargin + 2, n + this.cbHeight - 1, this.leftMargin + this.cbWidth - 1, n + this.cbHeight - 1);
            graphics.setColor(Color.black);
            if (this.isChecked) {
                int n2 = this.cbWidth / 4;
                int n3 = this.cbHeight / 4;
                int n4 = n + 2;
                int n5 = this.leftMargin + n2 * 2;
                int n6 = n4 + n3 * 3;
                graphics.drawLine(this.leftMargin + n2, n4 + 2 * n3, n5, n6);
                graphics.drawLine(this.leftMargin + n2, n4 + 2 * n3 + 1, n5, n6 + 1);
                graphics.drawLine(n5, n6, n5 + 2 * n2, n4 + n3);
                graphics.drawLine(n5, n6 + 1, n5 + 2 * n2, n4 + n3 + 1);
                return;
            }
        } else {
            graphics.setColor(super.getForeground());
            graphics.drawOval(this.leftMargin + 2, n + 2, this.cbWidth - 4, this.cbHeight - 4);
            if (this.isChecked) {
                int n7 = this.cbHeight / 2;
                int n8 = n7 / 2 + 1;
                while (n8 < n7) {
                    graphics.drawOval(n8 + this.leftMargin, n8 + n, this.cbHeight - n8 * 2, this.cbHeight - n8 * 2);
                    ++n8;
                }
            }
        }
    }

    private void drawImageCheckbox(Graphics graphics) {
        if (!this.isChecked) {
            graphics.drawImage(this.normalImg, this.leftMargin, 0, this.cbWidth, this.cbHeight, this);
            return;
        }
        if (this.checkedImg != null) {
            graphics.drawImage(this.checkedImg, this.leftMargin, 0, this.cbWidth, this.cbHeight, this);
            return;
        }
        graphics.drawImage(this.normalImg, this.leftMargin, 0, this.cbWidth, this.cbHeight, this);
    }

    public void paint(Graphics graphics) {
        this.isTraversable = true;
        if (this.normalImg != null) {
            this.drawImageCheckbox(graphics);
        } else {
            this.drawNormalCheckbox(graphics);
        }
        int n = this.leftMargin + this.cbWidth + 4;
        if (this.labelImg != null) {
            int n2 = this.labelImg.getWidth(this);
            graphics.drawImage(this.labelImg, n, (this.height - this.labelImg.getHeight(this)) / 2, this);
            n += n2 + 2;
        }
        if (this.label != null) {
            graphics.setFont(super.getFont());
            graphics.setColor(super.getForeground());
            if (!this.isEnabled) {
                graphics.setColor(Color.white);
                graphics.drawString(this.label, n + 1, this.labelY + 1);
                graphics.setColor(Color.gray);
            }
            graphics.drawString(this.label, n, this.labelY);
        }
        if (this.isEnabled && this.hasFocus && (this.label != null || this.labelImg != null)) {
            graphics.drawRect(this.leftMargin + this.cbWidth + 2, 0, this.width - this.leftMargin - this.cbWidth - 2 - 1, this.height - 1);
        }
    }
}

