/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import snac.SnacConstants;
import snac.SnacTlv;
import snac.TLV;

public class SnacAdmininfo
implements SnacConstants {
    private static final String MODULE = "SNAC";
    public int infoCode;
    public int numTlvs;
    public TLV tlvData;

    public SnacAdmininfo(int n, int n2, TLV tLV) {
        this.infoCode = n;
        this.numTlvs = n2;
        this.tlvData = tLV;
    }

    SnacAdmininfo(DataInputStream dataInputStream) throws IOException {
        this.infoCode = dataInputStream.readUnsignedShort();
        if (this.infoCode < 1 || this.infoCode > 3) {
            throw new IOException("infoCode bad value " + this.infoCode);
        }
        this.numTlvs = dataInputStream.readUnsignedShort();
        this.tlvData = new TLV();
        int n = 0;
        while (n < this.numTlvs && dataInputStream.available() > 0) {
            this.tlvData.addElement(new SnacTlv(dataInputStream));
            ++n;
        }
        if (n < this.numTlvs) {
            throw new IOException("read underflow");
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        if (this.infoCode < 1 || this.infoCode > 3) {
            throw new IOException("infoCode bad value " + this.infoCode);
        }
        dataOutputStream.writeShort(this.infoCode);
        dataOutputStream.writeShort(this.numTlvs);
        int n = 0;
        while (n < this.numTlvs && n < this.tlvData.size()) {
            ((SnacTlv)this.tlvData.elementAt(n)).write(dataOutputStream);
            ++n;
        }
    }
}

