/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Vector;
import snac.SnacID;
import snac.SnacRateClassMembers;
import snac.SnacRateParameters;

class RateMonitor {
    public SnacRateParameters params;
    public SnacRateClassMembers members;
    public long lastSendTime;
    public boolean limited;

    RateMonitor(SnacRateParameters snacRateParameters, SnacRateClassMembers snacRateClassMembers, long l) {
        this.params = snacRateParameters;
        this.members = snacRateClassMembers;
        this.lastSendTime = l;
        this.limited = false;
    }

    public String toString() {
        return "RateMonitor " + RateMonitor.snacRateParametersToString(this.params) + " " + RateMonitor.snacRateClassMembersToString(this.members) + " lastSendTime " + this.lastSendTime;
    }

    public synchronized int getRateNow(long l) {
        int n = (int)(l - this.lastSendTime);
        int n2 = (this.params.currentAverage * (this.params.windowSize - 1) + n) / this.params.windowSize;
        if (n2 > this.params.maxAverage) {
            n2 = this.params.maxAverage;
        }
        return n2;
    }

    public static String snacRateParametersToString(SnacRateParameters snacRateParameters) {
        return "parms id " + snacRateParameters.id + " win " + snacRateParameters.windowSize + " c " + snacRateParameters.clearThreshold + " a " + snacRateParameters.alertThreshold + " r " + snacRateParameters.limitThreshold + " d " + snacRateParameters.disconnectThreshold + " curave " + snacRateParameters.currentAverage + " maxAve " + snacRateParameters.maxAverage;
    }

    public static String snacRateClassMembersToString(SnacRateClassMembers snacRateClassMembers) {
        String string = "classes id " + snacRateClassMembers.id + " members " + snacRateClassMembers.numMembers;
        int n = 0;
        while (n < snacRateClassMembers.snacidArray.size()) {
            SnacID snacID = (SnacID)snacRateClassMembers.snacidArray.elementAt(n);
            string = String.valueOf(string) + " " + snacID.group + "/" + snacID.type;
            ++n;
        }
        return string;
    }

    public static RateMonitor getByClass(Vector vector, int n) {
        RateMonitor rateMonitor = null;
        int n2 = 0;
        while (vector != null && n2 < vector.size()) {
            RateMonitor rateMonitor2 = (RateMonitor)vector.elementAt(n2);
            if (rateMonitor2.params.id == n) {
                rateMonitor = rateMonitor2;
                break;
            }
            ++n2;
        }
        return rateMonitor;
    }

    public static RateMonitor getByMsg(Vector vector, int n, int n2) {
        RateMonitor rateMonitor = null;
        int n3 = 0;
        while (vector != null && n3 < vector.size()) {
            RateMonitor rateMonitor2 = (RateMonitor)vector.elementAt(n3);
            int n4 = 0;
            while (n4 < rateMonitor2.members.numMembers) {
                SnacID snacID = (SnacID)rateMonitor2.members.snacidArray.elementAt(n4);
                if (snacID.group == n && snacID.type == n2) {
                    rateMonitor = rateMonitor2;
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        return rateMonitor;
    }
}

