/*
 * Decompiled with CFR 0.152.
 */
package main;

import snac.SnacConstants;
import snac.SnacNickinfo;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.TLV;
import util.JUtil;
import util.Log;

public class Nickname
implements SnacConstants {
    public String nickname = "";
    public int evil = -1;
    private TLV userClass;
    public long createTOD = -1L;
    public long memberSince = -1L;
    public long signonTOD = -1L;
    public int idleTime = -1;
    public boolean isDT = false;
    public boolean isAdministrator = false;
    public boolean isAOLUser = false;
    public boolean isOscarPayUser = false;
    public boolean isOscarFreeUser = false;

    public static SnacNickname snacNickname(String string) {
        byte[] byArray = string.getBytes();
        SnacNickname snacNickname = new SnacNickname(string.length(), byArray);
        return snacNickname;
    }

    public static String snacNickname(SnacNickname snacNickname) {
        return new String(snacNickname.data);
    }

    private void parseUserClass(TLV tLV) {
        if (tLV == null || tLV.size() < 1) {
            return;
        }
        if (tLV.tlvTypePresent(1)) {
            int n = tLV.getTlvDataAsU16(1);
            Log.log("Nickname", Log.DB0, "nick flags are " + Integer.toHexString(n) + ".");
            this.isDT = (n & 1) != 0;
            this.isAdministrator = (n & 2) != 0;
            this.isAOLUser = (n & 4) != 0;
            this.isOscarPayUser = (n & 8) != 0;
            boolean bl = this.isOscarFreeUser = (n & 0x10) != 0;
        }
        if (tLV.tlvTypePresent(2)) {
            this.createTOD = tLV.getTlvDataAsS32(2);
        }
        if (tLV.tlvTypePresent(5)) {
            this.memberSince = tLV.getTlvDataAsS32(5);
        }
        if (tLV.tlvTypePresent(3)) {
            this.signonTOD = tLV.getTlvDataAsS32(3);
        }
        if (tLV.tlvTypePresent(4)) {
            this.idleTime = tLV.getTlvDataAsU16(4);
        }
    }

    public Nickname(SnacNicknameWinfo snacNicknameWinfo) {
        this.nickname = new String(snacNicknameWinfo.nickname.data);
        this.evil = snacNicknameWinfo.info.currentEvil;
        this.userClass = snacNicknameWinfo.info.userAttributes;
        this.parseUserClass(this.userClass);
    }

    public Nickname(String string) {
        this.nickname = string;
    }

    public Nickname(String string, int n, TLV tLV) {
        this.nickname = string;
        this.evil = n;
        this.userClass = tLV;
        this.parseUserClass(this.userClass);
    }

    public int getClassCode() {
        int n = -1;
        if (this.isDT) {
            n = 0;
        } else if (this.isAdministrator) {
            n = 4;
        } else if (this.isOscarPayUser) {
            n = 2;
        } else if (this.isOscarFreeUser) {
            n = 1;
        } else if (this.isAOLUser) {
            n = 3;
        }
        return n;
    }

    public boolean isOnline() {
        return this.isOscarPayUser || this.isOscarFreeUser || this.isAOLUser;
    }

    public SnacNicknameWinfo toSnacNicknameWinfo() {
        SnacNickname snacNickname = Nickname.snacNickname(this.nickname);
        int n = 0;
        if (this.userClass != null) {
            n = this.userClass.size();
        }
        SnacNickinfo snacNickinfo = new SnacNickinfo(this.evil, n, this.userClass);
        SnacNicknameWinfo snacNicknameWinfo = new SnacNicknameWinfo(snacNickname, snacNickinfo);
        return snacNicknameWinfo;
    }

    public String memberSinceAsString() {
        return Nickname.getMemberSinceAsString(this.memberSince);
    }

    public static String getMemberSinceAsString(long l) {
        if (l == -1L) {
            return null;
        }
        int n = (int)(l & 0xFFFFL);
        int n2 = (int)(l >> 16 & 0xFFL);
        int n3 = (int)(l >> 24 & 0xFFL);
        if (n != 0 && n3 >= 1 && n3 <= 12 && n2 != 0) {
            return String.valueOf(JUtil.months[n3 - 1]) + " " + n2 + " " + n;
        }
        if (n != 0 && n3 >= 1 && n3 <= 12 && n2 == 0) {
            return String.valueOf(JUtil.months[n3 - 1]) + " " + n;
        }
        if (n != 0 && n3 == 0 && n2 == 0) {
            return String.valueOf(n);
        }
        return null;
    }

    public String toString() {
        return "Nickname: " + this.nickname + " " + this.evil + " " + this.userClass + " " + this.getClassCode() + " " + this.createTOD + " " + this.memberSince + " " + this.signonTOD + " " + this.idleTime + " " + this.isDT + " " + this.isAdministrator + " " + this.isAOLUser + " " + this.isOscarPayUser + " " + this.isOscarFreeUser;
    }

    public String normalize() {
        return Nickname.normalize(this.nickname);
    }

    public static String normalize(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            if (Character.isLetterOrDigit(cArray[n2])) {
                cArray[n3] = Character.toLowerCase(cArray[n2]);
                ++n3;
            }
            ++n2;
        }
        return String.valueOf(cArray, 0, n3);
    }
}

