/*
 * Decompiled with CFR 0.152.
 */
package main;

import flap.FLAPSock;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import main.DispatcherInfo;
import main.DispatcherReadThread;
import main.DispatcherWriteThread;
import main.GenericFLAPSockHandler;
import main.RateMonitor;
import main.Registry;
import main.RegistryEntry;
import main.ReqIDMgr;
import main.SNACData;
import snac.DispatcherListener;
import snac.Listener;
import snac.ReqID;
import snac.SNACHeader;
import snac.ServiceHandler;
import snac.SnacConstants;
import snac.SnacHandler;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.Queue;

public abstract class Dispatcher
extends GenericFLAPSockHandler
implements DispatcherListener,
SnacConstants {
    private static final String MODULE = "Dispatcher";
    public Registry registry = new Registry();
    private ReqIDMgr reqIDMgr;
    private Queue incomingSNAC;
    private int maxIncomingQueueSize;
    private Queue outgoingSNAC;
    private int maxOutgoingQueueSize;
    private DispatcherReadThread reader;
    private DispatcherWriteThread writer;
    protected Hashtable openConnections;
    public boolean run;

    public Dispatcher(boolean bl) {
        this.reqIDMgr = new ReqIDMgr(bl);
        this.incomingSNAC = new Queue();
        this.outgoingSNAC = new Queue();
        this.openConnections = new Hashtable();
        this.run = true;
        this.reader = new DispatcherReadThread(this);
        this.reader.start();
        this.writer = new DispatcherWriteThread(this);
        this.writer.start();
    }

    public void shutdown() {
        Log.log(MODULE, Log.INFO, "Dispatcher got shutdown.");
        this.run = false;
    }

    public void registerSNACHandler(int n, int n2, SnacHandler snacHandler) {
        this.registry.registerSNACHandler(n, n2, snacHandler);
    }

    public SnacHandler getHandler(int n) {
        RegistryEntry registryEntry = this.registry.lookupEntry(n);
        if (registryEntry == null) {
            return null;
        }
        return registryEntry.handler;
    }

    public void FLAPSignOn(FLAPSock fLAPSock, TLV tLV) {
        super.FLAPSignOn(fLAPSock, tLV);
        this.openConnections.put(fLAPSock, fLAPSock);
    }

    public void FLAPSignOff(FLAPSock fLAPSock, TLV tLV) {
        super.FLAPSignOff(fLAPSock, tLV);
        Vector vector = this.registry.listeners();
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            Listener listener = (Listener)vector.elementAt(n);
            bl |= listener.connectionSignOff(fLAPSock, tLV, bl);
            ++n;
        }
    }

    public void FLAPData(FLAPSock fLAPSock, byte[] byArray) {
        super.FLAPData(fLAPSock, byArray);
        this.queueInput(fLAPSock, byArray);
    }

    public void FLAPConnectionClosed(FLAPSock fLAPSock, boolean bl, String string, int n) {
        super.FLAPConnectionClosed(fLAPSock, bl, string, n);
        Log.log("in Dispatcher FLAPConnectionClosed, closing " + fLAPSock);
        Log.log("openConnections " + this.openConnections);
        this.openConnections.remove(fLAPSock);
        Log.log("openConnections " + this.openConnections);
        Vector vector = this.registry.listeners();
        Log.log("listeners " + vector);
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            Listener listener = (Listener)vector.elementAt(n2);
            Log.log("trying " + listener + " handled " + bl2);
            bl2 |= listener.connectionClosed(fLAPSock, bl, string, n, bl2);
            ++n2;
        }
        Log.log("done, handled " + bl2);
    }

    public void registerListener(int n, int n2, Listener listener) {
        this.registry.registerListener(n, n2, listener);
    }

    public void queueOutput(FLAPSock fLAPSock, Listener listener, Object object, int n, int n2, TLV tLV, byte[] byArray) {
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            ReqID reqID = this.reqIDMgr.generateID();
            this.reqIDMgr.registerID(reqID, listener, object);
            SNACHeader sNACHeader = new SNACHeader(n, n2, reqID, tLV);
            SNACData sNACData = new SNACData(fLAPSock, sNACHeader, byArray);
            this.outgoingSNAC.queue(sNACData);
            this.maxOutgoingQueueSize = Math.max(this.maxOutgoingQueueSize, this.outgoingSNAC.size());
            return;
        }
    }

    public int outgoingQueueSize() {
        return this.outgoingSNAC.size();
    }

    public synchronized void queueInput(FLAPSock fLAPSock, byte[] byArray) {
        if (byArray.length < SNACHeader.SNAC_HEADER_LEN) {
            ErrorMgr.warn(MODULE, "read truncated snac, length " + byArray.length);
            return;
        }
        SNACData sNACData = new SNACData(fLAPSock, null, byArray);
        this.incomingSNAC.queue(sNACData);
        this.maxIncomingQueueSize = Math.max(this.maxIncomingQueueSize, this.incomingSNAC.size());
    }

    public int incomingQueueSize() {
        return this.incomingSNAC.size();
    }

    public void handleOutgoingSNAC() {
        SNACData sNACData = (SNACData)this.outgoingSNAC.dequeue();
        if (sNACData == null || sNACData.s == null || sNACData.h == null || sNACData.payload == null) {
            ErrorMgr.warn(MODULE, "bad outgoing data, ignoring");
            return;
        }
        if (this.openConnections.get(sNACData.s) == null || !sNACData.s.okToSendData()) {
            return;
        }
        try {
            sNACData.s.sendData(sNACData.h.bytes(), sNACData.payload);
            this.updateRate(sNACData.s, sNACData.h);
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn(MODULE, "write exception " + iOException.getMessage(), iOException);
            sNACData.s.close("Dispatcher got exception writing snac " + iOException.getMessage(), 29);
            return;
        }
    }

    private void updateRate(FLAPSock fLAPSock, SNACHeader sNACHeader) {
        Vector vector = (Vector)fLAPSock.userData;
        if (vector == null) {
            return;
        }
        RateMonitor rateMonitor = RateMonitor.getByMsg(vector, sNACHeader.family, sNACHeader.subtype);
        if (rateMonitor == null) {
            return;
        }
        long l = System.currentTimeMillis();
        rateMonitor.params.currentAverage = rateMonitor.getRateNow(l);
        rateMonitor.lastSendTime = l;
    }

    public void preDecodeRoutine(SNACHeader sNACHeader, FLAPSock fLAPSock, Vector vector) {
    }

    void handleIncomingSNAC() {
        block8: {
            SNACData sNACData = (SNACData)this.incomingSNAC.dequeue();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(sNACData.payload);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            SNACHeader sNACHeader = null;
            try {
                sNACHeader = new SNACHeader(dataInputStream);
                DispatcherInfo dispatcherInfo = this.findSNACDestination(sNACHeader);
                if (dispatcherInfo != null && dispatcherInfo.reg != null && dispatcherInfo.reg.handler != null) {
                    this.preDecodeRoutine(sNACHeader, sNACData.s, dispatcherInfo.getListeners());
                    dispatcherInfo.reg.handler.decodeSNAC(sNACData.s, sNACHeader, dataInputStream, dispatcherInfo.getListener(), dispatcherInfo.getCallbackData(), dispatcherInfo.getListeners());
                    this.reqIDMgr.deregisterID(dispatcherInfo.getReqID());
                    return;
                }
                if (sNACHeader == null) {
                    ErrorMgr.diag(MODULE, "header==null");
                } else {
                    ErrorMgr.warn(MODULE, "Got SNAC with no listeners, ignoring it: " + sNACHeader.toString());
                    ErrorMgr.diag(MODULE, sNACHeader.toString());
                }
                if (this.registry == null) {
                    ErrorMgr.diag(MODULE, "registry == null");
                } else {
                    ErrorMgr.diag(MODULE, this.registry.toString());
                }
                if (sNACData.s != null && sNACHeader != null) {
                    ServiceHandler serviceHandler = (ServiceHandler)this.getHandler(1);
                    serviceHandler.snacError(sNACData.s, null, null, sNACHeader.reqID, 1, null);
                    return;
                }
            }
            catch (IOException iOException) {
                ErrorMgr.warn(MODULE, "IOException reading SNAC " + iOException.getMessage());
                if (sNACData.s == null || sNACHeader == null) break block8;
                ServiceHandler serviceHandler = (ServiceHandler)this.getHandler(1);
                serviceHandler.snacError(sNACData.s, null, null, sNACHeader.reqID, 14, null);
            }
        }
    }

    private DispatcherInfo findSNACDestination(SNACHeader sNACHeader) {
        DispatcherInfo dispatcherInfo = new DispatcherInfo();
        dispatcherInfo.id = this.reqIDMgr.lookupID(sNACHeader.reqID);
        if (dispatcherInfo.id != null || this.reqIDMgr.isIncomingID(sNACHeader.reqID)) {
            dispatcherInfo.reg = this.registry.lookupEntry(sNACHeader.family);
            return dispatcherInfo;
        }
        return null;
    }
}

