/*
 * Decompiled with CFR 0.152.
 */
package component;

import java.util.Date;
import java.util.Vector;
import main.Nickname;
import util.KeyBindings;

public class User {
    public static final int OFFLINE = 0;
    public static final int ONLINE = 1;
    public static final int ADDED = 2;
    public static final int DELETED = 3;
    public static final int UNREGISTERED = 0;
    public static final int OSCAR_FREE = 1;
    public static final int OSCAR_PAY = 2;
    public static final int AOL = 3;
    public static final int ADMINISTRATOR = 4;
    public static final int TOTAL_CLASSES = 5;
    public static final int UNKNOWN_VALUE = -1;
    public boolean changed = true;
    public String name;
    public int status = 2;
    public long logTime;
    public int userClass = -1;
    public int evil = -1;
    public long idle;
    public long signon;
    public long memberSince = -1L;
    public KeyBindings attributes;

    public User(String string) {
        this.name = string;
        this.logTime = new Date().getTime();
    }

    public String getMemberSinceAsString() {
        return Nickname.getMemberSinceAsString(this.memberSince);
    }

    public void markAdded() {
        this.changed = true;
        this.status = 2;
        this.logTime = new Date().getTime();
    }

    public void markDeleted() {
        this.changed = true;
        this.status = 3;
    }

    public String name() {
        return Nickname.normalize(this.name);
    }

    public void setStatus(int n) {
        this.changed = true;
        this.status = n;
    }

    public String toString() {
        String string = new String(String.valueOf(this.name) + " ");
        switch (this.status) {
            case 0: {
                string = String.valueOf(string) + "offline ";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "online ";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "added ";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "deleted ";
                break;
            }
            default: {
                string = String.valueOf(string) + "nostate ";
            }
        }
        switch (this.userClass) {
            case 0: {
                string = String.valueOf(string) + "unregistered ";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "oscar free";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "oscar pay";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "aol ";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "administrator ";
                break;
            }
            default: {
                string = String.valueOf(string) + "noclass ";
            }
        }
        string = String.valueOf(string) + "warnings(" + this.evil + ") ";
        string = String.valueOf(string) + "idle(" + this.idle + ") ";
        if (!this.changed) {
            string = String.valueOf(string) + "un";
        }
        string = String.valueOf(string) + "changed ";
        string = String.valueOf(string) + this.logTime + " ";
        string = String.valueOf(string) + this.attributes;
        return string;
    }

    public static User[] toUsers(Vector vector) {
        User[] userArray = null;
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            userArray = new User[n];
            int n2 = 0;
            while (n2 < n) {
                userArray[n2] = new User((String)vector.elementAt(n2));
                ++n2;
            }
        }
        return userArray;
    }
}

