/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyCore;
import component.Tool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import main.Oscar;
import main.Permissions;
import uiutil.ACheckbox;
import uiutil.ACheckboxGroup;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.Icon;
import uiutil.ImageLabel;
import uiutil.ListEditor;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.KeyBindings;

public class PermitProps
extends PropertySheet
implements ChangeListener,
ItemListener {
    private static final String MODULE = "PermitProps";
    private static final String DONT_EXPLAIN_KEY = "Privacy.dontExplainBlocking";
    private Tools tools;
    private ChangeListener changeListener;
    private boolean changed = false;
    private ACheckboxGroup permissionGroup;
    private ACheckbox permitAllCheck;
    private ImageLabel permitAllLabel;
    private ACheckbox denyAllCheck;
    private ACheckbox permitCheck;
    private ACheckbox denyCheck;
    private ACheckbox oscarPayCheck;
    private ACheckbox oscarFreeCheck;
    private ACheckbox aolCheck;
    private ACheckbox dtCheck;
    private ListEditor allowListEditor;
    private ListEditor blockListEditor;
    private Checkbox publishIdleCheck;
    private Checkbox publishMemberCheck;
    private Icon[] icons;

    public PermitProps(Tools tools, ChangeListener changeListener) {
        this.tools = tools;
        this.changeListener = changeListener;
        this.setLayout(new BorderLayout());
        TransparentPanel transparentPanel = new TransparentPanel();
        this.add("North", transparentPanel);
        transparentPanel.setLayout(new BorderLayout(0, 0));
        transparentPanel.add("North", new Spacer(5, 5));
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add("Center", transparentPanel2);
        transparentPanel2.setLayout(new GridLayout(0, 1, 0, 0));
        this.permissionGroup = new ACheckboxGroup();
        this.permitAllCheck = new ACheckbox("Allow all members to see or contact me.", this.permissionGroup, false, 10);
        this.permitAllCheck.addItemListener(this);
        transparentPanel2.add(this.permitAllCheck);
        this.denyAllCheck = new ACheckbox("Block all members.", this.permissionGroup, false, 10);
        this.denyAllCheck.addItemListener(this);
        transparentPanel2.add(this.denyAllCheck);
        this.permitCheck = new ACheckbox("Allow only the members listed below.", this.permissionGroup, false, 10);
        this.permitCheck.addItemListener(this);
        transparentPanel2.add(this.permitCheck);
        this.denyCheck = new ACheckbox("Block only the members listed below.", this.permissionGroup, false, 10);
        this.denyCheck.addItemListener(this);
        transparentPanel2.add(this.denyCheck);
        BuddyCore buddyCore = (BuddyCore)tools.get("Buddy List");
        TransparentPanel transparentPanel3 = new TransparentPanel();
        this.add("Center", transparentPanel3);
        this.allowListEditor = new ListEditor("Allow List:", "Add", "Remove", this, buddyCore);
        transparentPanel3.add(this.allowListEditor);
        this.blockListEditor = new ListEditor("Block List:", "Add", "Remove", this, buddyCore);
        transparentPanel3.add(this.blockListEditor);
        transparentPanel3 = new TransparentPanel();
        this.add("South", transparentPanel3);
        transparentPanel3.setLayout(new BorderLayout());
        transparentPanel = new TransparentPanel();
        transparentPanel3.add("North", transparentPanel);
        transparentPanel.setLayout(new GridLayout(0, 1, 0, 0));
        transparentPanel.add(new Label(" Allow By Class:"));
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add(transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(0, 15, 0));
        String[] stringArray = new String[]{"AOL16", "NBPay", "NBFree", "DT"};
        Tool tool = tools.get("Buddy List");
        Image[] imageArray = Oscar.images.getImages(tool, stringArray, transparentPanel2, true);
        this.icons = new Icon[imageArray.length];
        int n = 0;
        while (n < imageArray.length) {
            this.icons[n] = new Icon(16, 16);
            this.icons[n].setImage(imageArray[n]);
            ++n;
        }
        this.aolCheck = new ACheckbox(imageArray[0], "AOL");
        transparentPanel2.add(this.aolCheck);
        this.aolCheck.addItemListener(this);
        this.oscarPayCheck = new ACheckbox(imageArray[1], "Pay");
        transparentPanel2.add(this.oscarPayCheck);
        this.oscarPayCheck.addItemListener(this);
        this.oscarFreeCheck = new ACheckbox(imageArray[2], "Free");
        transparentPanel2.add(this.oscarFreeCheck);
        this.oscarFreeCheck.addItemListener(this);
        this.dtCheck = new ACheckbox(imageArray[3], "Trial");
        transparentPanel2.add(this.dtCheck);
        this.dtCheck.addItemListener(this);
        this.setValues();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
        if (itemEvent.getSource() instanceof ACheckbox) {
            boolean bl = true;
            ACheckbox aCheckbox = (ACheckbox)itemEvent.getSource();
            if (aCheckbox == this.permitAllCheck || aCheckbox == this.denyAllCheck) {
                this.allowListEditor.setEnabled(false);
                this.blockListEditor.setEnabled(false);
                if (aCheckbox == this.permitAllCheck) {
                    bl = false;
                }
            } else if (aCheckbox == this.permitCheck) {
                this.allowListEditor.setEnabled(true);
                this.blockListEditor.setEnabled(false);
            } else if (aCheckbox == this.denyCheck) {
                this.allowListEditor.setEnabled(false);
                this.blockListEditor.setEnabled(true);
            } else if (aCheckbox == this.oscarFreeCheck || aCheckbox == this.oscarPayCheck || aCheckbox == this.aolCheck || aCheckbox == this.dtCheck) {
                bl = !aCheckbox.getState();
            }
            String string = Oscar.config.getValue(DONT_EXPLAIN_KEY);
            if (bl && (string == null || !string.equalsIgnoreCase("true"))) {
                ChoiceUI.newChoiceUI("Permit Alert", "Blocking members is symmetric. When you block a member, that member cannot see you online nor communicate with you. Likewise, you will not be able to see the blocked member online nor communicate with the member you have blocked.", Oscar.WARNING_SOUND, "Don't show this message again.", DONT_EXPLAIN_KEY);
            }
        }
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Permit Setup Help", "This is where you control who can communicate with you and see you online. When you block a member, that member cannot see you online nor can you see that member. When a blocked member attempts to communicate with you online, the blocked member is told you are not logged on. Similarly, you are told the blocked member is not online. To block a list of members, select \"Block only the members listed below\" and add the members you wish to block to the block list. Similarly, you may allow only a selected group of members to interact with you by specifying an allow list. All members not on your allow list are blocked. You can block entire classes of members by unchecking any of the checkboxes under the heading \"Allow By Class\".");
        return true;
    }

    public void removeNotify() {
        this.removeAll();
        this.tools = null;
        this.changeListener = null;
        this.permissionGroup = null;
        this.permitAllCheck = null;
        this.permitAllLabel = null;
        this.denyAllCheck = null;
        this.permitCheck = null;
        this.denyCheck = null;
        this.oscarPayCheck = null;
        this.oscarFreeCheck = null;
        this.aolCheck = null;
        this.dtCheck = null;
        this.allowListEditor = null;
        this.blockListEditor = null;
        this.publishIdleCheck = null;
        this.publishMemberCheck = null;
        if (this.icons != null) {
            int n = 0;
            while (n < this.icons.length) {
                this.icons[n] = null;
                ++n;
            }
            this.icons = null;
        }
        super.removeNotify();
    }

    public boolean save() {
        String string;
        int n;
        int n2;
        int n3;
        KeyBindings keyBindings = Oscar.config.getKeyBindings("Privacy");
        if (keyBindings == null) {
            keyBindings = Oscar.config.addKeyBindings("Privacy");
        }
        boolean bl = true;
        Vector vector = this.allowListEditor.getListVector();
        if (vector != null) {
            n3 = Oscar.permit.getMaxPermits();
            n2 = vector.size();
            n = 0;
            while (n < n2) {
                string = (String)vector.elementAt(n);
                if (!this.allowListEditor.validItem(string)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return false;
            }
            keyBindings.setValues("allowList", vector);
            if (n2 > n3) {
                ChoiceUI.newChoiceUI("Save Permit", "Your allow list exceeds the limit of " + n3 + " names by " + (n3 - n2) + ". The extra names " + "will be ignored.");
            }
        }
        if ((vector = this.blockListEditor.getListVector()) != null) {
            n3 = Oscar.permit.getMaxDenies();
            n2 = vector.size();
            n = 0;
            while (n < n2) {
                string = (String)vector.elementAt(n);
                if (!this.blockListEditor.validItem(string)) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return false;
            }
            keyBindings.setValues("blockList", vector);
            if (n2 > n3) {
                ChoiceUI.newChoiceUI("Save Permit", "Your block list exceeds the limit of " + n3 + " names by " + (n3 - n2) + ". The extra names " + "will be ignored.");
            }
        }
        if (this.permitAllCheck.getState()) {
            keyBindings.setValue("pref", "allowAll");
        } else if (this.denyAllCheck.getState()) {
            keyBindings.setValue("pref", "blockAll");
        } else if (this.permitCheck.getState()) {
            keyBindings.setValue("pref", "allowSome");
        } else {
            keyBindings.setValue("pref", "blockSome");
        }
        keyBindings.deleteKey("allowClassList");
        keyBindings.setValues("allowClassList", null);
        if (this.oscarPayCheck.getState()) {
            keyBindings.appendValue("allowClassList", "oscarPay");
        }
        if (this.oscarFreeCheck.getState()) {
            keyBindings.appendValue("allowClassList", "oscarFree");
        }
        if (this.aolCheck.getState()) {
            keyBindings.appendValue("allowClassList", "aol");
        }
        if (this.dtCheck.getState()) {
            keyBindings.appendValue("allowClassList", "trial");
        }
        Permissions permissions = Oscar.permit.getPermissions();
        Oscar.permit.sendPermissions(permissions);
        BuddyCore buddyCore = (BuddyCore)this.tools.get("Buddy List");
        buddyCore.updateBuddyLists(permissions);
        this.setChanged(false);
        return true;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setValues() {
        int n = 0;
        KeyBindings keyBindings = Oscar.config.getKeyBindings("Privacy");
        this.allowListEditor.setValues(keyBindings.getValues("allowList"));
        this.blockListEditor.setValues(keyBindings.getValues("blockList"));
        this.allowListEditor.setEnabled(false);
        this.blockListEditor.setEnabled(false);
        Permissions permissions = Oscar.permit.getPermissions();
        n = 0;
        if (permissions.names != null) {
            n = permissions.names.size();
        }
        if (permissions.isPermit) {
            if (n > 0) {
                this.permitCheck.setState(true);
                this.allowListEditor.setEnabled(true);
            } else {
                this.denyAllCheck.setState(true);
            }
        } else if (n > 0) {
            this.denyCheck.setState(true);
            this.blockListEditor.setEnabled(true);
        } else {
            this.permitAllCheck.setState(true);
        }
        this.oscarPayCheck.setState(permissions.permitOscarPayUser);
        this.oscarFreeCheck.setState(permissions.permitOscarFreeUser);
        this.aolCheck.setState(permissions.permitAOLUser);
        this.dtCheck.setState(permissions.permitDT);
        this.setChanged(false);
    }
}

