/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.BuddyCore;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import main.Oscar;
import uiutil.ACheckbox;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.ImageLabel;
import uiutil.PropertySheet;

class BuddyGeneralProps
extends PropertySheet
implements ItemListener {
    private BuddyCore core;
    private ChangeListener changeListener;
    private boolean changed = false;
    private ACheckbox soundSignOnCheck;
    private ACheckbox soundSignOffCheck;
    private ACheckbox classCheck;
    private ACheckbox evilCheck;
    private ACheckbox idleCheck;
    private ACheckbox signonCheck;

    public BuddyGeneralProps(BuddyCore buddyCore, ChangeListener changeListener) {
        this.setBackground(Oscar.backgroundColor);
        this.core = buddyCore;
        this.changeListener = changeListener;
        this.setLayout(new GridLayout(0, 1));
        this.add(new ImageLabel("Sounds:", 2));
        this.soundSignOnCheck = new ACheckbox("Play sound when buddies sign on.", false, 10);
        this.add(this.soundSignOnCheck);
        this.soundSignOnCheck.addItemListener(this);
        this.soundSignOffCheck = new ACheckbox("Play sound when buddies sign off.", false, 10);
        this.add(this.soundSignOffCheck);
        this.soundSignOffCheck.addItemListener(this);
        this.add(new ImageLabel("Show Icons:", 2));
        this.classCheck = new ACheckbox("Class", false, 10);
        this.add(this.classCheck);
        this.classCheck.addItemListener(this);
        this.evilCheck = new ACheckbox("Warnings", false, 10);
        this.add(this.evilCheck);
        this.evilCheck.addItemListener(this);
        this.idleCheck = new ACheckbox("Idle Time", false, 10);
        this.add(this.idleCheck);
        this.idleCheck.addItemListener(this);
        this.signonCheck = new ACheckbox("Signon Time", false, 10);
        this.add(this.signonCheck);
        this.signonCheck.addItemListener(this);
        this.setValues();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Buddy Preferences Setup Help", "Check the checkboxes under the \"Sounds\" heading to play sounds when your buddies log in and out. Check the checkboxes under the \"Show Icons\" heading to show the specified icons in your buddy list.");
        return true;
    }

    public void removeNotify() {
        this.removeAll();
        this.core = null;
        this.changeListener = null;
        this.soundSignOnCheck = null;
        this.soundSignOffCheck = null;
        this.classCheck = null;
        this.evilCheck = null;
        this.idleCheck = null;
        this.signonCheck = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public boolean save() {
        this.core.buddyListPrefs.setValue(BuddyCore.SOUND_LOGON, String.valueOf(this.soundSignOnCheck.getState()));
        this.core.buddyListPrefs.setValue(BuddyCore.SOUND_LOGOFF, String.valueOf(this.soundSignOffCheck.getState()));
        this.core.buddyListPrefs.setValue(BuddyCore.SHOW_CLASS, String.valueOf(this.classCheck.getState()));
        this.core.buddyListPrefs.setValue(BuddyCore.SHOW_EVIL, String.valueOf(this.evilCheck.getState()));
        this.core.buddyListPrefs.setValue(BuddyCore.SHOW_IDLE_TIME, String.valueOf(this.idleCheck.getState()));
        this.core.buddyListPrefs.setValue(BuddyCore.SHOW_SIGNON_TIME, String.valueOf(this.signonCheck.getState()));
        this.core.savePreferences();
        this.setChanged(false);
        return true;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setValues() {
        this.soundSignOnCheck.setState(this.core.getValue(BuddyCore.SOUND_LOGON, true));
        this.soundSignOffCheck.setState(this.core.getValue(BuddyCore.SOUND_LOGOFF, true));
        this.classCheck.setState(this.core.getValue(BuddyCore.SHOW_CLASS, true));
        this.evilCheck.setState(this.core.getValue(BuddyCore.SHOW_EVIL, false));
        this.idleCheck.setState(this.core.getValue(BuddyCore.SHOW_IDLE_TIME, false));
        this.signonCheck.setState(this.core.getValue(BuddyCore.SHOW_SIGNON_TIME, false));
        this.setChanged(false);
    }
}

