/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.AdminTool;
import component.AdminUI;
import component.AdminUIListener;
import component.StatusFrame;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import main.Oscar;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.ImageLabel;
import uiutil.TransparentPanel;

public class AdminEmailAddressUI
extends AdminUI
implements ActionListener,
AdminUIListener,
ComponentListener,
TextListener {
    private AdminTool admin;
    private TextField oldEmailField;
    private TextField newEmailField;
    private boolean dismiss = false;

    public AdminEmailAddressUI(AdminTool adminTool, String string) {
        super("Email Address", IUtil.format("The form below is for filing a change of email address. You will receive a confirmation request at your new email address. After you reply to the confirmation message, your change of address will be complete.", 60));
        this.admin = adminTool;
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(0, 1));
        TransparentPanel transparentPanel2 = new TransparentPanel(new FlowLayout(2));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new ImageLabel("Current Email Address:"));
        if (string == null) {
            string = "";
        }
        this.oldEmailField = new TextField(string, 24);
        transparentPanel2.add(this.oldEmailField);
        this.oldEmailField.setEditable(false);
        transparentPanel2 = new TransparentPanel(new FlowLayout(2));
        transparentPanel.add(transparentPanel2);
        transparentPanel2.add(new ImageLabel("New Email Address:"));
        this.newEmailField = new TextField(24);
        transparentPanel2.add(this.newEmailField);
        this.newEmailField.addActionListener(this);
        this.newEmailField.addComponentListener(this);
        this.newEmailField.addTextListener(this);
        this.setContents(transparentPanel);
        this.show();
        this.admin.addAdminUIListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.requestChange(true);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.newEmailField.requestFocus();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setNickname(String string) {
    }

    public void setEmailAddress(String string) {
        ((TextComponent)this.oldEmailField).setText(string);
        String string2 = this.newEmailField.getText();
        if (string2 == null || string2.length() == 0) {
            this.setChanged(false);
        }
    }

    public void setRegistrationStatus(int n) {
    }

    public void error(int n, String string, String string2) {
        this.changeFailed(n, string, string2);
    }

    public void changeSuccessful(int n, Object object) {
        if (n == 2) {
            this.setStatus(StatusFrame.STATUS_SUCCESS, "Change of email address sent.");
            IUtil.playSound(this.admin, "save");
            this.setChanged(false);
            if (this.dismiss) {
                ((Component)this).setVisible(false);
                this.dispose();
            }
        }
    }

    public void changeFailed(int n, String string, String string2) {
        if (n == 2) {
            this.setStatus(StatusFrame.STATUS_FAILURE, "Error: " + string, string2);
            IUtil.playSound(this.admin, "error");
            this.dismiss = false;
            this.setChanged(false);
        }
    }

    public void removeNotify() {
        this.removeAll();
        if (this.admin != null) {
            this.admin.removeAdminUIListener(this);
            this.admin = null;
        }
        this.oldEmailField = null;
        this.newEmailField = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void requestChange(boolean bl) {
        this.oldEmailField.getText();
        String string = this.newEmailField.getText();
        if (string == null || string.length() < 7) {
            ChoiceUI.newChoiceUI("Change Email Address", "Please provide a valid email address.", Oscar.WARNING_SOUND);
            return;
        }
        this.setStatus(StatusFrame.STATUS_WAITING, "Contacting server to file change of email address...");
        this.dismiss = bl;
        this.admin.changeEmailAddress(string);
    }

    public void textValueChanged(TextEvent textEvent) {
        this.setChanged(true);
    }
}

