/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class ZUtil
implements Serializable {
    private static double[] scratchDoubleArray = new double[8];
    private static final int OUT_LEFT = 1;
    private static final int OUT_TOP = 2;
    private static final int OUT_RIGHT = 4;
    private static final int OUT_BOTTOM = 8;

    public static BufferedImage createThumbnailImage(ZNode node, Dimension thumbnailSize) {
        double translateY;
        double translateX;
        double scale;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage image = graphicsConfiguration.createCompatibleImage((int)thumbnailSize.getWidth(), (int)thumbnailSize.getHeight(), 3);
        Graphics2D g2 = image.createGraphics();
        ZBounds nodeBounds = node.getGlobalBounds();
        if (thumbnailSize.getWidth() / nodeBounds.getWidth() < thumbnailSize.getHeight() / nodeBounds.getHeight()) {
            scale = thumbnailSize.getWidth() / nodeBounds.getWidth();
            translateX = -nodeBounds.getX();
            translateY = (thumbnailSize.getHeight() / scale - nodeBounds.getHeight()) / 2.0 - nodeBounds.getY();
        } else {
            scale = thumbnailSize.getHeight() / nodeBounds.getHeight();
            translateX = (thumbnailSize.getWidth() / scale - nodeBounds.getWidth()) / 2.0 - nodeBounds.getX();
            translateY = -nodeBounds.getY();
        }
        g2.scale(scale, scale);
        g2.translate(translateX, translateY);
        ZRenderContext context = new ZRenderContext(g2, nodeBounds, null, 3);
        node.render(context);
        return image;
    }

    public static boolean rectIntersectsLine(Rectangle2D rect, double x1, double y1, double x2, double y2) {
        int out2;
        int out1 = ZUtil.outcode(rect, x1, y1);
        if ((out1 & (out2 = ZUtil.outcode(rect, x2, y2))) != 0) {
            return false;
        }
        if (out1 == 0 || out2 == 0) {
            return true;
        }
        if ((out1 & 5) != 0) {
            double x = rect.getX();
            if ((out1 & 4) != 0) {
                x += rect.getWidth();
            }
            y1 += (x - x1) * (y2 - y1) / (x2 - x1);
            x1 = x;
        }
        if ((out1 & 0xA) != 0) {
            double y = rect.getY();
            if ((out1 & 8) != 0) {
                y += rect.getHeight();
            }
            x1 += (y - y1) * (x2 - x1) / (y2 - y1);
            y1 = y;
        }
        return ((out1 = ZUtil.outcode(rect, x1, y1)) & (out2 = ZUtil.outcode(rect, x2, y2))) == 0;
    }

    private static int outcode(Rectangle2D rect, double x, double y) {
        int out = 0;
        double rx = rect.getX();
        double ry = rect.getY();
        double rw = rect.getWidth();
        double rh = rect.getHeight();
        if (rw <= 0.0) {
            out |= 5;
        } else if (x < rx) {
            out |= 1;
        } else if (x > rx + rw) {
            out |= 4;
        }
        if (rh <= 0.0) {
            out |= 0xA;
        } else if (y < ry) {
            out |= 2;
        } else if (y > ry + rh) {
            out |= 8;
        }
        return out;
    }

    public static boolean rectIntersectsPolyline(Rectangle2D rect, double[] xp, double[] yp, double penWidth) {
        boolean picked = false;
        double width = 0.5 * penWidth + 0.5 * (0.5 * rect.getWidth() + 0.5 * rect.getHeight());
        double px = rect.getX() + 0.5 * rect.getWidth();
        double py = rect.getY() + 0.5 * rect.getHeight();
        int np = xp.length;
        if (np > 0) {
            double minSquareDist = np == 1 ? Line2D.ptSegDistSq(xp[0], yp[0], xp[0], yp[0], px, py) : Line2D.ptSegDistSq(xp[0], yp[0], xp[1], yp[1], px, py);
            int i = 1;
            while (i < np - 1) {
                double squareDist = Line2D.ptSegDistSq(xp[i], yp[i], xp[i + 1], yp[i + 1], px, py);
                if (squareDist < minSquareDist) {
                    minSquareDist = squareDist;
                }
                ++i;
            }
            if (minSquareDist <= width * width) {
                picked = true;
            }
        }
        return picked;
    }

    public static double angleBetweenPoints(Point2D pt, Point2D a, Point2D b) {
        return ZUtil.angleBetweenPoints(pt.getX(), pt.getY(), a.getX(), a.getY(), b.getX(), b.getY());
    }

    public static double angleBetweenPoints(double x, double y, double ax, double ay, double bx, double by) {
        double t2;
        Point2D.Double v1 = new Point2D.Double(ax - x, ay - y);
        Point2D.Double v2 = new Point2D.Double(bx - x, by - y);
        double z = ((Point2D)v1).getX() * ((Point2D)v2).getY() - ((Point2D)v1).getY() * ((Point2D)v2).getX();
        double s = z >= 0.0 ? 1.0 : -1.0;
        double t1 = Math.sqrt((x - ax) * (x - ax) + (y - ay) * (y - ay)) * Math.sqrt((x - bx) * (x - bx) + (y - by) * (y - by));
        double theta = t1 == 0.0 ? 0.0 : ((t2 = (((Point2D)v1).getX() * ((Point2D)v2).getX() + ((Point2D)v1).getY() * ((Point2D)v2).getY()) / t1) < -1.0 || t2 > 1.0 ? 0.0 : s * Math.acos(t2));
        return theta;
    }

    public static boolean intersectsPolygon(Rectangle2D rect, double[] xp, double[] yp) {
        boolean inside = false;
        int np = xp.length;
        inside = ZUtil.isInsidePolygon(rect.getX(), rect.getY(), np, xp, yp);
        if (!(inside || (inside = ZUtil.isInsidePolygon(rect.getX() + rect.getWidth(), rect.getY(), np, xp, yp)) || (inside = ZUtil.isInsidePolygon(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight(), np, xp, yp)) || (inside = ZUtil.isInsidePolygon(rect.getX(), rect.getY() + rect.getHeight(), np, xp, yp)))) {
            int i = 0;
            while (!inside && i < np - 1) {
                inside = ZUtil.rectIntersectsLine(rect, xp[i], yp[i], xp[i + 1], yp[i + 1]);
                ++i;
            }
            if (!inside) {
                inside = ZUtil.rectIntersectsLine(rect, xp[np - 1], yp[np - 1], xp[0], yp[0]);
            }
        }
        return inside;
    }

    public static boolean isInsidePolygon(double x, double y, int np, double[] xp, double[] yp) {
        double angle = 0.0;
        boolean inside = false;
        int i = 0;
        while (i < np - 1) {
            angle += ZUtil.angleBetweenPoints(x, y, xp[i], yp[i], xp[i + 1], yp[i + 1]);
            ++i;
        }
        inside = Math.abs(angle += ZUtil.angleBetweenPoints(x, y, xp[np - 1], yp[np - 1], xp[0], yp[0])) > 6.2;
        return inside;
    }

    public static boolean isInsidePolygon(Rectangle2D rect, int np, double[] xp, double[] yp) {
        double x = rect.getX();
        double y = rect.getY();
        double width = rect.getWidth();
        double height = rect.getHeight();
        boolean inside = ZUtil.isInsidePolygon(x, y, np, xp, yp) && ZUtil.isInsidePolygon(x + width, y, np, xp, yp) && ZUtil.isInsidePolygon(x, y + height, np, xp, yp) && ZUtil.isInsidePolygon(x + width, y + height, np, xp, yp);
        return inside;
    }

    public static double transformDimension(Dimension2D aDimension, AffineTransform aTransform) {
        double[] pts = scratchDoubleArray;
        pts[0] = aDimension.getWidth();
        pts[1] = aDimension.getHeight();
        aTransform.deltaTransform(pts, 0, pts, 0, 1);
        aDimension.setSize(pts[0], pts[1]);
        return Math.max(aTransform.getScaleX(), aTransform.getScaleX());
    }

    public static double inverseTransformDimension(Dimension2D aDimension, AffineTransform aTransform) throws NoninvertibleTransformException {
        double m10;
        double m01;
        double m11;
        double width = aDimension.getWidth();
        double height = aDimension.getHeight();
        double m00 = aTransform.getScaleX();
        double det = m00 * (m11 = aTransform.getScaleY()) - (m01 = aTransform.getShearX()) * (m10 = aTransform.getShearY());
        if (Math.abs(det) <= Double.MIN_VALUE) {
            throw new NoninvertibleTransformException("Determinant is " + det);
        }
        aDimension.setSize((width * m11 - height * m01) / det, (height * m00 - width * m10) / det);
        return 1.0 / Math.max(aTransform.getScaleX(), aTransform.getScaleX());
    }

    public static double inverseTransformRectangle(Rectangle2D aRectangle, AffineTransform aTransform) throws NoninvertibleTransformException {
        double[] pts = ZUtil.getRectPointsAsArray(aRectangle);
        aTransform.inverseTransform(pts, 0, pts, 0, 4);
        ZUtil.setRectFromPointsArray(aRectangle, pts);
        return 1.0 / Math.max(aTransform.getScaleX(), aTransform.getScaleX());
    }

    private static double[] getRectPointsAsArray(Rectangle2D aRectangle) {
        double[] pts = scratchDoubleArray;
        pts[0] = aRectangle.getX();
        pts[1] = aRectangle.getY();
        pts[2] = aRectangle.getX() + aRectangle.getWidth();
        pts[3] = aRectangle.getY();
        pts[4] = aRectangle.getX() + aRectangle.getWidth();
        pts[5] = aRectangle.getY() + aRectangle.getHeight();
        pts[6] = aRectangle.getX();
        pts[7] = aRectangle.getY() + aRectangle.getHeight();
        return pts;
    }

    private static void setRectFromPointsArray(Rectangle2D aRectangle, double[] pts) {
        double minX = pts[0];
        double minY = pts[1];
        double maxX = pts[0];
        double maxY = pts[1];
        int i = 1;
        while (i < 4) {
            if (pts[2 * i] < minX) {
                minX = pts[2 * i];
            }
            if (pts[2 * i + 1] < minY) {
                minY = pts[2 * i + 1];
            }
            if (pts[2 * i] > maxX) {
                maxX = pts[2 * i];
            }
            if (pts[2 * i + 1] > maxY) {
                maxY = pts[2 * i + 1];
            }
            ++i;
        }
        aRectangle.setRect(minX, minY, maxX - minX, maxY - minY);
    }

    static {
        OUT_LEFT = 1;
        OUT_TOP = 2;
        OUT_RIGHT = 4;
        OUT_BOTTOM = 8;
    }
}

