/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZSelectionManager;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZSceneGraphPropertyPanel;
import edu.umd.cs.jazz.util.ZSceneGraphTreeModel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ZSceneGraphTreeView
extends JFrame
implements ActionListener,
TreeSelectionListener {
    ZCanvas canvas;
    ZCamera camera;
    ZDrawingSurface surface;
    JTree tree;
    JTextArea text;
    JPanel scrollPanel;
    ZSceneGraphPropertyPanel propertyPanel;
    ZSceneGraphTreeModel model;

    public ZSceneGraphTreeView(ZCanvas aCanvas) {
        super("Scenegraph Tree View");
        this.canvas = aCanvas;
        this.camera = this.canvas.getCamera();
        this.surface = this.canvas.getDrawingSurface();
        JSplitPane pane = new JSplitPane(0);
        this.tree = new JTree();
        this.tree.getSelectionModel().setSelectionMode(4);
        this.tree.addTreeSelectionListener(this);
        JScrollPane scroll = new JScrollPane(this.tree);
        pane.add(scroll);
        scroll.setPreferredSize(new Dimension(300, 300));
        this.propertyPanel = new ZSceneGraphPropertyPanel();
        scroll = new JScrollPane(this.propertyPanel);
        pane.add(scroll);
        scroll.setPreferredSize(new Dimension(300, 300));
        Container p = this.getContentPane();
        p.setLayout(new BorderLayout());
        p.add("Center", pane);
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu("File");
        m.setMnemonic('F');
        this.add(m, "Close", 'x');
        mb.add(m);
        m = new JMenu("Item");
        m.setMnemonic('I');
        this.add(m, "Info", 'I');
        this.add(m, "Select In Main View", 'S');
        this.add(m, "Center In Main View", 'O');
        mb.add(m);
        m = new JMenu("View");
        m.setMnemonic('V');
        this.add(m, "Refresh", 'R');
        this.add(m, "Update Selection", 'S');
        mb.add(m);
        this.setJMenuBar(mb);
        this.setRoot(this.canvas.getRoot());
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand().intern();
        if (cmd == "Close") {
            this.dispose();
        } else if (cmd == "Info") {
            this.showInfo();
        } else if (cmd == "Select In Main View") {
            this.selectNodes();
        } else if (cmd == "Center In Main View") {
            this.showNodes();
        } else if (cmd == "Refresh") {
            this.model.fireTreeStructureChanged();
        } else if (cmd == "Update Selection") {
            this.updateSelection();
        }
    }

    public void add(JMenu m, String command, char mnemonic) {
        JMenuItem mc = m.add(command);
        mc.addActionListener(this);
        mc.setMnemonic(mnemonic);
    }

    public Object[] getSelectedObjects() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        Object[] objects = new Object[paths.length];
        int i = 0;
        while (i < paths.length) {
            objects[i] = this.model.getJazzObject(paths[i].getLastPathComponent());
            ++i;
        }
        return objects;
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object[] objects = this.getSelectedObjects();
        if (objects != null) {
            try {
                this.propertyPanel.setTarget(objects);
            }
            catch (Throwable t) {
                System.err.println("Property Panel: " + t);
            }
        }
    }

    public void setRoot(ZRoot root) {
        this.model = new ZSceneGraphTreeModel(root);
        this.tree.setModel(this.model);
    }

    public void showInfo() {
        Object selected = this.tree.getLastSelectedPathComponent();
        if (selected != null) {
            ZSceneGraphObject obj = this.model.getJazzObject(this.tree.getLastSelectedPathComponent());
            new InfoPopup((Frame)this, obj);
        }
    }

    public void showNodes() {
        Object[] selected = this.getSelectedObjects();
        if (selected != null) {
            ZBounds b = new ZBounds();
            int i = 0;
            while (i < selected.length) {
                ZSceneGraphObject obj = (ZSceneGraphObject)selected[i];
                if (obj instanceof ZVisualComponent) {
                    obj = ((ZVisualComponent)obj).getParents()[0];
                }
                if (obj instanceof ZNode) {
                    b.add(((ZNode)obj).getGlobalBounds());
                }
                ++i;
            }
            if (!b.isEmpty()) {
                this.camera.center(b, 1000, this.surface);
            }
        }
    }

    public void selectNodes() {
        ZSelectionManager.unselectAll(this.camera);
        Object[] selected = this.getSelectedObjects();
        if (selected != null) {
            int i = 0;
            while (i < selected.length) {
                ZSceneGraphObject obj = (ZSceneGraphObject)selected[i];
                if (obj instanceof ZVisualComponent) {
                    obj = ((ZVisualComponent)obj).getParents()[0];
                }
                if (obj instanceof ZNode) {
                    ZSelectionManager.select((ZNode)obj);
                }
                ++i;
            }
        }
        this.showNodes();
    }

    public void updateSelection() {
        this.model.fireTreeStructureChanged();
        ArrayList selected = ZSelectionManager.getSelectedNodes(this.canvas.getRoot());
        this.tree.clearSelection();
        if (selected.size() > 0) {
            int i = 0;
            while (i < selected.size()) {
                ZNode n = (ZNode)selected.get(i);
                TreePath tp = this.model.getTreePath(n);
                this.tree.addSelectionPath(tp);
                ++i;
            }
        }
        this.propertyPanel.setTarget(selected.toArray());
    }

    static class InfoPopup
    extends JDialog
    implements ActionListener {
        InfoPopup(Frame frame, ZSceneGraphObject node) {
            super(frame, "Node Info", true);
            this.getContentPane().setLayout(new BorderLayout());
            JTextArea text = new JTextArea();
            text.setText(ZDebug.dumpString(node, false));
            this.getContentPane().add("Center", new JScrollPane(text));
            JButton doneButton = new JButton("OK");
            doneButton.addActionListener(this);
            this.getContentPane().add("South", doneButton);
            this.pack();
            this.show();
        }

        public void actionPerformed(ActionEvent evt) {
            this.dispose();
        }
    }
}

