/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ZSceneGraphPropertyPanel
extends JPanel
implements PropertyChangeListener {
    private Object[] targets;
    private ObjectInfo[] objectInfo;
    private PropertyDisplay[] props;
    private boolean processEvents;
    private static HashMap infoMap = new HashMap();

    public ZSceneGraphPropertyPanel() {
        this.setLayout(new BoxLayout(this, 1));
    }

    synchronized void setCustomizer(Customizer c) {
        if (c != null) {
            c.addPropertyChangeListener(this);
        }
    }

    synchronized void setTarget(Object[] targets) {
        this.processEvents = false;
        this.setVisible(false);
        this.removeAll();
        this.targets = targets;
        if (targets == null || targets.length == 0) {
            this.setVisible(true);
            return;
        }
        this.objectInfo = new ObjectInfo[targets.length];
        int i = 0;
        while (i < targets.length) {
            this.objectInfo[i] = new ObjectInfo(targets[i]);
            ++i;
        }
        this.unify();
        this.add(new JLabel(""));
        this.setVisible(true);
        this.revalidate();
        this.processEvents = true;
    }

    private void unify() {
        ArrayList<PropertyDisplay> props = new ArrayList<PropertyDisplay>();
        ObjectInfo info = this.objectInfo[0];
        int i = 0;
        while (i < info.getNumProperties()) {
            String name = info.getPropertyName(i);
            Class type = info.getEditorType(i);
            int[] propertyIndex = new int[this.objectInfo.length];
            propertyIndex[0] = i;
            int j = 1;
            while (j < this.objectInfo.length) {
                int index = this.objectInfo[j].findProperty(name, type);
                if (index == -1) {
                    propertyIndex = null;
                    break;
                }
                propertyIndex[j] = index;
                ++j;
            }
            if (propertyIndex != null) {
                PropertyDisplay p = new PropertyDisplay(propertyIndex);
                props.add(p);
            }
            ++i;
        }
        this.props = props.toArray(new PropertyDisplay[props.size()]);
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (!this.processEvents) {
            return;
        }
        if (evt.getSource() instanceof PropertyEditor) {
            PropertyEditor editor = (PropertyEditor)evt.getSource();
            int i = 0;
            while (i < this.props.length) {
                if (this.props[i].getPropertyEditor(0) == editor) {
                    this.props[i].editorValueChanged(editor.getValue());
                    break;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.props.length) {
            this.props[i].refresh();
            ++i;
        }
    }

    private static void error(String message, Throwable th) {
        String mess = message + ":\n" + th;
        System.err.println(message);
    }

    private class PropertyDisplay {
        int[] propertyIndex;
        JLabel label;
        JComponent view;

        PropertyDisplay(int[] propertyIndex) {
            this.propertyIndex = propertyIndex;
            PropertyEditor editor = this.getPropertyEditor(0);
            String name = this.getPropertyName(0);
            this.label = new JLabel(name);
            if (editor.isPaintable() && editor.supportsCustomEditor()) {
                this.view = new PaintedProp(this);
            } else if (editor.getTags() != null) {
                this.view = new ComboProp(this);
            } else if (editor.getAsText() != null) {
                String init = editor.getAsText();
                this.view = new TextProp(this);
            } else {
                System.err.println("Warning: Property \"" + name + "\" has non-displayabale editor.  Skipping.");
                return;
            }
            ZSceneGraphPropertyPanel.this.add(this.label);
            ZSceneGraphPropertyPanel.this.add(this.view);
            editor.addPropertyChangeListener(ZSceneGraphPropertyPanel.this);
        }

        int getRowHeight() {
            return (int)((double)this.label.getPreferredSize().height * 1.5);
        }

        boolean hasSingleValue() {
            Object value = this.getPropertyEditor(0).getValue();
            int i = 1;
            while (i < ZSceneGraphPropertyPanel.this.objectInfo.length) {
                PropertyEditor editor = this.getPropertyEditor(i);
                if (!editor.getValue().equals(value)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        boolean multipleObjects() {
            return ZSceneGraphPropertyPanel.this.objectInfo.length > 1;
        }

        String getAsText() {
            if (this.hasSingleValue()) {
                return this.getPropertyEditor(0).getAsText();
            }
            return "";
        }

        void setAsText(String value) {
            this.getPropertyEditor(0).setAsText(value);
        }

        void editorValueChanged(Object value) {
            int i = 0;
            while (i < ZSceneGraphPropertyPanel.this.objectInfo.length) {
                ZSceneGraphPropertyPanel.this.objectInfo[i].setPropertyValue(this.propertyIndex[i], value);
                ++i;
            }
            int i2 = 1;
            while (i2 < ZSceneGraphPropertyPanel.this.objectInfo.length) {
                ZSceneGraphPropertyPanel.this.objectInfo[i2].getPropertyEditor(this.propertyIndex[i2]).setValue(value);
                ++i2;
            }
            if (this.view instanceof PaintedProp) {
                this.view.repaint();
            }
        }

        void refresh() {
            int i = 0;
            while (i < ZSceneGraphPropertyPanel.this.objectInfo.length) {
                ObjectInfo info = ZSceneGraphPropertyPanel.this.objectInfo[i];
                if (info.refreshPropertyValue(this.propertyIndex[i])) {
                    if (this.view instanceof TextProp) {
                        ((TextProp)this.view).setText(this.getAsText());
                    } else if (this.view instanceof ComboProp) {
                        ((ComboProp)this.view).setSelectedItem(this.getAsText());
                    } else if (this.view instanceof PaintedProp) {
                        this.view.repaint();
                    }
                }
                ++i;
            }
        }

        PropertyEditor getPropertyEditor(int i) {
            return ZSceneGraphPropertyPanel.this.objectInfo[i].getPropertyEditor(this.propertyIndex[i]);
        }

        String getPropertyName(int i) {
            return ZSceneGraphPropertyPanel.this.objectInfo[i].getPropertyName(this.propertyIndex[i]);
        }
    }

    private static class ObjectInfo {
        Object target;
        PropertyDescriptor[] properties;
        PropertyEditor[] editors;
        Object[] values;
        int numProperties;

        ObjectInfo(Object target) {
            this.target = target;
            ObjectInfo prototype = (ObjectInfo)infoMap.get(target.getClass());
            if (prototype == null) {
                prototype = new ObjectInfo(target.getClass());
                infoMap.put(target.getClass(), prototype);
            }
            this.numProperties = prototype.numProperties;
            this.properties = new PropertyDescriptor[this.numProperties];
            this.editors = new PropertyEditor[this.numProperties];
            this.values = new Object[this.numProperties];
            int n = 0;
            int i = 0;
            while (i < this.numProperties) {
                PropertyDescriptor property = prototype.properties[i];
                PropertyEditor editor = prototype.editors[i];
                String name = property.getDisplayName();
                Method getter = property.getReadMethod();
                try {
                    editor = (PropertyEditor)editor.getClass().newInstance();
                    Object[] args = new Object[]{};
                    Object value = getter.invoke(target, args);
                    if (value == null) {
                        String getterClass = getter.getDeclaringClass().getName();
                        if (getterClass.indexOf("java.") != 0) {
                            System.err.println("Warning: Property \"" + name + "\" has null initial value.  Skipping.");
                        }
                    } else {
                        this.properties[n] = property;
                        this.values[n] = value;
                        this.editors[n] = editor;
                        editor.setValue(value);
                        ++n;
                    }
                }
                catch (InvocationTargetException ex) {
                    System.err.println("Skipping property " + name + " ; exception on target: " + ex.getTargetException());
                }
                catch (Exception ex) {
                    System.err.println("Skipping property " + name + " ; exception: " + ex);
                }
                ++i;
            }
            this.numProperties = n;
        }

        ObjectInfo(Class targetClass) {
            try {
                BeanInfo bi = Introspector.getBeanInfo(targetClass);
                this.properties = bi.getPropertyDescriptors();
            }
            catch (IntrospectionException ex) {
                ZSceneGraphPropertyPanel.error("PropertySheet: Couldn't introspect ", ex);
                return;
            }
            this.editors = new PropertyEditor[this.properties.length];
            int n = 0;
            int i = 0;
            while (i < this.properties.length) {
                PropertyDescriptor property = this.properties[i];
                if (!property.isHidden() && !property.isExpert()) {
                    String name = property.getDisplayName();
                    Class<?> type = property.getPropertyType();
                    Method getter = property.getReadMethod();
                    Method setter = property.getWriteMethod();
                    if (getter != null && setter != null) {
                        try {
                            PropertyEditor editor = null;
                            Class<?> pec = property.getPropertyEditorClass();
                            if (pec != null) {
                                try {
                                    editor = (PropertyEditor)pec.newInstance();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            if (editor == null) {
                                editor = PropertyEditorManager.findEditor(type);
                            }
                            if (editor == null) {
                                String getterClass = getter.getDeclaringClass().getName();
                                if (getterClass.indexOf("java.") != 0) {
                                    System.err.println("Warning: Can't find public property editor for property \"" + name + "\".  Skipping.");
                                }
                            } else {
                                this.properties[n] = property;
                                this.editors[n] = editor;
                                ++n;
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("Skipping property " + name + " ; exception: " + ex);
                        }
                    }
                }
                ++i;
            }
            this.numProperties = n;
        }

        int getNumProperties() {
            return this.numProperties;
        }

        String getPropertyName(int i) {
            return this.properties[i].getDisplayName();
        }

        Class getEditorType(int i) {
            return this.editors[i].getClass();
        }

        PropertyEditor getPropertyEditor(int i) {
            return this.editors[i];
        }

        void setPropertyValue(int i, Object value) {
            this.values[i] = value;
            Method setter = this.properties[i].getWriteMethod();
            try {
                Object[] args = new Object[]{value};
                args[0] = value;
                setter.invoke(this.target, args);
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof PropertyVetoException) {
                    System.err.println("WARNING: Vetoed; reason is: " + ex.getTargetException().getMessage());
                } else {
                    ZSceneGraphPropertyPanel.error("InvocationTargetException while updating " + this.properties[i].getName(), ex.getTargetException());
                }
            }
            catch (Exception ex) {
                ZSceneGraphPropertyPanel.error("Unexpected exception while updating " + this.properties[i].getName(), ex);
            }
        }

        boolean refreshPropertyValue(int i) {
            Object o;
            try {
                Method getter = this.properties[i].getReadMethod();
                Object[] args = new Object[]{};
                o = getter.invoke(this.target, args);
            }
            catch (Exception ex) {
                o = null;
            }
            if (o == this.values[i] || o != null && o.equals(this.values[i])) {
                return false;
            }
            this.editors[i].setValue(o);
            this.values[i] = o;
            return true;
        }

        int findProperty(String name, Class type) {
            int i = 0;
            while (i < this.numProperties) {
                if (this.editors[i].getClass() == type && this.properties[i].getDisplayName().equals(name)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    private static class ComboProp
    extends JComboBox
    implements ItemListener {
        PropertyDisplay display;

        ComboProp(PropertyDisplay pd) {
            this.display = pd;
            String[] tags = pd.getPropertyEditor(0).getTags();
            if (this.display.multipleObjects()) {
                this.addItem("");
            }
            int i = 0;
            while (i < tags.length) {
                this.addItem(tags[i]);
                ++i;
            }
            if (pd.getAsText() != null) {
                this.setSelectedItem(pd.getAsText());
            }
            this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent evt) {
            String s = (String)this.getSelectedItem();
            if (s != null && this.display != null && !s.equals("")) {
                this.display.setAsText(s);
            }
        }
    }

    private static class TextProp
    extends JTextField
    implements KeyListener,
    FocusListener {
        private PropertyDisplay display;

        TextProp(PropertyDisplay pd) {
            super(pd.getAsText());
            this.display = pd;
            this.addKeyListener(this);
            this.addFocusListener(this);
        }

        public Dimension getMaximumSize() {
            Dimension sz = this.getPreferredSize();
            sz.width = 10000;
            return sz;
        }

        protected void updateEditor() {
            try {
                if (this.display != null) {
                    this.display.setAsText(this.getText());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void focusLost(FocusEvent e) {
            this.updateEditor();
        }

        public void focusGained(FocusEvent e) {
            if (this.display != null) {
                this.setText(this.display.getAsText());
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.updateEditor();
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private static class PaintedProp
    extends JComponent
    implements MouseListener {
        private PropertyDisplay display;
        private static boolean ignoreClick = false;

        PaintedProp(PropertyDisplay pd) {
            this.display = pd;
            this.setBorder(BorderFactory.createEtchedBorder());
            this.addMouseListener(this);
        }

        Frame getFrame() {
            Container p = this.getTopLevelAncestor();
            while (p != null) {
                if (p instanceof Frame) {
                    return (Frame)p;
                }
                p = p.getParent();
            }
            return null;
        }

        public Dimension getPreferredSize() {
            int h = this.display.getRowHeight();
            return new Dimension(h, h);
        }

        public Dimension getMaximumSize() {
            int h = this.display.getRowHeight();
            return new Dimension(10000, h);
        }

        public void paint(Graphics g) {
            Dimension sz = this.getSize();
            if (this.display.hasSingleValue()) {
                Rectangle box = new Rectangle(4, 2, sz.width - 6, sz.height - 4);
                this.display.getPropertyEditor(0).paintValue(g, box);
            }
            this.getBorder().paintBorder(this, g, 2, 0, sz.width - 2, sz.height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent evt) {
            if (!ignoreClick) {
                try {
                    ignoreClick = true;
                    Frame frame = this.getFrame();
                    int x = frame.getLocation().x - 30;
                    int y = frame.getLocation().y + 50;
                    new PopupProp(frame, this.display.getPropertyEditor(0), x, y);
                    Object var6_5 = null;
                    ignoreClick = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    ignoreClick = false;
                    throw throwable;
                }
            }
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }
    }

    private static class PopupProp
    extends JDialog
    implements ActionListener {
        private JButton doneButton;
        private Component body;
        private static final int vPad = 5;
        private static final int hPad = 4;

        PopupProp(Frame frame, PropertyEditor pe, int x, int y) {
            super(frame, pe.getClass().getName(), true);
            this.getContentPane().setLayout(new BorderLayout());
            this.body = pe.getCustomEditor();
            this.getContentPane().add("Center", this.body);
            this.doneButton = new JButton("OK");
            this.doneButton.addActionListener(this);
            this.getContentPane().add("South", this.doneButton);
            this.setLocation(x, y);
            this.pack();
            this.show();
        }

        public void actionPerformed(ActionEvent evt) {
            this.dispose();
        }

        static {
            vPad = 5;
            hPad = 4;
        }
    }
}

