/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.util;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.event.ZCameraEvent;
import edu.umd.cs.jazz.event.ZCameraListener;
import edu.umd.cs.jazz.event.ZNodeEvent;
import edu.umd.cs.jazz.event.ZNodeListener;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZScrollDirector;
import edu.umd.cs.jazz.util.ZScrollPane;
import edu.umd.cs.jazz.util.ZViewport;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ZDefaultScrollDirector
implements ZScrollDirector,
ZCameraListener,
ZNodeListener {
    protected ZViewport viewPort;
    protected ZScrollPane scrollPane;
    protected ZCanvas view;
    protected ZCamera camera;
    protected ZRoot root;
    protected boolean scrollInProgress = false;

    public void install(ZViewport viewPort, ZCanvas view) {
        this.scrollPane = (ZScrollPane)viewPort.getParent();
        this.viewPort = viewPort;
        this.view = view;
        if (view != null) {
            this.camera = view.getCamera();
            this.root = view.getRoot();
        }
        if (this.camera != null) {
            this.camera.addCameraListener(this);
        }
        if (this.root != null) {
            this.root.addNodeListener(this);
        }
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
        }
    }

    public void unInstall() {
        this.viewPort = null;
        this.view = null;
        if (this.camera != null) {
            this.camera.removeCameraListener(this);
        }
        if (this.root != null) {
            this.root.removeNodeListener(this);
        }
        this.camera = null;
        this.root = null;
    }

    public Point getViewPosition(Rectangle2D viewBounds) {
        Point pos = new Point();
        if (this.camera != null) {
            ZBounds layerBounds = new ZBounds();
            ZLayerGroup[] layers = this.camera.getLayersReference();
            int i = 0;
            while (i < this.camera.getNumLayers()) {
                layerBounds.add(layers[i].getBoundsReference());
                ++i;
            }
            this.camera.localToCamera(layerBounds, null);
            layerBounds.add(viewBounds);
            pos.setLocation((int)(viewBounds.getX() - layerBounds.getX() + 0.5), (int)(viewBounds.getY() - layerBounds.getY() + 0.5));
        }
        return pos;
    }

    public Dimension getViewSize(Rectangle2D viewBounds) {
        Dimension size = new Dimension();
        if (this.camera != null) {
            ZBounds bounds = new ZBounds();
            ZLayerGroup[] layers = this.camera.getLayersReference();
            int i = 0;
            while (i < this.camera.getNumLayers()) {
                bounds.add(layers[i].getBoundsReference());
                ++i;
            }
            this.camera.localToCamera(bounds, null);
            bounds.add(viewBounds);
            size.setSize((int)(bounds.getWidth() + 0.5), (int)(bounds.getHeight() + 0.5));
        }
        return size;
    }

    public void setViewPosition(double x, double y) {
        if (this.camera != null && !this.scrollInProgress) {
            this.scrollInProgress = true;
            ZBounds layerBounds = new ZBounds();
            ZLayerGroup[] layers = this.camera.getLayersReference();
            int i = 0;
            while (i < this.camera.getNumLayers()) {
                layerBounds.add(layers[i].getBoundsReference());
                ++i;
            }
            AffineTransform at = this.camera.getViewTransform();
            ZTransformGroup.transform(layerBounds, at);
            ZBounds viewBounds = this.camera.getBounds();
            layerBounds.add(viewBounds);
            Point2D.Double newPoint = new Point2D.Double(layerBounds.getX() + x, layerBounds.getY() + y);
            this.camera.cameraToLocal(newPoint, null);
            double newX = -(at.getScaleX() * ((Point2D)newPoint).getX() + at.getShearX() * ((Point2D)newPoint).getY());
            double newY = -(at.getShearY() * ((Point2D)newPoint).getX() + at.getScaleY() * ((Point2D)newPoint).getY());
            at.setTransform(at.getScaleX(), at.getShearY(), at.getShearX(), at.getScaleY(), newX, newY);
            this.camera.setViewTransform(at);
            this.scrollInProgress = false;
        }
    }

    public void viewChanged(ZCameraEvent e) {
        if (this.shouldRevalidateScrollPane()) {
            this.scrollPane.revalidate();
        } else {
            this.viewPort.fireStateChanged();
        }
    }

    public void boundsChanged(ZNodeEvent e) {
        if (this.shouldRevalidateScrollPane()) {
            this.scrollPane.revalidate();
        } else {
            this.viewPort.fireStateChanged();
        }
    }

    public void globalBoundsChanged(ZNodeEvent e) {
    }

    public boolean shouldRevalidateScrollPane() {
        if (this.camera != null) {
            ZBounds layerBounds = new ZBounds();
            ZLayerGroup[] layers = this.camera.getLayersReference();
            int i = 0;
            while (i < this.camera.getNumLayers()) {
                layerBounds.add(layers[i].getBoundsReference());
                ++i;
            }
            this.camera.localToCamera(layerBounds, null);
            ZBounds cameraBounds = this.camera.getBoundsReference();
            layerBounds.add(cameraBounds);
            int layerWidth = (int)(layerBounds.getWidth() + 0.5);
            int layerHeight = (int)(layerBounds.getHeight() + 0.5);
            int cameraWidth = (int)(cameraBounds.getWidth() + 0.5);
            int cameraHeight = (int)(cameraBounds.getHeight() + 0.5);
            if (this.scrollPane.getHorizontalScrollBar().isShowing() && layerWidth <= cameraWidth || !this.scrollPane.getHorizontalScrollBar().isShowing() && layerWidth > cameraWidth || this.scrollPane.getVerticalScrollBar().isShowing() && layerHeight <= cameraHeight || !this.scrollPane.getVerticalScrollBar().isShowing() && layerHeight > cameraHeight) {
                return true;
            }
        }
        return false;
    }
}

