/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.io;

import edu.umd.cs.jazz.io.ZExtendedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ZStreamPreprocessor
implements Serializable {
    protected ZExtendedInputStream data;
    protected StringBuffer out;
    protected int bufSize = 64;
    protected String binaryMarker = "BINARYDATAFOLLOWS";
    protected int bmLength = this.binaryMarker.length();
    protected byte[] bmBytes = ("\t" + this.binaryMarker + " ").getBytes();
    protected byte[] buffer = new byte[this.bufSize];

    public ZStreamPreprocessor(ZExtendedInputStream data) {
        this.data = data;
    }

    protected boolean isWhiteSpace(byte b) {
        return b == 32 || b == 9 || b == 12 || b == 13 || b == 10 || b == 9;
    }

    protected boolean isEOL(byte b) {
        return b == 13 || b == 10;
    }

    protected void handleBinaryData(OutputStream captureBuf, int bytesInBuffer, int markerPosInBuffer) throws IOException {
        byte[] tmp = new byte[2];
        StringBuffer byteCount = new StringBuffer();
        if (bytesInBuffer < this.bufSize) {
            this.data.skip(-bytesInBuffer);
        } else {
            this.data.skip(-this.bufSize);
        }
        this.data.skip(markerPosInBuffer + this.bmLength);
        captureBuf.write(this.bmBytes);
        while (true) {
            this.data.read(tmp, 0, 1);
            if (!this.isWhiteSpace(tmp[0])) break;
            captureBuf.write(tmp[0]);
        }
        this.data.skip(-1L);
        while (true) {
            this.data.read(tmp, 0, 1);
            if (this.isWhiteSpace(tmp[0])) break;
            captureBuf.write(tmp[0]);
        }
        this.data.skip(-1L);
        while (true) {
            this.data.read(tmp, 0, 1);
            if (!this.isWhiteSpace(tmp[0])) break;
            captureBuf.write(tmp[0]);
        }
        this.data.skip(-1L);
        while (true) {
            this.data.read(tmp, 0, 1);
            if (this.isWhiteSpace(tmp[0])) break;
            byteCount.append((char)tmp[0]);
            captureBuf.write(tmp[0]);
        }
        String offset = " " + this.data.getFilePosition();
        captureBuf.write(offset.getBytes());
        long skipAmmount = Long.parseLong(byteCount.toString());
        this.data.skip(skipAmmount);
    }

    public byte[] getBytes(int offset, int length) {
        byte[] result = new byte[length];
        try {
            this.data.setFilePosition(offset);
            this.data.read(result, 0, length);
        }
        catch (IOException e) {
            System.out.println("StreamPreprocessor.getBytes: Exception caught while trying to position data stream");
        }
        return result;
    }

    public InputStream preprocessStream() {
        ByteArrayOutputStream captureBuf = new ByteArrayOutputStream();
        try {
            int count;
            do {
                if ((count = this.data.read(this.buffer, 0, this.bufSize)) == -1) continue;
                String str = new String(this.buffer, 0, count);
                int markerFound = str.indexOf(this.binaryMarker);
                if (markerFound != -1) {
                    captureBuf.write(str.substring(0, markerFound).getBytes());
                    this.handleBinaryData(captureBuf, count, markerFound);
                    continue;
                }
                if (count <= this.bmLength) {
                    captureBuf.write(str.substring(0, count).getBytes());
                    continue;
                }
                captureBuf.write(str.substring(0, Math.max(count - this.bmLength, 0)).getBytes());
                if (count <= this.bmLength) continue;
                this.data.skip(-this.bmLength);
            } while (count != -1);
        }
        catch (Exception e) {
            System.out.println("exception caught :" + e);
        }
        return new ByteArrayInputStream(captureBuf.toByteArray());
    }

    public static final void main(String[] args) {
        try {
            FileInputStream in = new FileInputStream("test5.jazz");
            ZExtendedInputStream extendedIn = new ZExtendedInputStream(in);
            ZStreamPreprocessor sp = new ZStreamPreprocessor(extendedIn);
            sp.preprocessStream();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

