/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZBasicVisualComponent;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class ZShape
extends ZBasicVisualComponent {
    private static AffineTransform sharedTempTransform = new AffineTransform();

    public abstract Shape getShape();

    public double getX() {
        return this.getFrame().getX();
    }

    public double getY() {
        return this.getFrame().getY();
    }

    public double getWidth() {
        return this.getFrame().getWidth();
    }

    public double getHeight() {
        return this.getFrame().getHeight();
    }

    public Rectangle2D getFrame() {
        Shape shape = this.getShape();
        if (shape != null) {
            return shape.getBounds2D();
        }
        return new Rectangle2D.Double();
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.pickBounds(rect)) {
            double currentPenWidth = this.getPenWidthForCurrentContext();
            if (this.fillPaint != null && this.getShape().intersects(rect)) {
                return true;
            }
            return this.penPaint != null && this.pickStroke(rect, currentPenWidth);
        }
        return false;
    }

    protected boolean pickStroke(Rectangle2D aRect, double aPenWidth) {
        if (this.penPaint == null) {
            return false;
        }
        double px = aRect.getX() + 0.5 * aRect.getWidth();
        double py = aRect.getY() + 0.5 * aRect.getHeight();
        double minSquareDist = 0.5 * aPenWidth + 0.5 * (0.5 * aRect.getWidth() + 0.5 * aRect.getHeight());
        boolean isFirstSegment = true;
        double firstX = 0.0;
        double firstY = 0.0;
        double currentX = 0.0;
        double currentY = 0.0;
        double lastX = 0.0;
        double lastY = 0.0;
        double[] cs = new double[6];
        AffineTransform aTransform = null;
        if (this.absPenWidth) {
            aTransform = this.getStrokeTransformForAbsPenWidth(aPenWidth);
        }
        FlatteningPathIterator i = new FlatteningPathIterator(this.getShape().getPathIterator(aTransform), 1.0);
        while (!i.isDone()) {
            switch (i.currentSegment(cs)) {
                case 1: {
                    lastX = currentX;
                    lastY = currentY;
                    currentX = cs[0];
                    currentY = cs[1];
                    double squareDist = Line2D.ptSegDist(lastX, lastY, currentX, currentY, px, py);
                    if (!(squareDist <= minSquareDist)) break;
                    return true;
                }
                case 0: {
                    currentX = cs[0];
                    currentY = cs[1];
                    break;
                }
                case 4: {
                    lastX = currentX;
                    lastY = currentY;
                    currentX = firstX;
                    currentY = firstY;
                    double squareDist = Line2D.ptSegDist(lastX, lastY, currentX, currentY, px, py);
                    if (!(squareDist <= minSquareDist)) break;
                    return true;
                }
            }
            if (isFirstSegment) {
                firstX = cs[0];
                firstY = cs[1];
                isFirstSegment = false;
            }
            i.next();
        }
        return false;
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        if (this.fillPaint != null) {
            g2.setPaint(this.fillPaint);
            g2.fill(this.getShape());
        }
        if (this.penPaint != null) {
            if (this.absPenWidth) {
                double pw = this.penWidth / renderContext.getCompositeMagnification();
                AffineTransform saveTransform = g2.getTransform();
                AffineTransform newTransform = this.getStrokeTransformForAbsPenWidth(pw);
                double scale = newTransform.getScaleX();
                if (scale <= 0.0) {
                    g2.setPaint(this.penPaint);
                    g2.fill(this.getBoundsReference());
                    return;
                }
                g2.transform(newTransform);
                this.stroke = this.stroke != null ? new BasicStroke((float)pw, this.stroke.getEndCap(), this.stroke.getLineJoin()) : new BasicStroke((float)(pw *= 1.0 / scale), 0, 2);
                g2.setStroke(this.stroke);
                g2.setPaint(this.penPaint);
                g2.draw(this.getShape());
                g2.setTransform(saveTransform);
            } else {
                g2.setStroke(this.stroke);
                g2.setPaint(this.penPaint);
                g2.draw(this.getShape());
            }
        }
    }

    protected AffineTransform getStrokeTransformForAbsPenWidth(double aPenWidth) {
        double scale = (this.bounds.getWidth() - aPenWidth) / this.bounds.getWidth();
        Point2D center = this.bounds.getCenter2D();
        sharedTempTransform.setToIdentity();
        sharedTempTransform.translate(center.getX(), center.getY());
        sharedTempTransform.scale(scale, scale);
        sharedTempTransform.translate(-center.getX(), -center.getY());
        return sharedTempTransform;
    }

    protected void computeBounds() {
        this.bounds.reset();
        Rectangle2D shapeBounds = this.getFrame();
        double aPenWidth = this.getPenWidth();
        double aHalfPenWidth = aPenWidth * 0.5;
        this.bounds.setRect(shapeBounds.getX() - aHalfPenWidth, shapeBounds.getY() - aHalfPenWidth, shapeBounds.getWidth() + aPenWidth, shapeBounds.getHeight() + aPenWidth);
    }
}

