/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZCoordList;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ZPolyline
extends ZCoordList {
    public static final int ARROW_NONE = 0;
    public static final int ARROW_FIRST = 1;
    public static final int ARROW_LAST = 2;
    public static final int ARROW_BOTH = 3;
    public static final int ARROW_CLOSED = 0;
    public static final int ARROW_OPEN = 1;
    private int arrowHead = 0;
    private transient GeneralPath firstArrowHead = null;
    private transient GeneralPath lastArrowHead = null;
    private transient Point2D firstArrowHeadPoint = null;
    private transient Point2D lastArrowHeadPoint = null;
    private int arrowHeadType = 1;

    public ZPolyline() {
    }

    public ZPolyline(Point2D aPoint) {
        this(aPoint.getX(), aPoint.getY());
    }

    public ZPolyline(Point2D pt1, Point2D pt2) {
        this(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    public ZPolyline(double x, double y) {
        this.moveTo(x, y);
    }

    public ZPolyline(double x1, double y1, double x2, double y2) {
        this.moveTo(x1, y1);
        this.lineTo(x2, y2);
    }

    public ZPolyline(double[] xp, double[] yp) {
        this.setCoords(xp, yp);
    }

    protected Object duplicateObject() {
        ZPolyline newPoly = (ZPolyline)super.duplicateObject();
        if (this.firstArrowHead != null) {
            newPoly.firstArrowHead = (GeneralPath)this.firstArrowHead.clone();
        }
        if (this.lastArrowHead != null) {
            newPoly.lastArrowHead = (GeneralPath)this.lastArrowHead.clone();
        }
        return newPoly;
    }

    protected void removeArrowHead(int ah) {
        if ((ah == 1 || ah == 3) && this.firstArrowHeadPoint != null) {
            this.getCoordListShape().setX(0, this.firstArrowHeadPoint.getX());
            this.getCoordListShape().setY(0, this.firstArrowHeadPoint.getY());
            this.firstArrowHeadPoint = null;
            this.firstArrowHead = null;
        }
        if ((ah == 2 || ah == 3) && this.lastArrowHeadPoint != null) {
            int last = this.getCoordListShape().getVertexCount() - 1;
            this.getCoordListShape().setX(last, this.lastArrowHeadPoint.getX());
            this.getCoordListShape().setY(last, this.lastArrowHeadPoint.getY());
            this.lastArrowHeadPoint = null;
            this.lastArrowHead = null;
        }
    }

    public int getArrowHead() {
        return this.arrowHead;
    }

    public void setArrowHead(int ah) {
        if (this.arrowHead == 3 && ah == 1) {
            this.removeArrowHead(2);
        } else if (this.arrowHead == 3 && ah == 2) {
            this.removeArrowHead(1);
        } else if (this.arrowHead == 1 && ah == 2) {
            this.removeArrowHead(1);
        } else if (this.arrowHead == 2 && ah == 1) {
            this.removeArrowHead(2);
        } else if (this.arrowHead != 0 && ah == 0) {
            this.removeArrowHead(this.arrowHead);
        }
        this.arrowHead = ah;
        this.updateArrowHeads();
        this.reshape();
    }

    public void setArrowHeadType(int aht) {
        this.arrowHeadType = aht;
        if (this.updateArrowHeads()) {
            this.reshape();
        }
    }

    public void add(double x, double y, int index) {
        super.add(x, y, index);
        if (this.updateArrowHeads()) {
            this.reshape();
        }
    }

    public void setCoords(Point2D pt1, Point2D pt2) {
        super.setCoords(pt1, pt2);
        if (this.updateArrowHeads()) {
            this.reshape();
        }
    }

    public void setCoords(double[] xp, double[] yp) {
        super.setCoords(xp, yp);
        if (this.updateArrowHeads()) {
            this.reshape();
        }
    }

    public void setCoords(Point2D[] points) {
        super.setCoords(points);
        if (this.updateArrowHeads()) {
            this.reshape();
        }
    }

    public void lineTo(double x, double y) {
        super.lineTo(x, y);
        if (this.updateArrowHeads()) {
            this.reshape();
        }
    }

    public void setPenWidth(double width) {
        super.setPenWidth(width);
        if (this.updateArrowHeads()) {
            this.reshape();
        }
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        this.fillPaint = null;
        super.render(renderContext);
        if (this.penPaint != null && this.arrowHead != 0) {
            if (this.firstArrowHead != null) {
                if (this.arrowHeadType == 0) {
                    g2.fill(this.firstArrowHead);
                } else {
                    g2.draw(this.firstArrowHead);
                }
            }
            if (this.lastArrowHead != null) {
                if (this.arrowHeadType == 0) {
                    g2.fill(this.lastArrowHead);
                } else {
                    g2.draw(this.lastArrowHead);
                }
            }
        }
    }

    protected void computeBounds() {
        Rectangle2D r;
        double pw;
        super.computeBounds();
        if (this.firstArrowHead != null) {
            if (this.arrowHeadType == 0) {
                this.bounds.add(this.firstArrowHead.getBounds2D());
            } else {
                pw = this.getPenWidthForCurrentContext();
                r = this.firstArrowHead.getBounds2D();
                r.setRect(r.getX() - pw / 2.0, r.getY() - pw / 2.0, r.getWidth() + pw, r.getHeight() + pw);
                this.bounds.add(r);
            }
        }
        if (this.lastArrowHead != null) {
            if (this.arrowHeadType == 0) {
                this.bounds.add(this.lastArrowHead.getBounds2D());
            } else {
                pw = this.getPenWidthForCurrentContext();
                r = this.lastArrowHead.getBounds2D();
                r.setRect(r.getX() - pw / 2.0, r.getY() - pw / 2.0, r.getWidth() + pw, r.getHeight() + pw);
                this.bounds.add(r);
            }
        }
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.penPaint == null) {
            return false;
        }
        if (this.pickBounds(rect)) {
            double currentPenWidth = this.getPenWidthForCurrentContext();
            if (this.pickStroke(rect, currentPenWidth)) {
                return true;
            }
            Rectangle2D.Double temp = new Rectangle2D.Double();
            ((Rectangle2D)temp).setRect(rect.getX() - currentPenWidth, rect.getY() - currentPenWidth, rect.getWidth() + currentPenWidth * 2.0, rect.getHeight() + currentPenWidth * 2.0);
            boolean picked = false;
            if (this.firstArrowHead != null) {
                picked = this.arrowHeadType == 0 ? this.firstArrowHead.getBounds2D().intersects(rect) : this.firstArrowHead.getBounds2D().intersects(temp);
            }
            if (!picked && this.lastArrowHead != null) {
                picked = this.arrowHeadType == 0 ? this.lastArrowHead.getBounds2D().intersects(rect) : this.lastArrowHead.getBounds2D().intersects(temp);
            }
            return picked;
        }
        return false;
    }

    protected boolean updateArrowHeads() {
        Object head = null;
        PathIterator i = this.getShape().getPathIterator(null);
        double[] coords = new double[6];
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        boolean updated = false;
        if (this.arrowHead == 0) {
            this.firstArrowHead = null;
            this.lastArrowHead = null;
        } else {
            if (this.arrowHead == 1 || this.arrowHead == 3) {
                int cnt = 0;
                while (!i.isDone()) {
                    i.currentSegment(coords);
                    p2.setLocation(p1);
                    ((Point2D)p1).setLocation(coords[0], coords[1]);
                    if (++cnt == 2) break;
                    i.next();
                }
                this.firstArrowHead = this.computeArrowHead(1, p1, p2);
                updated = true;
            }
            if (this.arrowHead == 2 || this.arrowHead == 3) {
                while (!i.isDone()) {
                    i.currentSegment(coords);
                    p1.setLocation(p2);
                    ((Point2D)p2).setLocation(coords[0], coords[1]);
                    i.next();
                }
                this.lastArrowHead = this.computeArrowHead(2, p1, p2);
                updated = true;
            }
        }
        return updated;
    }

    protected GeneralPath computeArrowHead(int ah, Point2D p1, Point2D p2) {
        GeneralPath head;
        Point2D.Double p3 = new Point2D.Double();
        Point2D.Double q1 = new Point2D.Double();
        Point2D.Double q2 = new Point2D.Double();
        double arrowWidth = this.penWidth * 2.0;
        if (p1.equals(p2)) {
            head = null;
        } else {
            head = new GeneralPath(1);
            ((Point2D)p3).setLocation(p2.getX() + arrowWidth * (p1.getX() - p2.getX()) / p1.distance(p2), p2.getY() + arrowWidth * (p1.getY() - p2.getY()) / p1.distance(p2));
            ((Point2D)q1).setLocation(((Point2D)p3).getX() - (p2.getY() - ((Point2D)p3).getY()), ((Point2D)p3).getY() + (p2.getX() - ((Point2D)p3).getX()));
            ((Point2D)q2).setLocation(((Point2D)p3).getX() + (p2.getY() - ((Point2D)p3).getY()), ((Point2D)p3).getY() - (p2.getX() - ((Point2D)p3).getX()));
            if (this.arrowHeadType == 0) {
                head.moveTo((float)p2.getX(), (float)p2.getY());
                head.lineTo((float)((Point2D)q1).getX(), (float)((Point2D)q1).getY());
                head.lineTo((float)((Point2D)q2).getX(), (float)((Point2D)q2).getY());
            } else {
                head.moveTo((float)((Point2D)p3).getX(), (float)((Point2D)p3).getY());
                head.lineTo((float)p2.getX(), (float)p2.getY());
                head.moveTo((float)((Point2D)q1).getX(), (float)((Point2D)q1).getY());
                head.lineTo((float)p2.getX(), (float)p2.getY());
                head.lineTo((float)((Point2D)q2).getX(), (float)((Point2D)q2).getY());
            }
            if (ah == 1) {
                this.firstArrowHeadPoint = new Point2D.Double(this.getCoordListShape().getX(0), this.getCoordListShape().getY(0));
                this.getCoordListShape().setX(0, ((Point2D)p3).getX());
                this.getCoordListShape().setY(0, ((Point2D)p3).getY());
            } else if (ah == 2) {
                int last = this.getCoordListShape().getVertexCount() - 1;
                this.lastArrowHeadPoint = new Point2D.Double(this.getCoordListShape().getX(last), this.getCoordListShape().getY(last));
                this.getCoordListShape().setX(last, ((Point2D)p3).getX());
                this.getCoordListShape().setY(last, ((Point2D)p3).getY());
            }
        }
        return head;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.firstArrowHeadPoint == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeDouble(this.firstArrowHeadPoint.getX());
            out.writeDouble(this.firstArrowHeadPoint.getY());
        }
        if (this.lastArrowHeadPoint == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeDouble(this.lastArrowHeadPoint.getX());
            out.writeDouble(this.lastArrowHeadPoint.getY());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        double y;
        double x;
        in.defaultReadObject();
        if (in.readBoolean()) {
            x = in.readDouble();
            y = in.readDouble();
            this.firstArrowHeadPoint = new Point2D.Double(x, y);
        }
        if (in.readBoolean()) {
            x = in.readDouble();
            y = in.readDouble();
            this.lastArrowHeadPoint = new Point2D.Double(x, y);
        }
        if (this.firstArrowHeadPoint != null || this.lastArrowHeadPoint != null) {
            this.updateArrowHeads();
        }
    }

    static {
        ARROW_NONE = 0;
        ARROW_FIRST = 1;
        ARROW_LAST = 2;
        ARROW_BOTH = 3;
        ARROW_CLOSED = 0;
        ARROW_OPEN = 1;
    }
}

