/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicMenuUI;

public class ZMenu
extends JMenu
implements Serializable {
    ZMouseEvent currentEvent = null;

    public ZMenu() {
        this.init();
    }

    public ZMenu(String s) {
        super(s);
        this.init();
    }

    public ZMenu(String s, boolean b) {
        super(s, b);
        this.init();
    }

    private void init() {
        this.setUI(new ZBasicMenuUI());
    }

    public void setPopupMenuVisible(boolean b) {
        ZMouseEvent event = this.getCurrentEvent();
        if (event != null) {
            if (!this.isEnabled()) {
                return;
            }
            boolean isVisible = this.isPopupMenuVisible();
            if (b != isVisible) {
                if (b && this.isShowing()) {
                    Point swing = this.getTruePopupMenuOrigin();
                    Point jazz = this.getJazzOffset();
                    this.getPopupMenu().show(this, swing.x + jazz.x, swing.y + jazz.y);
                } else {
                    this.getPopupMenu().setVisible(false);
                }
            }
        } else {
            super.setPopupMenuVisible(b);
        }
    }

    protected void setCurrentEvent(ZMouseEvent event) {
        this.currentEvent = event;
    }

    protected ZMouseEvent getCurrentEvent() {
        return this.currentEvent;
    }

    protected Point getTruePopupMenuOrigin() {
        int x = 0;
        int y = 0;
        JPopupMenu pm = this.getPopupMenu();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension s = this.getSize();
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, s.width, s.height);
        this.currentEvent.getPath().getCamera().localToCamera(bounds, this.currentEvent.getNode());
        s.width = (int)(((RectangularShape)bounds).getWidth() + 0.5);
        s.height = (int)(((RectangularShape)bounds).getHeight() + 0.5);
        Dimension pmSize = pm.getSize();
        if (pmSize.width == 0) {
            pmSize = pm.getPreferredSize();
        }
        Point position = this.getTrueLocationOnScreen();
        Container parent = this.getParent();
        if (parent instanceof JPopupMenu) {
            x = this.getComponentOrientation().isLeftToRight() ? (position.x + s.width + pmSize.width < screenSize.width ? s.width : 0 - pmSize.width) : (position.x < pmSize.width ? s.width : 0 - pmSize.width);
            y = position.y + pmSize.height < screenSize.height ? 0 : s.height - pmSize.height;
        } else {
            x = this.getComponentOrientation().isLeftToRight() ? (position.x + pmSize.width < screenSize.width ? 0 : s.width - pmSize.width) : (position.x + s.width < pmSize.width ? 0 : s.width - pmSize.width);
            y = position.y + s.height + pmSize.height < screenSize.height ? s.height : 0 - pmSize.height;
        }
        return new Point(x, y);
    }

    protected Point getTrueLocationOnScreen() {
        Point position = null;
        if (this.isShowing()) {
            Point2D.Double pt = new Point2D.Double(0.0, 0.0);
            Container c = this;
            while (!(c.getParent().getParent() instanceof ZCanvas)) {
                Point location = c.getLocation();
                ((Point2D)pt).setLocation(((Point2D)pt).getX() + location.getX(), ((Point2D)pt).getY() + location.getY());
                c = c.getParent();
            }
            ZCamera camera = this.currentEvent.getPath().getTopCamera();
            camera.localToCamera(pt, this.currentEvent.getNode());
            position = new Point((int)(((Point2D)pt).getX() + 0.5), (int)(((Point2D)pt).getY() + 0.5));
            Point canvasOffset = c.getParent().getParent().getLocationOnScreen();
            position.setLocation(position.getX() + canvasOffset.getX(), position.getY() + canvasOffset.getY());
        }
        return position;
    }

    protected Point getJazzOffset() {
        Point swing = this.getLocationOnScreen();
        Point jazz = this.getTrueLocationOnScreen();
        jazz.setLocation(jazz.getLocation().getX() - swing.getLocation().getX(), jazz.getLocation().getY() - swing.getLocation().getY());
        return jazz;
    }

    class EventGrabber
    extends MouseAdapter {
        EventGrabber() {
        }

        public void mousePressed(MouseEvent me) {
            if (me instanceof ZMouseEvent) {
                ZMenu.this.setCurrentEvent((ZMouseEvent)me);
            }
        }
    }

    class ZBasicMenuUI
    extends BasicMenuUI {
        ZBasicMenuUI() {
        }

        protected void installListeners() {
            this.menuItem.addMouseListener(new EventGrabber());
            super.installListeners();
        }
    }
}

