/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import edu.umd.cs.jazz.component.ZCoordListShape;
import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZBounds;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Vector;

public class ZCoordList
extends ZShape {
    protected transient ZCoordListShape coordListShape;

    public ZCoordList() {
    }

    public ZCoordList(Point2D pt) {
        this(pt.getX(), pt.getY());
    }

    public ZCoordList(Point2D pt1, Point2D pt2) {
        this(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
    }

    public ZCoordList(double x, double y) {
        this();
        this.add(x, y);
    }

    public ZCoordList(double x1, double y1, double x2, double y2) {
        this();
        this.add(x1, y1);
        this.add(x2, y2);
    }

    public ZCoordList(double[] xp, double[] yp) {
        this();
        this.setCoords(xp, yp);
    }

    protected Object duplicateObject() {
        ZCoordList newCoordList = (ZCoordList)super.duplicateObject();
        newCoordList.coordListShape = (ZCoordListShape)this.coordListShape.clone();
        return newCoordList;
    }

    protected ZCoordListShape getCoordListShape() {
        if (this.coordListShape == null) {
            this.coordListShape = new ZCoordListShape();
        }
        return this.coordListShape;
    }

    public boolean isClosed() {
        return this.getCoordListShape().isClosed();
    }

    public void setClosed(boolean closed) {
        this.getCoordListShape().setClosed(closed);
        this.repaint();
    }

    public void add(Point2D pt) {
        this.add(pt.getX(), pt.getY());
    }

    public void add(double x, double y) {
        if (this.getNumberPoints() == 0) {
            this.moveTo(x, y);
        } else {
            this.lineTo(x, y);
        }
    }

    public void add(Point2D pt, int index) {
        this.add(pt.getX(), pt.getY(), index);
    }

    public void add(double x, double y, int index) {
        this.getCoordListShape().insertPoint(index, x, y);
        this.reshape();
    }

    public int getNumberPoints() {
        return this.getCoordListShape().getNumberPoints();
    }

    public Shape getShape() {
        return this.getCoordListShape();
    }

    public double getX(int index) {
        return this.getCoordListShape().getX(index);
    }

    public double getY(int index) {
        return this.getCoordListShape().getY(index);
    }

    public double[] getXCoords() {
        return this.getCoordListShape().getXCoords();
    }

    public double[] getYCoords() {
        return this.getCoordListShape().getYCoords();
    }

    public void lineTo(double x, double y) {
        ZCoordListShape pl;
        this.getCoordListShape().lineTo(x, y);
        double p2 = 0.5 * this.getPenWidth();
        if (!this.bounds.contains(x - p2, y - p2) || !this.bounds.contains(x + p2, y + p2)) {
            this.bounds.add(x - p2, y - p2);
            this.bounds.add(x + p2, y + p2);
            this.updateBounds();
        }
        if ((pl = this.getCoordListShape()).getVertexCount() > 2) {
            int previouseIndex = this.getNumberPoints() - 2;
            ZBounds tmpBounds = new ZBounds();
            tmpBounds.add(x - p2, y - p2);
            tmpBounds.add(x + p2, y + p2);
            tmpBounds.add(this.getX(previouseIndex), this.getY(previouseIndex));
            this.repaint(tmpBounds);
            if (this.isClosed()) {
                this.reshape();
            }
        } else {
            this.reshape();
        }
    }

    public void moveTo(double x, double y) {
        this.getCoordListShape().moveTo(x, y);
        this.reshape();
    }

    public void setCoords(Point2D pt1, Point2D pt2) {
        this.getCoordListShape().reset();
        this.getCoordListShape().moveTo(pt1.getX(), pt1.getY());
        this.getCoordListShape().lineTo(pt2.getX(), pt2.getY());
        this.reshape();
    }

    public void setCoords(double[] xp, double[] yp) {
        this.reset();
        if (xp.length > 0) {
            this.getCoordListShape().moveTo(xp[0], yp[0]);
        }
        int i = 1;
        while (i < xp.length) {
            this.getCoordListShape().lineTo(xp[i], yp[i]);
            ++i;
        }
        this.reshape();
    }

    public void setCoords(Point2D[] points) {
        this.reset();
        if (points.length > 0) {
            this.getCoordListShape().moveTo(points[0].getX(), points[0].getY());
        }
        int i = 1;
        while (i < points.length) {
            this.getCoordListShape().lineTo(points[i].getX(), points[i].getY());
            ++i;
        }
        this.reshape();
    }

    public void reset() {
        this.getCoordListShape().reset();
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        PathIterator i = this.getCoordListShape().getPathIterator(null);
        double[] pathcoords = new double[6];
        Vector<Double> coords = new Vector<Double>();
        while (!i.isDone()) {
            switch (i.currentSegment(pathcoords)) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    coords.add(new Double(pathcoords[0]));
                    coords.add(new Double(pathcoords[1]));
                }
            }
            i.next();
        }
        out.writeState("Vector", "coords", coords);
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("coords") == 0) {
            ZCoordListShape aCoordListShape = this.getCoordListShape();
            Iterator i = ((Vector)fieldValue).iterator();
            while (i.hasNext()) {
                aCoordListShape.lineTo((Double)i.next(), (Double)i.next());
            }
        }
        this.reshape();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ZCoordListShape aCoordListShape = this.getCoordListShape();
        int vertexCount = aCoordListShape.getVertexCount();
        out.writeInt(vertexCount);
        int i = 0;
        while (i < vertexCount) {
            out.writeDouble(aCoordListShape.getX(i));
            out.writeDouble(aCoordListShape.getY(i));
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ZCoordListShape aCoordListShape = this.getCoordListShape();
        int vertexCount = in.readInt();
        int i = 0;
        while (i < vertexCount) {
            aCoordListShape.lineTo(in.readDouble(), in.readDouble());
            ++i;
        }
    }
}

