/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZRoot;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.event.ZEvent;
import edu.umd.cs.jazz.event.ZNodeListener;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZFindFilter;
import edu.umd.cs.jazz.util.ZNoninvertibleTransformException;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphEditor;
import edu.umd.cs.jazz.util.ZSceneGraphEditorFactory;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import edu.umd.cs.jazz.util.ZUtil;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class ZNode
extends ZSceneGraphObject
implements ZSerializable,
Serializable {
    public static final boolean savable_DEFAULT = true;
    public static final boolean pickable_DEFAULT = true;
    public static final boolean findable_DEFAULT = true;
    public static final boolean selectable_DEFAULT = true;
    static final boolean hasNodeListener_DEFAULT = false;
    public static ZSceneGraphEditorFactory editorFactory;
    public ZGroup parent = null;
    private boolean savable = true;
    private boolean pickable = true;
    private boolean findable = true;
    private boolean selectable = true;
    boolean hasNodeListener = false;
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZNodeListener;

    public void addNodeListener(ZNodeListener l) {
        this.getListenerList().add(class$edu$umd$cs$jazz$event$ZNodeListener == null ? (class$edu$umd$cs$jazz$event$ZNodeListener = ZNode.class$("edu.umd.cs.jazz.event.ZNodeListener")) : class$edu$umd$cs$jazz$event$ZNodeListener, l);
        if (!this.hasNodeListener) {
            this.hasNodeListener = true;
            if (this.parent != null) {
                this.parent.updateHasNodeListener();
            }
        }
    }

    protected Object duplicateObject() {
        ZNode newNode = (ZNode)super.duplicateObject();
        newNode.parent = null;
        return newNode;
    }

    public ZSceneGraphEditor editor() {
        return editorFactory.createEditor(this);
    }

    public void extract() {
        this.remove();
    }

    protected int findNodes(ZFindFilter filter, ArrayList nodes) {
        int nodesSearched = 1;
        if (this.findable && filter.accept(this)) {
            nodes.add(this);
        }
        return nodesSearched;
    }

    public ZBounds getGlobalBounds() {
        ZBounds globalBounds = this.getBounds();
        if (this.parent != null) {
            AffineTransform at = this.parent.getLocalToGlobalTransform();
            globalBounds.transform(at);
        }
        return globalBounds;
    }

    public AffineTransform getGlobalToLocalTransform() {
        AffineTransform at = this.getLocalToGlobalTransform();
        AffineTransform globalToLocal = null;
        try {
            globalToLocal = at.createInverse();
        }
        catch (NoninvertibleTransformException exc) {
            throw new ZNoninvertibleTransformException(exc);
        }
        return globalToLocal;
    }

    public AffineTransform getLocalToGlobalTransform() {
        AffineTransform result = null;
        result = this.parent != null ? this.parent.getLocalToGlobalTransform() : new AffineTransform();
        return result;
    }

    public final ZGroup getParent() {
        return this.parent;
    }

    public ZRoot getRoot() {
        ZNode node = this;
        do {
            if (!(node instanceof ZRoot)) continue;
            return (ZRoot)node;
        } while ((node = node.getParent()) != null);
        return null;
    }

    public double globalToLocal(Dimension2D aDimension) {
        AffineTransform at = this.getLocalToGlobalTransform();
        try {
            return ZUtil.inverseTransformDimension(aDimension, at);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public double globalToLocal(Point2D pt) {
        double dz = 1.0;
        AffineTransform at = this.getLocalToGlobalTransform();
        try {
            at.inverseTransform(pt, pt);
            dz = 1.0 / Math.max(at.getScaleX(), at.getScaleY());
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
        return dz;
    }

    public double globalToLocal(Rectangle2D rect) {
        AffineTransform at = this.getLocalToGlobalTransform();
        try {
            return ZUtil.inverseTransformRectangle(rect, at);
        }
        catch (NoninvertibleTransformException e) {
            throw new ZNoninvertibleTransformException(e);
        }
    }

    public final boolean hasNodeListener() {
        return this.hasNodeListener;
    }

    public boolean isAncestorOf(ZNode queryNode) {
        return queryNode.isDescendentOf(this);
    }

    public boolean isDescendentOf(ZNode queryNode) {
        ZGroup node = this.parent;
        boolean found = false;
        while (node != null) {
            if (node == queryNode) {
                found = true;
                break;
            }
            node = node.getParent();
        }
        return found;
    }

    public final boolean isFindable() {
        return this.findable;
    }

    public final boolean isPickable() {
        return this.pickable;
    }

    public final boolean isSavable() {
        return this.savable;
    }

    public final boolean isSelectable() {
        return this.selectable;
    }

    public double localToGlobal(Dimension2D aDimension) {
        AffineTransform at = this.getLocalToGlobalTransform();
        return ZUtil.transformDimension(aDimension, at);
    }

    public double localToGlobal(Point2D pt) {
        AffineTransform at = this.getLocalToGlobalTransform();
        at.transform(pt, pt);
        double dz = Math.max(at.getScaleX(), at.getScaleY());
        return dz;
    }

    public double localToGlobal(Rectangle2D rect) {
        AffineTransform at = this.getLocalToGlobalTransform();
        ZTransformGroup.transform(rect, at);
        double dz = Math.max(at.getScaleX(), at.getScaleY());
        return dz;
    }

    public void lower() {
        if (this.parent != null) {
            this.parent.lower(this);
        }
    }

    public void lowerTo(ZNode beforeNode) {
        if (this.parent != null) {
            if (beforeNode == null) {
                this.parent.lowerTo(this);
            } else {
                this.parent.lowerTo(this, beforeNode);
            }
        }
    }

    protected void percolateEventUpSceneGraph(ZEvent anEvent) {
        ZNode node = this;
        do {
            if (!node.hasNodeListener) continue;
            node.fireEvent(anEvent);
        } while ((node = node.getParent()) != null && !anEvent.isConsumed());
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.pickable && this.getBoundsReference().intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight())) {
            path.setObject(this);
            return true;
        }
        return false;
    }

    public void raise() {
        if (this.parent != null) {
            this.parent.raise(this);
        }
    }

    public void raiseTo(ZNode afterNode) {
        if (this.parent != null) {
            if (afterNode == null) {
                this.parent.raise(this);
            } else {
                this.parent.raiseTo(this, afterNode);
            }
        }
    }

    public void remove() {
        if (this.parent != null) {
            this.getParent().removeChild(this);
        }
    }

    public void removeNodeListener(ZNodeListener l) {
        this.removeEventListener(class$edu$umd$cs$jazz$event$ZNodeListener == null ? (class$edu$umd$cs$jazz$event$ZNodeListener = ZNode.class$("edu.umd.cs.jazz.event.ZNodeListener")) : class$edu$umd$cs$jazz$event$ZNodeListener, l);
        if (this.listenerList == null || this.listenerList.getListenerCount(class$edu$umd$cs$jazz$event$ZNodeListener == null ? (class$edu$umd$cs$jazz$event$ZNodeListener = ZNode.class$("edu.umd.cs.jazz.event.ZNodeListener")) : class$edu$umd$cs$jazz$event$ZNodeListener) == 0) {
            this.hasNodeListener = false;
            if (this.parent != null) {
                this.parent.updateHasNodeListener();
            }
        }
    }

    public void render(ZRenderContext renderContext) {
    }

    public void repaint() {
        if (ZDebug.debugRepaint) {
            System.out.println("ZNode.repaint: this = " + this);
            if (this.parent != null) {
                System.out.println("ZNode.repaint: bounds = " + this.getBounds());
            }
        }
        if (!this.inTransaction && this.parent != null) {
            this.parent.repaint(this.getBounds());
        }
    }

    public void repaint(ZBounds repaintBounds) {
        if (ZDebug.debugRepaint) {
            System.out.println("ZNode.repaint(ZBounds): this = " + this);
            System.out.println("ZNode.repaint(ZBounds): bounds = " + repaintBounds);
        }
        if (!this.inTransaction && this.parent != null) {
            this.parent.repaint(repaintBounds);
        }
    }

    public void reparent(ZGroup newParent) {
        AffineTransform newAT = null;
        ZNode node = this.editor().getNode();
        AffineTransform origAT = node.getLocalToGlobalTransform();
        AffineTransform newParentAT = newParent.getLocalToGlobalTransform();
        try {
            newAT = newParentAT.createInverse();
        }
        catch (NoninvertibleTransformException exc) {
            throw new ZNoninvertibleTransformException(exc);
        }
        newAT.concatenate(origAT);
        ZGroup origParent = this.parent;
        if (this.parent != null) {
            this.parent.removeChild(this, false);
        }
        if (newParent != null) {
            newParent.addChildImpl(this, false);
        }
        if (origParent != null && newParent == null) {
            origParent.childRemovedNotification(this, false);
        } else if (origParent != null) {
            origParent.childRemovedNotification(this, true);
        }
        if (newParent != null && origParent == null) {
            this.parent.childAddedNotification(this, false);
        } else if (newParent != null) {
            this.parent.childAddedNotification(this, true);
        }
        ZTransformGroup transform = node.editor().getTransformGroup();
        transform.setTransform(newAT);
    }

    public void replaceWith(ZNode replacement) {
        ZGroup parent = this.getParent();
        if (parent != null) {
            this.repaint();
            if (parent.children.replaceWith(this, replacement)) {
                this.setParent(null);
                replacement.setParent(parent);
            }
        }
    }

    public static void setEditorFactory(ZSceneGraphEditorFactory factory) {
        editorFactory = factory;
    }

    public void setFindable(boolean findable) {
        this.findable = findable;
    }

    public void setParent(ZGroup newParent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        if (newParent != null) {
            newParent.addChild(this);
        }
    }

    public void setPickable(boolean pickable) {
        this.pickable = pickable;
    }

    public void setSavable(boolean s) {
        this.savable = s;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("pickable") == 0) {
            this.setPickable((Boolean)fieldValue);
        } else if (fieldName.compareTo("findable") == 0) {
            this.setFindable((Boolean)fieldValue);
        } else if (fieldName.compareTo("selectable") == 0) {
            this.setSelectable((Boolean)fieldValue);
        }
    }

    protected void updateBounds() {
        super.updateBounds();
        if (this.parent != null && !this.parent.invalidBounds) {
            this.parent.updateBounds();
        }
    }

    protected void updateVolatility() {
        super.updateVolatility();
        if (this.parent != null && !this.parent.invalidVolatileBounds) {
            this.parent.updateVolatility();
        }
    }

    public void setVolatileBounds(boolean v) {
        super.setVolatileBounds(v);
        if (this.parent != null) {
            this.parent.updateVolatility();
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (!this.pickable) {
            out.writeState("boolean", "pickable", this.pickable);
        }
        if (!this.findable) {
            out.writeState("boolean", "findable", this.findable);
        }
        if (!this.selectable) {
            out.writeState("boolean", "selectable", this.selectable);
        }
    }

    public ZSerializable writeReplace() {
        if (this.savable) {
            return this;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        savable_DEFAULT = true;
        pickable_DEFAULT = true;
        findable_DEFAULT = true;
        selectable_DEFAULT = true;
        hasNodeListener_DEFAULT = false;
        editorFactory = new ZSceneGraphEditorFactory(){

            public ZSceneGraphEditor createEditor(ZNode node) {
                return new ZSceneGraphEditor(node);
            }
        };
    }
}

