/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZHandleGroup;
import edu.umd.cs.jazz.ZLocator;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class ZHandle
extends ZSceneGraphObject {
    public static Paint DEFAULT_FILL_PAINT = Color.gray;
    public static Paint DEFAULT_HIGHLIGHT_FILL_PAINT = Color.lightGray;
    public static Paint DEFAULT_PEN_PAINT = Color.black;
    public static Paint DEFAULT_HIGHLIGHT_PEN_PAINT = Color.black;
    public static double DEFAULT_HANDLE_SIZE = 8.0;
    public static Stroke DEFAULT_STROKE = new BasicStroke(0.0f);
    private ZLocator locator;
    private ZHandleGroup handleGroup;
    private boolean isHighlighted = false;

    public ZHandle(ZLocator aLocator) {
        this.locator = aLocator;
    }

    public static void setDefaultFillPaint(Paint aFillPaint) {
        DEFAULT_FILL_PAINT = aFillPaint;
    }

    public static void setDefaultHighlightFillPaint(Paint aHighlightFillPaint) {
        DEFAULT_HIGHLIGHT_FILL_PAINT = aHighlightFillPaint;
    }

    public static void setDefaultPenPaint(Paint aPenPaint) {
        DEFAULT_PEN_PAINT = aPenPaint;
    }

    public static void setDefaultHighlightPenPaint(Paint aHighlightPenPaint) {
        DEFAULT_HIGHLIGHT_PEN_PAINT = aHighlightPenPaint;
    }

    public static void setDefaultHandleSize(double aHandleSize) {
        DEFAULT_HANDLE_SIZE = aHandleSize;
    }

    public static void setDefaultStroke(Stroke aStroke) {
        DEFAULT_STROKE = aStroke;
    }

    public void computeBounds() {
        Point2D aPoint = this.getLocator().getPoint(null);
        this.bounds.reset();
        this.bounds.setRect(aPoint.getX() - DEFAULT_HANDLE_SIZE / 2.0, aPoint.getY() - DEFAULT_HANDLE_SIZE / 2.0, DEFAULT_HANDLE_SIZE, DEFAULT_HANDLE_SIZE);
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setIsHighlighted(boolean aBoolean) {
        this.isHighlighted = aBoolean;
        if (this.handleGroup != null) {
            this.handleGroup.repaint(this.getBounds());
        }
    }

    public void setLocator(ZLocator aLocator) {
        this.locator = aLocator;
        this.computeBounds();
    }

    public ZLocator getLocator() {
        return this.locator;
    }

    public ZHandleGroup getHandleGroup() {
        return this.handleGroup;
    }

    public void setHandleGroup(ZHandleGroup aHandleGroup) {
        this.handleGroup = aHandleGroup;
    }

    public void render(ZRenderContext aRenderContext) {
        Graphics2D g2 = aRenderContext.getGraphics2D();
        Paint fill = null;
        Paint pen = null;
        if (this.isHighlighted()) {
            fill = DEFAULT_HIGHLIGHT_FILL_PAINT;
            pen = DEFAULT_HIGHLIGHT_PEN_PAINT;
        } else {
            fill = DEFAULT_FILL_PAINT;
            pen = DEFAULT_PEN_PAINT;
        }
        if (fill != null) {
            g2.setPaint(fill);
            g2.fill(this.getBoundsReference());
        }
        if (pen != null) {
            g2.setStroke(DEFAULT_STROKE);
            g2.setPaint(pen);
            g2.draw(this.getBoundsReference());
        }
    }

    public void handleStartDrag(double x, double y) {
    }

    public void handleDragged(double dx, double dy) {
        this.getHandleGroup().relocateHandles();
    }

    public void handleEndDrag(double x, double y) {
    }

    public void handleStartDrag(double x, double y, ZMouseEvent aEvent) {
    }

    public void handleDragged(double dx, double dy, ZMouseEvent aEvent) {
        this.getHandleGroup().relocateHandles();
    }

    public void handleEndDrag(double x, double y, ZMouseEvent aEvent) {
    }
}

